/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Reflection;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.index.lucene.LuceneIndexException;

@Immutable
@ThreadSafe
public final class LuceneConfig {
    protected static final String LAST_SUCCESSFUL_COMMIT_TIME = "last_commit_time";
    private final LockFactory lockFactory;
    private final String directoryClass;
    private final Analyzer analyzer;
    private final Codec codec;
    private final String basePath;
    private final AtomicLong lastSuccessfulCommitTime;

    protected static LuceneConfig inMemory() {
        return new LuceneConfig(null, null, null, null, null, null);
    }

    protected static LuceneConfig onDisk(String baseDir) {
        return new LuceneConfig(baseDir, null, null, null, null, null);
    }

    protected LuceneConfig(String baseDir, String lockFactoryClass, String directoryClass, String analyzerClass, String codecName, Environment environment) {
        this.directoryClass = directoryClass;
        this.lockFactory = this.lockFactory(lockFactoryClass);
        this.analyzer = this.analyzer(analyzerClass, environment);
        this.codec = this.codec(codecName);
        this.basePath = baseDir;
        this.lastSuccessfulCommitTime = new AtomicLong(-1L);
    }

    protected IndexWriter newWriter(String workspaceName, String indexName) {
        CheckArg.isNotNull((Object)indexName, (String)"indexName");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        try {
            Directory directory = this.directory(this.directoryClass, workspaceName, indexName);
            IndexWriter indexWriter = new IndexWriter(directory, this.newIndexWriterConfig());
            if (DirectoryReader.indexExists((Directory)directory)) {
                this.readLatestCommitTime(indexWriter);
            }
            return indexWriter;
        }
        catch (IOException e) {
            throw new LuceneIndexException("Cannot create index writer", e);
        }
    }

    private IndexWriterConfig newIndexWriterConfig() {
        IndexWriterConfig writerConfig = new IndexWriterConfig(this.analyzer);
        writerConfig.setCommitOnClose(true);
        writerConfig.setCodec(this.codec);
        return writerConfig;
    }

    protected SearcherManager searchManager(IndexWriter writer) {
        try {
            return new SearcherManager(writer, true, null);
        }
        catch (IOException e) {
            throw new LuceneIndexException("Cannot create index writer", e);
        }
    }

    protected long lastSuccessfulCommitTime() {
        return this.lastSuccessfulCommitTime.get();
    }

    protected int refreshTimeSeconds() {
        return 30;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    private void readLatestCommitTime(IndexWriter writer) {
        long currentTs;
        Map commitData = writer.getCommitData();
        String timestampString = (String)commitData.get(LAST_SUCCESSFUL_COMMIT_TIME);
        if (timestampString == null) {
            return;
        }
        long timestamp = Long.valueOf(timestampString);
        if (timestamp > (currentTs = this.lastSuccessfulCommitTime.get())) {
            this.lastSuccessfulCommitTime.compareAndSet(currentTs, timestamp);
        }
    }

    private Codec codec(String name) {
        return StringUtil.isBlank((String)name) ? Codec.getDefault() : Codec.forName((String)name);
    }

    private LockFactory lockFactory(String lockFactoryClass) {
        if (StringUtil.isBlank((String)lockFactoryClass)) {
            return null;
        }
        switch (lockFactoryClass) {
            case "org.apache.lucene.store.NativeFSLockFactory": {
                return NativeFSLockFactory.INSTANCE;
            }
            case "org.apache.lucene.store.NoLockFactory": {
                return NoLockFactory.INSTANCE;
            }
            case "org.apache.lucene.store.SimpleFSLockFactory": {
                return SimpleFSLockFactory.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unknown lock factory implementation: " + lockFactoryClass);
    }

    private Analyzer analyzer(String analyzerClass, Environment environment) {
        if (StringUtil.isBlank((String)analyzerClass)) {
            return new StandardAnalyzer();
        }
        return (Analyzer)Reflection.getInstance((String)analyzerClass, (ClassLoader)environment.getClassLoader(this.getClass().getClassLoader(), new String[0]));
    }

    private Directory directory(String directoryClass, String workspaceName, String indexName) throws IOException {
        boolean useLockFactory;
        boolean bl = useLockFactory = this.lockFactory != null;
        if (StringUtil.isBlank((String)this.basePath)) {
            return useLockFactory ? new RAMDirectory(this.lockFactory) : new RAMDirectory();
        }
        Path path = Paths.get(this.basePath, workspaceName, indexName);
        if (StringUtil.isBlank((String)directoryClass)) {
            return useLockFactory ? FSDirectory.open((Path)path, (LockFactory)this.lockFactory) : FSDirectory.open((Path)path);
        }
        switch (directoryClass) {
            case "org.apache.lucene.store.RAMDirectory": {
                return useLockFactory ? new RAMDirectory(this.lockFactory) : new RAMDirectory();
            }
            case "org.apache.lucene.store.MMapDirectory": {
                return useLockFactory ? new MMapDirectory(path, this.lockFactory) : new MMapDirectory(path);
            }
            case "org.apache.lucene.store.NIOFSDirectory": {
                return useLockFactory ? new NIOFSDirectory(path, this.lockFactory) : new NIOFSDirectory(path);
            }
            case "org.apache.lucene.store.SimpleFSDirectory": {
                return useLockFactory ? new SimpleFSDirectory(path, this.lockFactory) : new SimpleFSDirectory(path);
            }
        }
        throw new IllegalArgumentException("Unknown Lucene directory: " + directoryClass);
    }
}

