/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.git;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;

@Immutable
public class Values {
    private final ValueFactories factories;
    private final BinaryStore binaryStore;

    public Values(ValueFactories factories, BinaryStore binaryStore) {
        this.factories = factories;
        this.binaryStore = binaryStore;
    }

    public DateTime dateFrom(int secondsSinceEpoch) {
        long millisSinceEpoch = TimeUnit.MILLISECONDS.convert(secondsSinceEpoch, TimeUnit.SECONDS);
        return (DateTime)this.factories.getDateFactory().create(millisSinceEpoch);
    }

    public Object referenceTo(String id) {
        return this.factories.getReferenceFactory().create(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryValue binaryFor(BinaryKey key, long size) {
        InputStream is = null;
        try {
            is = this.binaryStore.getInputStream(key);
            BinaryValue binaryValue = this.factories.getBinaryFactory().find(key, size);
            return binaryValue;
        }
        catch (BinaryStoreException binaryStoreException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public BinaryValue binaryFrom(InputStream stream) {
        return (BinaryValue)this.factories.getBinaryFactory().create(stream);
    }
}

