/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.spi;

import java.io.Reader;
import java.io.Serializable;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.serialization.impl.CopyTokenStream;
import org.hibernate.search.indexes.serialization.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.spi.SerializableDocValuesType;
import org.hibernate.search.indexes.serialization.spi.SerializableIndex;
import org.hibernate.search.indexes.serialization.spi.SerializableStore;
import org.hibernate.search.indexes.serialization.spi.SerializableTermVector;
import org.hibernate.search.indexes.serialization.spi.SerializableTokenStream;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class LuceneFieldContext {
    private static Log log = LoggerFactory.make();
    private final Field field;
    private final FieldType fieldType;

    public LuceneFieldContext(Field field) {
        this.field = field;
        this.fieldType = field.fieldType();
    }

    public String getName() {
        return this.field.name();
    }

    public SerializableStore getStore() {
        return this.fieldType.stored() ? SerializableStore.YES : SerializableStore.NO;
    }

    public SerializableIndex getIndex() {
        Field.Index index = Field.Index.toIndex((boolean)this.fieldType.indexed(), (boolean)this.fieldType.tokenized(), (boolean)this.fieldType.omitNorms());
        switch (index) {
            case ANALYZED: {
                return SerializableIndex.ANALYZED;
            }
            case ANALYZED_NO_NORMS: {
                return SerializableIndex.ANALYZED_NO_NORMS;
            }
            case NO: {
                return SerializableIndex.NO;
            }
            case NOT_ANALYZED: {
                return SerializableIndex.NOT_ANALYZED;
            }
            case NOT_ANALYZED_NO_NORMS: {
                return SerializableIndex.NOT_ANALYZED_NO_NORMS;
            }
        }
        throw new SearchException("Unable to convert Field.Index value into serializable Index: " + index);
    }

    public SerializableTermVector getTermVector() {
        Field.TermVector vector = Field.TermVector.toTermVector((boolean)this.fieldType.storeTermVectors(), (boolean)this.fieldType.storeTermVectorOffsets(), (boolean)this.fieldType.storeTermVectorPositions());
        switch (vector) {
            case NO: {
                return SerializableTermVector.NO;
            }
            case WITH_OFFSETS: {
                return SerializableTermVector.WITH_OFFSETS;
            }
            case WITH_POSITIONS: {
                return SerializableTermVector.WITH_POSITIONS;
            }
            case WITH_POSITIONS_OFFSETS: {
                return SerializableTermVector.WITH_POSITIONS_OFFSETS;
            }
            case YES: {
                return SerializableTermVector.YES;
            }
        }
        throw new SearchException("Unable to convert Field.TermVector value into serializable TermVector: " + vector);
    }

    public SerializableDocValuesType getDocValuesType() {
        FieldInfo.DocValuesType docValuesType = this.field.fieldType().docValueType();
        switch (docValuesType) {
            case NUMERIC: {
                return SerializableDocValuesType.NUMERIC;
            }
            case SORTED_NUMERIC: {
                return SerializableDocValuesType.SORTED_NUMERIC;
            }
            case BINARY: {
                return SerializableDocValuesType.BINARY;
            }
            case SORTED: {
                return SerializableDocValuesType.SORTED;
            }
            case SORTED_SET: {
                return SerializableDocValuesType.SORTED_SET;
            }
        }
        throw log.unknownDocValuesTypeType(docValuesType.toString());
    }

    public float getBoost() {
        return this.field.boost();
    }

    public boolean isOmitNorms() {
        return this.fieldType.omitNorms();
    }

    public boolean isOmitTermFreqAndPositions() {
        return this.fieldType.indexOptions() == FieldInfo.IndexOptions.DOCS_ONLY;
    }

    public String getStringValue() {
        return this.field.stringValue();
    }

    public byte[] getReaderValue() {
        Reader reader = this.field.readerValue();
        if (reader instanceof Serializable) {
            return SerializationHelper.toByteArray((Serializable)((Object)reader));
        }
        throw new AssertionFailure("Should not call getReaderValue for a non Serializable Reader");
    }

    public SerializableTokenStream getTokenStream() {
        return CopyTokenStream.buildSerializableTokenStream(this.field.tokenStreamValue());
    }

    public BytesRef getBinaryValue() {
        return this.field.binaryValue();
    }
}

