/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.BindVariableValue;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.query.qom.UpperCase;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.api.query.qom.Between;
import org.modeshape.jcr.api.query.qom.SetCriteria;
import org.modeshape.jcr.index.elasticsearch.EsIndexColumn;
import org.modeshape.jcr.index.elasticsearch.EsIndexColumns;
import org.modeshape.jcr.index.elasticsearch.client.EsRequest;
import org.modeshape.jcr.index.elasticsearch.query.AndQuery;
import org.modeshape.jcr.index.elasticsearch.query.BoolQuery;
import org.modeshape.jcr.index.elasticsearch.query.ExistsQuery;
import org.modeshape.jcr.index.elasticsearch.query.MatchAllQuery;
import org.modeshape.jcr.index.elasticsearch.query.MatchQuery;
import org.modeshape.jcr.index.elasticsearch.query.NotQuery;
import org.modeshape.jcr.index.elasticsearch.query.OrQuery;
import org.modeshape.jcr.index.elasticsearch.query.Query;
import org.modeshape.jcr.index.elasticsearch.query.RangeQuery;
import org.modeshape.jcr.index.elasticsearch.query.StringQuery;
import org.modeshape.jcr.index.elasticsearch.query.TermsQuery;
import org.modeshape.jcr.index.elasticsearch.query.WildcardQuery;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.Length;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.NodeDepth;
import org.modeshape.jcr.query.model.NodePath;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.value.ValueFactories;

public class Operations {
    private final ValueFactories valueFactories;
    private final EsIndexColumns columns;
    private final OperandBuilder propertyValueBuilder = new OperandBuilder<PropertyValue>(){

        public String apply(PropertyValue operand, Map<String, Object> variables) {
            return operand.getPropertyName();
        }
    };
    private final StaticOperandBuilder literalBuilder = new StaticOperandBuilder<Literal>(){

        @Override
        public Object apply(String field, Literal op, Map<String, Object> variables) {
            EsIndexColumn col = Operations.this.columns.column(field);
            if (op.value() instanceof Object[]) {
                return col.columnValue(col.cast((Object[])op.value()));
            }
            return col.columnValue(col.cast(op.value()));
        }
    };
    private final StaticOperandBuilder bindVariableBuilder = new StaticOperandBuilder<BindVariableValue>(){

        @Override
        public Object apply(String field, BindVariableValue op, Map<String, Object> variables) {
            EsIndexColumn col = Operations.this.columns.column(field);
            Object value = variables.get(op.getBindVariableName());
            if (value instanceof StaticOperand) {
                return Operations.this.staticOperand((StaticOperand)value).apply(field, (StaticOperand)value, variables);
            }
            if (value instanceof DynamicOperand) {
                return Operations.this.operand((DynamicOperand)value).apply((DynamicOperand)value, variables);
            }
            if (value instanceof Object[]) {
                return col.cast((Object[])value);
            }
            if (value instanceof Collection) {
                return col.cast((Collection)value);
            }
            return col.cast(variables.get(op.getBindVariableName()));
        }
    };
    private final OperandBuilder lowerCaseBuilder = new OperandBuilder<LowerCase>(){

        @Override
        public Object apply(LowerCase op, Map<String, Object> variables) {
            return "lowercase_" + (String)Operations.this.operand(op.getOperand()).apply(op.getOperand(), variables);
        }
    };
    private final OperandBuilder upperCaseBuilder = new OperandBuilder<UpperCase>(){

        @Override
        public Object apply(UpperCase op, Map<String, Object> variables) {
            return "uppercase_" + (String)Operations.this.operand(op.getOperand()).apply(op.getOperand(), variables);
        }
    };
    private final OperandBuilder nodeLocalNameBuilder = new OperandBuilder<NodeLocalName>(){

        public String apply(NodeLocalName op, Map<String, Object> variables) {
            return (String)Operations.this.valueFactories.getStringFactory().create(ModeShapeLexicon.LOCALNAME);
        }
    };
    private final OperandBuilder nodeNameBuilder = new OperandBuilder<NodeName>(){

        public String apply(NodeName op, Map<String, Object> variables) {
            return (String)Operations.this.valueFactories.getStringFactory().create(JcrLexicon.NAME);
        }
    };
    private final OperandBuilder lengthBuilder = new OperandBuilder<Length>(){

        public String apply(Length op, Map<String, Object> variables) {
            return "length_" + op.getPropertyValue().getPropertyName();
        }
    };
    private final OperandBuilder pathBuilder = new OperandBuilder<NodePath>(){

        public String apply(NodePath op, Map<String, Object> variables) {
            return (String)Operations.this.valueFactories.getStringFactory().create(JcrLexicon.PATH);
        }
    };
    private final OperandBuilder depthBuilder = new OperandBuilder<NodeDepth>(){

        public String apply(NodeDepth op, Map<String, Object> variables) {
            return (String)Operations.this.valueFactories.getStringFactory().create(ModeShapeLexicon.DEPTH);
        }
    };

    public Operations(ValueFactories valueFactories, EsIndexColumns columns) {
        this.valueFactories = valueFactories;
        this.columns = columns;
    }

    public EsRequest createQuery(Collection<Constraint> constraints, Map<String, Object> variables) {
        BoolQuery query = new BoolQuery();
        if (constraints.isEmpty()) {
            query.must(new MatchAllQuery());
        }
        for (Constraint c : constraints) {
            query = query.must(this.build(c, variables));
        }
        EsRequest res = new EsRequest();
        res.put("query", query.build());
        return res;
    }

    public Query build(Constraint constraint, Map<String, Object> variables) {
        String field;
        if (constraint instanceof Between) {
            Between between = (Between)constraint;
            String field2 = (String)this.operand(between.getOperand()).apply(between.getOperand(), variables);
            Object low = this.staticOperand(between.getLowerBound()).apply(field2, between.getLowerBound(), variables);
            Object high = this.staticOperand(between.getUpperBound()).apply(field2, between.getUpperBound(), variables);
            return new RangeQuery(field2).from(low).to(high).includeLower(between.isLowerBoundIncluded()).includeUpper(between.isUpperBoundIncluded());
        }
        if (constraint instanceof Or) {
            Or or = (Or)constraint;
            return new OrQuery(this.build((Constraint)or.getConstraint1(), variables), this.build((Constraint)or.getConstraint2(), variables));
        }
        if (constraint instanceof And) {
            And and = (And)constraint;
            return new AndQuery(this.build(and.getConstraint1(), variables), this.build(and.getConstraint2(), variables));
        }
        if (constraint instanceof Not) {
            Not not = (Not)constraint;
            return new NotQuery(this.build(not.getConstraint(), variables));
        }
        if (constraint instanceof Comparison) {
            Comparison comp = (Comparison)constraint;
            field = (String)this.operand((DynamicOperand)comp.getOperand1()).apply(comp.getOperand1(), variables);
            Object value = this.staticOperand((StaticOperand)comp.getOperand2()).apply(field, comp.getOperand2(), variables);
            switch (comp.operator()) {
                case EQUAL_TO: {
                    return new MatchQuery(field, value);
                }
                case GREATER_THAN: {
                    return new RangeQuery(field).gt(value);
                }
                case GREATER_THAN_OR_EQUAL_TO: {
                    return new RangeQuery(field).gte(value);
                }
                case LESS_THAN: {
                    return new RangeQuery(field).lt(value);
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    return new RangeQuery(field).lte(value);
                }
                case NOT_EQUAL_TO: {
                    return new NotQuery(new MatchQuery(field, value));
                }
                case LIKE: {
                    String queryString = (String)value;
                    if (!queryString.contains("%")) {
                        return new StringQuery(queryString);
                    }
                    String[] terms = queryString.split(" ");
                    Query[] termFilters = new Query[terms.length];
                    for (int i = 0; i < termFilters.length; ++i) {
                        termFilters[i] = terms[i].contains("%") ? new WildcardQuery(field, terms[i].replaceAll("%", "*")) : new StringQuery(terms[i]);
                    }
                    if (termFilters.length == 1) {
                        return termFilters[0];
                    }
                    AndQuery builder = new AndQuery(termFilters[0], termFilters[1]);
                    for (int i = 2; i < termFilters.length; ++i) {
                        builder = new AndQuery(builder, termFilters[i]);
                    }
                    return builder;
                }
            }
        }
        if (constraint instanceof SetCriteria) {
            SetCriteria setCriteria = (SetCriteria)constraint;
            field = (String)this.operand(setCriteria.getOperand()).apply(setCriteria.getOperand(), variables);
            ArrayList<Object> list = new ArrayList<Object>();
            for (StaticOperand so : setCriteria.getValues()) {
                Object vals = this.staticOperand(so).apply(field, so, variables);
                if (vals instanceof Object[]) {
                    list.addAll(Arrays.asList((Object[])vals));
                    continue;
                }
                if (vals == null) continue;
                list.add(vals);
            }
            Object[] set = new Object[list.size()];
            list.toArray(set);
            return new TermsQuery(field, set);
        }
        if (constraint instanceof PropertyExistence) {
            PropertyExistence pe = (PropertyExistence)constraint;
            return new ExistsQuery(pe.getPropertyName());
        }
        if (constraint instanceof FullTextSearch) {
            FullTextSearch fts = (FullTextSearch)constraint;
            return new StringQuery(fts.fullTextSearchExpression());
        }
        return null;
    }

    private OperandBuilder operand(DynamicOperand op) {
        if (op instanceof PropertyValue) {
            return this.propertyValueBuilder;
        }
        if (op instanceof NodePath) {
            return this.pathBuilder;
        }
        if (op instanceof NodeDepth) {
            return this.depthBuilder;
        }
        if (op instanceof NodeName) {
            return this.nodeNameBuilder;
        }
        if (op instanceof LowerCase) {
            return this.lowerCaseBuilder;
        }
        if (op instanceof UpperCase) {
            return this.upperCaseBuilder;
        }
        if (op instanceof NodeLocalName) {
            return this.nodeLocalNameBuilder;
        }
        if (op instanceof Length) {
            return this.lengthBuilder;
        }
        return null;
    }

    private StaticOperandBuilder staticOperand(StaticOperand op) {
        if (op instanceof Literal) {
            return this.literalBuilder;
        }
        if (op instanceof BindVariableValue) {
            return this.bindVariableBuilder;
        }
        return null;
    }

    private static abstract class StaticOperandBuilder<T extends StaticOperand> {
        private StaticOperandBuilder() {
        }

        public abstract Object apply(String var1, T var2, Map<String, Object> var3);
    }

    private static abstract class OperandBuilder<T extends DynamicOperand> {
        private OperandBuilder() {
        }

        public abstract Object apply(T var1, Map<String, Object> var2);
    }
}

