/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder;

import java.util.EnumSet;
import java.util.List;
import org.apache.lucene.document.Field;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.internal.util.Strings;
import org.hibernate.hql.lucene.internal.builder.LucenePropertyHelper;
import org.hibernate.hql.lucene.internal.logging.Log;
import org.hibernate.hql.lucene.internal.logging.LoggerFactory;
import org.hibernate.hql.lucene.spi.FieldBridgeProvider;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.spi.SearchIntegrator;

public class ClassBasedLucenePropertyHelper
extends LucenePropertyHelper {
    private static final Log log = LoggerFactory.make();
    private final SearchIntegrator searchFactory;
    private final EntityNamesResolver entityNames;
    private final FieldBridgeProvider fieldBridgeProvider;

    public ClassBasedLucenePropertyHelper(SearchIntegrator searchFactory, EntityNamesResolver entityNames) {
        this(searchFactory, entityNames, null);
    }

    public ClassBasedLucenePropertyHelper(SearchIntegrator searchFactory, EntityNamesResolver entityNames, FieldBridgeProvider fieldBridgeProvider) {
        this.searchFactory = searchFactory;
        this.entityNames = entityNames;
        this.fieldBridgeProvider = fieldBridgeProvider;
    }

    @Override
    public FieldBridge getFieldBridge(String entityType, List<String> propertyPath) {
        if (this.fieldBridgeProvider != null) {
            return this.fieldBridgeProvider.getFieldBridge(entityType, Strings.join(propertyPath, (String)"."));
        }
        Class<?> type = this.getType(entityType);
        String[] propertyPathAsArray = propertyPath.toArray(new String[propertyPath.size()]);
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(this.searchFactory, type);
        if (this.isIdentifierProperty(entityIndexBinding, propertyPathAsArray)) {
            return entityIndexBinding.getDocumentBuilder().getIdBridge();
        }
        PropertyMetadata metadata = this.getLeafTypeMetadata(type, propertyPathAsArray).getPropertyMetadataForProperty(propertyPathAsArray[propertyPathAsArray.length - 1]);
        if (metadata == null) {
            return null;
        }
        return ((DocumentFieldMetadata)metadata.getFieldMetadata().iterator().next()).getFieldBridge();
    }

    private Class<?> getType(String typeName) {
        Class type = this.entityNames.getClassFromName(typeName);
        if (type == null) {
            throw new IllegalStateException("Unknown entity name " + typeName);
        }
        return type;
    }

    public boolean exists(Class<?> type, List<String> propertyPath) {
        return this.exists(type, propertyPath.toArray(new String[propertyPath.size()]));
    }

    public boolean exists(Class<?> type, String ... propertyPath) {
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(type);
        if (this.isIdentifierProperty(entityIndexBinding, propertyPath)) {
            return true;
        }
        TypeMetadata metadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        for (int i = 0; i < propertyPath.length - 1; ++i) {
            List embeddedTypeMetadata = metadata.getEmbeddedTypeMetadata();
            if ((metadata = this.getEmbeddedTypeMetadata(embeddedTypeMetadata, propertyPath[i])) != null) continue;
            return false;
        }
        return metadata.getPropertyMetadataForProperty(propertyPath[propertyPath.length - 1]) != null || this.getEmbeddedTypeMetadata(metadata.getEmbeddedTypeMetadata(), propertyPath[propertyPath.length - 1]) != null;
    }

    private TypeMetadata getLeafTypeMetadata(Class<?> type, String ... propertyPath) {
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(this.searchFactory, type);
        TypeMetadata leafTypeMetadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        for (int i = 0; i < propertyPath.length; ++i) {
            List embeddedTypeMetadata = leafTypeMetadata.getEmbeddedTypeMetadata();
            EmbeddedTypeMetadata metadata = this.getEmbeddedTypeMetadata(embeddedTypeMetadata, propertyPath[i]);
            if (metadata == null) continue;
            leafTypeMetadata = metadata;
        }
        return leafTypeMetadata;
    }

    private EmbeddedTypeMetadata getEmbeddedTypeMetadata(List<EmbeddedTypeMetadata> embeddedTypeMetadata, String name) {
        for (EmbeddedTypeMetadata metadata : embeddedTypeMetadata) {
            if (!metadata.getEmbeddedFieldName().equals(name)) continue;
            return metadata;
        }
        return null;
    }

    public boolean isAnalyzed(Class<?> type, List<String> propertyPath) {
        return this.isAnalyzed(type, propertyPath.toArray(new String[propertyPath.size()]));
    }

    public boolean isAnalyzed(Class<?> type, String ... propertyPath) {
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(type);
        if (this.isIdentifierProperty(entityIndexBinding, propertyPath)) {
            return false;
        }
        TypeMetadata metadata = this.getLeafTypeMetadata(type, propertyPath);
        Field.Index index = ((DocumentFieldMetadata)metadata.getPropertyMetadataForProperty(propertyPath[propertyPath.length - 1]).getFieldMetadata().iterator().next()).getIndex();
        return EnumSet.of(Field.Index.ANALYZED, Field.Index.ANALYZED_NO_NORMS).contains(index);
    }

    public boolean isEmbedded(Class<?> type, List<String> propertyPath) {
        return this.isEmbedded(type, propertyPath.toArray(new String[propertyPath.size()]));
    }

    public boolean isEmbedded(Class<?> type, String ... propertyPath) {
        List embeddedTypeMetadata;
        if (propertyPath.length == 0) {
            return false;
        }
        EntityIndexBinding entityIndexBinding = this.getIndexBinding(type);
        TypeMetadata metadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        for (int i = 0; i < propertyPath.length && (metadata = this.getEmbeddedTypeMetadata(embeddedTypeMetadata = metadata.getEmbeddedTypeMetadata(), propertyPath[i])) != null; ++i) {
        }
        return metadata != null;
    }

    private boolean isIdentifierProperty(EntityIndexBinding entityIndexBinding, String ... propertyPath) {
        return propertyPath.length == 1 && propertyPath[0].equals(entityIndexBinding.getDocumentBuilder().getIdentifierName());
    }

    private EntityIndexBinding getIndexBinding(Class<?> type) {
        return this.getIndexBinding(this.searchFactory, type);
    }

    private EntityIndexBinding getIndexBinding(SearchIntegrator searchFactory, Class<?> type) {
        EntityIndexBinding entityIndexBinding = searchFactory.getIndexBinding(type);
        if (entityIndexBinding == null) {
            throw log.getNoIndexedEntityException(type.getCanonicalName());
        }
        return entityIndexBinding;
    }
}

