/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.lucene.ExternalizerIds;
import org.infinispan.lucene.impl.Operation;

public class AddOperation
implements Operation {
    private final String element;

    AddOperation(String element) {
        this.element = element;
    }

    @Override
    public void apply(Set<String> target) {
        target.add(this.element);
    }

    String getElement() {
        return this.element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddOperation that = (AddOperation)o;
        return this.element.equals(that.element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public static class AddOperationExternalizer
    implements AdvancedExternalizer<AddOperation> {
        public void writeObject(ObjectOutput output, AddOperation addOperation) throws IOException {
            output.writeUTF(addOperation.element);
        }

        public AddOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new AddOperation(input.readUTF());
        }

        public Set<Class<? extends AddOperation>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{AddOperation.class});
        }

        public Integer getId() {
            return ExternalizerIds.FILE_LIST_DELTA_ADD;
        }
    }
}

