/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.jcr.query.qom.Constraint;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CachingWrapperQuery;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LRUQueryCache;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.index.lucene.FieldUtil;
import org.modeshape.jcr.index.lucene.LuceneConfig;
import org.modeshape.jcr.index.lucene.LuceneIndexException;
import org.modeshape.jcr.index.lucene.LuceneIndexProviderI18n;
import org.modeshape.jcr.index.lucene.query.LuceneQueryFactory;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.ResultWriter;
import org.modeshape.jcr.spi.index.provider.Filter;

@Immutable
@ThreadSafe
public class Searcher {
    protected static final float DEFAULT_SCORE = 1.0f;
    private static final Logger LOGGER = Logger.getLogger(Searcher.class);
    private final SearcherManager searchManager;
    private final ScheduledExecutorService searchManagerRefreshService;
    private final ScheduledFuture<?> searchManagerRefreshResult;
    private final QueryCache queryCache;

    protected Searcher(LuceneConfig config, IndexWriter writer, String name) {
        this.searchManager = config.searchManager(writer);
        this.queryCache = new LRUQueryCache(200, 50L);
        this.searchManagerRefreshService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(name + "-lucene-search-manager-refresher"));
        this.searchManagerRefreshResult = this.searchManagerRefreshService.scheduleWithFixedDelay(new SearchManagerRefresher(), 0L, config.refreshTimeSeconds(), TimeUnit.SECONDS);
    }

    protected void close() {
        try {
            this.searchManagerRefreshResult.cancel(true);
            this.searchManagerRefreshService.shutdown();
            this.searchManager.close();
        }
        catch (IOException e) {
            LOGGER.warn((Throwable)e, (I18nResource)LuceneIndexProviderI18n.warnErrorWhileClosingSearcher, new Object[0]);
        }
    }

    protected Filter.Results filter(IndexConstraints indexConstraints, LuceneQueryFactory queryFactory) {
        Query query = this.createQueryFromConstraints(indexConstraints.getConstraints(), queryFactory);
        return new LuceneResults(query, queryFactory.scoreDocuments());
    }

    protected long estimateCardinality(final List<Constraint> andedConstraints, final LuceneQueryFactory queryFactory) throws IOException {
        return this.search(new Searchable<Long>(){

            @Override
            public Long search(IndexSearcher searcher) throws IOException {
                Query query = Searcher.this.createQueryFromConstraints(andedConstraints, queryFactory);
                TotalHitCountCollector results = new TotalHitCountCollector();
                searcher.search(query, (Collector)results);
                return results.getTotalHits();
            }
        }, false, true);
    }

    protected Document loadDocumentById(final String id) throws IOException {
        return this.search(new Searchable<Document>(){

            @Override
            public Document search(IndexSearcher searcher) throws IOException {
                DocumentByIdCollector collector = new DocumentByIdCollector();
                searcher.search((Query)FieldUtil.idQuery(id), (Collector)collector);
                return collector.document();
            }
        }, false, true);
    }

    private Query createQueryFromConstraints(Collection<Constraint> andedConstraints, LuceneQueryFactory queryFactory) {
        if (andedConstraints.isEmpty()) {
            return new MatchAllDocsQuery();
        }
        if (andedConstraints.size() == 1) {
            return queryFactory.createQuery(andedConstraints.iterator().next());
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setDisableCoord(true);
        for (Constraint constraint : andedConstraints) {
            builder.add(queryFactory.createQuery(constraint), BooleanClause.Occur.MUST);
        }
        return builder.build();
    }

    protected void refreshSearchManager(boolean async) {
        try {
            if (!async) {
                this.searchManager.maybeRefreshBlocking();
            } else if (!this.searchManager.maybeRefresh()) {
                LOGGER.debug("Attempted to perform a search manager refresh, but another thread is already doing this.", new Object[0]);
            }
        }
        catch (IOException e) {
            LOGGER.warn((Throwable)e, (I18nResource)LuceneIndexProviderI18n.warnErrorWhileClosingSearcher, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T search(Searchable<T> searchable, boolean useScoring, boolean refreshReader) {
        if (refreshReader) {
            this.refreshSearchManager(false);
        }
        IndexSearcher searcher = null;
        try {
            try {
                searcher = (IndexSearcher)this.searchManager.acquire();
                if (!useScoring) {
                    searcher.setQueryCache(this.queryCache);
                }
                T t = searchable.search(searcher);
                return t;
            }
            finally {
                if (searcher != null) {
                    this.searchManager.release((Object)searcher);
                }
            }
        }
        catch (IOException e) {
            throw new LuceneIndexException(e);
        }
    }

    private static class DocumentByIdCollector
    extends SimpleCollector {
        private LeafReader currentReader;
        private Document document;

        private DocumentByIdCollector() {
        }

        public void collect(int doc) throws IOException {
            if (this.document != null) {
                throw new CollectionTerminatedException();
            }
            this.document = this.currentReader.document(doc);
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            if (this.document != null) {
                throw new CollectionTerminatedException();
            }
            this.currentReader = context.reader();
        }

        public boolean needsScores() {
            return false;
        }

        protected Document document() {
            return this.document;
        }
    }

    protected class SearchManagerRefresher
    implements Runnable {
        protected SearchManagerRefresher() {
        }

        @Override
        public void run() {
            Searcher.this.refreshSearchManager(true);
        }
    }

    protected static interface Searchable<T> {
        public T search(IndexSearcher var1) throws IOException;
    }

    private static class IdsCollector
    extends SimpleCollector {
        private static final Set<String> ID_FIELD_SET = Collections.singleton(":id:");
        private final boolean useScore;
        private final Map<NodeKey, Float> scoresById;
        private LeafReader currentReader;
        private Scorer scorer;

        protected IdsCollector(boolean useScore) {
            this.useScore = useScore;
            this.scoresById = new LinkedHashMap<NodeKey, Float>();
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.currentReader = context.reader();
        }

        public void setScorer(Scorer scorer) throws IOException {
            if (this.useScore) {
                this.scorer = scorer;
            }
        }

        public void collect(int doc) throws IOException {
            Document document = this.currentReader.document(doc, ID_FIELD_SET);
            if (document == null) {
                return;
            }
            String id = document.getBinaryValue(":id:").utf8ToString();
            Float score = Float.valueOf(this.useScore ? this.scorer.score() : 1.0f);
            this.scoresById.put(new NodeKey(id), score);
        }

        public boolean needsScores() {
            return this.useScore;
        }

        protected Map<NodeKey, Float> getScoresById() {
            return this.scoresById;
        }
    }

    private class LuceneResults
    implements Filter.Results {
        private final Query query;
        private final boolean scoreDocuments;
        private int currentBatch;
        private boolean runQuery;
        private List<Float> scores;
        private List<NodeKey> ids;
        private int size;

        protected LuceneResults(Query query, boolean scoreDocuments) {
            this.scoreDocuments = scoreDocuments;
            this.query = scoreDocuments ? query : new CachingWrapperQuery(query, QueryCachingPolicy.ALWAYS_CACHE);
            this.currentBatch = 0;
            this.runQuery = true;
            this.scores = new ArrayList<Float>();
            this.ids = new ArrayList<NodeKey>();
        }

        public boolean getNextBatch(ResultWriter writer, int batchSize) {
            if (this.runQuery) {
                Searcher.this.search(new Searchable<Void>(){

                    @Override
                    public Void search(IndexSearcher searcher) throws IOException {
                        IdsCollector collector = new IdsCollector(LuceneResults.this.scoreDocuments);
                        searcher.search(LuceneResults.this.query, (Collector)collector);
                        for (Map.Entry<NodeKey, Float> entry : collector.getScoresById().entrySet()) {
                            LuceneResults.this.ids.add(entry.getKey());
                            LuceneResults.this.scores.add(entry.getValue());
                        }
                        LuceneResults.this.size = LuceneResults.this.ids.size();
                        LuceneResults.this.runQuery = false;
                        return null;
                    }
                }, this.scoreDocuments, true);
            }
            int startPosition = this.currentBatch * batchSize;
            int endPosition = Math.min(this.size, startPosition + batchSize);
            for (int i = startPosition; i < endPosition; ++i) {
                writer.add(this.ids.get(i), this.scores.get(i).floatValue());
            }
            ++this.currentBatch;
            return endPosition < this.size;
        }

        public void close() {
            this.scores.clear();
            this.ids.clear();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.query.toString());
            sb.append("=").append("[");
            for (int i = 0; i < this.size; ++i) {
                sb.append("(").append(this.ids.get(i)).append(", ").append(this.scores.get(i)).append(")");
                if (i >= this.size - 1) continue;
                sb.append(", ");
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

