/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    AUTHENTICATORS("authenticators"),
    AUTHENTICATOR("authenticator"),
    CACHE_BINARY_STORAGE("cache-binary-storage"),
    COMPOSITE_BINARY_STORAGE("composite-binary-storage"),
    CUSTOM_BINARY_STORAGE("custom-binary-storage"),
    DB_BINARY_STORAGE("db-binary-storage"),
    FILE_BINARY_STORAGE("file-binary-storage"),
    TRANSIENT_BINARY_STORAGE("transient-binary-storage"),
    INDEX_PROVIDER("index-provider"),
    INDEX_PROVIDERS("index-providers"),
    INDEX("index"),
    INDEXES("indexes"),
    NAMED_BINARY_STORE("named-binary-store"),
    PATH_EXPRESSION("path-expression"),
    PROPERTY("property"),
    REPOSITORY("repository"),
    WEBAPP("webapp"),
    SEQUENCER("sequencer"),
    SEQUENCERS("sequencers"),
    TEXT_EXTRACTORS("text-extractors"),
    TEXT_EXTRACTOR("text-extractor"),
    WORKSPACE("workspace"),
    WORKSPACES("workspaces"),
    JOURNALING("journaling"),
    INITIAL_CONTENT("initial-content"),
    NODE_TYPES("node-types"),
    NODE_TYPE("node-type"),
    EXTERNAL_SOURCES("external-sources"),
    SOURCE("source"),
    PROJECTION("projection"),
    REINDEXIG("reindexing");

    private final String name;
    private static final Map<String, Element> attributes;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element attribute : Element.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

