/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.tasks.GlobalKeySetTask;
import org.modeshape.common.logging.Logger;

public class InfinispanUtil {
    protected static final Logger LOGGER = Logger.getLogger(InfinispanUtil.class);

    private InfinispanUtil() {
    }

    public static <K, V, T> T execute(Cache<K, V> cache, Location location, DistributedCallable<K, V, T> callable, Combiner<T> combiner) throws InterruptedException, ExecutionException {
        if (location == null) {
            location = Location.LOCALLY;
        }
        DefaultExecutorService distributedExecutor = new DefaultExecutorService(cache);
        List stores = cache.getCacheConfiguration().persistence().stores();
        boolean shared = stores != null && !stores.isEmpty() && ((StoreConfiguration)stores.get(0)).shared();
        Object result = null;
        if (!shared) {
            List<Future> futures = null;
            switch (location) {
                case EVERYWHERE: {
                    futures = distributedExecutor.submitEverywhere(callable);
                    break;
                }
                case LOCALLY: {
                    futures = Collections.singletonList(distributedExecutor.submit(callable));
                }
            }
            while (futures != null && !futures.isEmpty()) {
                Iterator<Future> futureIter = futures.iterator();
                while (futureIter.hasNext()) {
                    Future future = futureIter.next();
                    try {
                        Object value = future.get(100L, TimeUnit.MILLISECONDS);
                        futureIter.remove();
                        result = combiner.combine(result, value);
                    }
                    catch (TimeoutException timeoutException) {}
                }
                if (!futures.isEmpty()) continue;
                break;
            }
        } else {
            result = distributedExecutor.submit(callable).get();
        }
        return result;
    }

    public static <K, V> Sequence<K> getAllKeys(Cache<K, V> cache) throws InterruptedException, ExecutionException {
        LOGGER.debug("getAllKeys of {0}", new Object[]{cache.getName()});
        Set cacheKeys = GlobalKeySetTask.getGlobalKeySet(cache);
        return new IteratorSequence(cacheKeys.iterator());
    }

    private static final class IteratorSequence<T>
    implements Sequence<T> {
        private final Iterator<T> iterator;

        public IteratorSequence(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public T next() {
            return this.iterator.hasNext() ? (T)this.iterator.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    public static interface Sequence<T> {
        public T next() throws ExecutionException, CancellationException, InterruptedException;

        public boolean hasNext();
    }

    public static interface Combiner<T> {
        public T combine(T var1, T var2) throws InterruptedException, ExecutionException;
    }

    public static enum Location {
        EVERYWHERE,
        LOCALLY;

    }
}

