/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Document;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.AbstractChildReferences;
import org.modeshape.jcr.cache.document.BucketId;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.ValueFactory;

@Immutable
@ThreadSafe
final class BucketedChildReferences
extends AbstractChildReferences {
    private final long size;
    private final int bucketIdLength;
    private final String parentKey;
    private final DocumentTranslator translator;
    private final Map<BucketId, Bucket> rangeBucketsById;
    private final Set<BucketId> bucketIds;

    protected BucketedChildReferences(Document parent, DocumentTranslator translator) {
        this.bucketIdLength = parent.getInteger("$bucketIdLen");
        Long size = parent.getLong("$size");
        this.size = size != null ? size : 0L;
        this.parentKey = translator.getKey(parent);
        this.translator = translator;
        List bucketsArray = parent.getArray("$buckets");
        if (bucketsArray == null) {
            this.bucketIds = Collections.emptySet();
        } else {
            this.bucketIds = new HashSet<BucketId>(bucketsArray.size());
            for (Object bucketId : bucketsArray) {
                this.bucketIds.add(new BucketId(bucketId.toString()));
            }
        }
        this.rangeBucketsById = new LinkedHashMap<BucketId, Bucket>(this.bucketIds.size());
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public int getChildCount(Name name) {
        Bucket bucket = this.bucketFor(name);
        return bucket != null ? bucket.childCount(name) : 0;
    }

    @Override
    public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
        ChildReference ref;
        if (snsIndex != 1) {
            return null;
        }
        Bucket bucket = this.bucketFor(name);
        if (context == null || context.changes() == null) {
            return bucket != null ? bucket.childReferenceFor(name) : null;
        }
        ChildReferences.Changes changes = context.changes();
        ChildReference childReference = ref = bucket != null ? bucket.childReferenceFor(name) : null;
        if (ref == null) {
            Iterator<ChildReferences.ChildInsertions> iterator = changes.insertions(name);
            if (iterator != null && iterator.hasNext()) {
                ChildReferences.ChildInsertions inserted = iterator.next();
                Iterator<ChildReference> iter = inserted.inserted().iterator();
                return iter.hasNext() ? iter.next() : null;
            }
            return null;
        }
        return changes.isRemoved(ref) ? null : ref;
    }

    @Override
    public boolean hasChild(NodeKey key) {
        return this.getChild(key) != null;
    }

    @Override
    public ChildReference getChild(NodeKey key) {
        return this.getChild(key, ChildReferences.NoContext.INSTANCE);
    }

    @Override
    public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
        ChildReferences.Changes changes;
        BucketId bucketId;
        Bucket bucket;
        ChildReference ref = null;
        Iterator<BucketId> iterator = this.bucketIds.iterator();
        while (iterator.hasNext() && (ref = (bucket = this.loadBucket(bucketId = iterator.next())) != null ? bucket.childReferenceFor(key) : null) == null) {
        }
        ChildReferences.Changes changes2 = changes = context != null ? context.changes() : null;
        if (ref == null) {
            return changes != null ? changes.inserted(key) : null;
        }
        return changes != null && changes.isRemoved(ref) ? null : ref;
    }

    @Override
    public boolean allowsSNS() {
        return false;
    }

    @Override
    public Iterator<NodeKey> getAllKeys() {
        Iterator<BucketId> bucketIdsIterator = this.bucketIds.iterator();
        return this.bucketsIterator(null, bucketIdsIterator, new ChildReferenceExtractor<NodeKey>(){

            @Override
            public NodeKey extractFrom(ChildReference ref) {
                return ref.getKey();
            }
        });
    }

    @Override
    public Iterator<ChildReference> iterator(Name name, ChildReferences.Context context) {
        ChildReference ref = this.getChild(name, 1, context);
        return ref != null ? Collections.singletonList(ref).iterator() : Collections.emptyListIterator();
    }

    @Override
    public Iterator<ChildReference> iterator(ChildReferences.Context context) {
        return this.bucketsIterator(context, this.bucketIds.iterator(), new ChildReferenceExtractor<ChildReference>(){

            @Override
            public ChildReference extractFrom(ChildReference ref) {
                return ref;
            }
        });
    }

    private <T> Iterator<T> bucketsIterator(final ChildReferences.Context context, final Iterator<BucketId> bucketIdsIterator, final ChildReferenceExtractor<T> extractor) {
        return new Iterator<T>(){
            private Iterator<ChildReference> activeIterator = null;

            @Override
            public boolean hasNext() {
                while ((this.activeIterator == null || !this.activeIterator.hasNext()) && bucketIdsIterator.hasNext()) {
                    BucketId bucketId = (BucketId)bucketIdsIterator.next();
                    Bucket bucket = BucketedChildReferences.this.loadBucket(bucketId);
                    if (bucket == null) continue;
                    this.activeIterator = bucket.iterator(context);
                }
                return this.activeIterator != null && this.activeIterator.hasNext();
            }

            @Override
            public T next() {
                Object value = null;
                while (this.hasNext() && value == null) {
                    value = extractor.extractFrom(this.activeIterator.next());
                }
                if (value != null) {
                    return value;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<ChildReference> iterator(ChildReferences.Context context, final Collection<?> namePatterns, final NamespaceRegistry registry) {
        LinkedHashSet<BucketId> bucketsToSearch = new LinkedHashSet<BucketId>(namePatterns.size());
        for (Object pattern : namePatterns) {
            if (pattern instanceof Pattern) {
                return super.iterator(context, namePatterns, registry);
            }
            String name = pattern.toString();
            bucketsToSearch.add(new BucketId(name, this.bucketIdLength));
        }
        return this.bucketsIterator(context, bucketsToSearch.iterator(), new ChildReferenceExtractor<ChildReference>(){

            @Override
            public ChildReference extractFrom(ChildReference ref) {
                if (namePatterns.contains(ref.getName().getString(registry))) {
                    return ref;
                }
                return null;
            }
        });
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("BucketedChildReferences[");
        for (Bucket bucket : this.rangeBucketsById.values()) {
            sb.append(bucket).append(System.getProperty("line.separator"));
        }
        sb.append("]");
        return sb;
    }

    protected Bucket bucketFor(Name name) {
        return this.loadBucket(new BucketId(name, this.bucketIdLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bucket loadBucket(BucketId bucketId) {
        Bucket bucket = this.rangeBucketsById.get(bucketId);
        if (bucket != null) {
            return bucket;
        }
        BucketedChildReferences bucketedChildReferences = this;
        synchronized (bucketedChildReferences) {
            bucket = this.rangeBucketsById.get(bucketId);
            if (bucket != null) {
                return bucket;
            }
            bucket = this.translator.loadBucket(this.parentKey, bucketId);
            if (bucket != null) {
                this.rangeBucketsById.put(bucketId, bucket);
            }
            return bucket;
        }
    }

    protected static class Bucket
    implements Iterable<NodeKey> {
        private final BucketId id;
        private final Map<NodeKey, String> childNamesByKey;
        private final Map<String, NodeKey> childKeysByName;
        private final NameFactory nameFactory;
        private final ValueFactory<String> stringValueFactory;

        protected Bucket(BucketId id, Document bucketDoc, DocumentTranslator translator) {
            assert (id != null);
            assert (bucketDoc != null);
            this.id = id;
            this.nameFactory = translator.getNameFactory();
            this.stringValueFactory = translator.getStringFactory();
            if (bucketDoc.isEmpty()) {
                this.childNamesByKey = Collections.emptyMap();
                this.childKeysByName = Collections.emptyMap();
            } else {
                int size = bucketDoc.size();
                this.childNamesByKey = new LinkedHashMap<NodeKey, String>(size);
                this.childKeysByName = new HashMap<String, NodeKey>(size);
                for (Map.Entry entry : bucketDoc.toMap().entrySet()) {
                    NodeKey nodeKey = new NodeKey((String)entry.getKey());
                    String name = entry.getValue().toString();
                    this.childNamesByKey.put(nodeKey, name);
                    this.childKeysByName.put(name, nodeKey);
                }
            }
        }

        protected int childCount(Name name) {
            return this.childKeysByName.containsKey(this.stringValueFactory.create(name)) ? 1 : 0;
        }

        protected ChildReference childReferenceFor(Name name) {
            NodeKey key = this.childKeysByName.get(this.stringValueFactory.create(name));
            return key == null ? null : new ChildReference(key, name, 1);
        }

        protected ChildReference childReferenceFor(NodeKey key) {
            String name = this.childNamesByKey.get(key);
            return name == null ? null : new ChildReference(key, (Name)this.nameFactory.create(name), 1);
        }

        @Override
        public Iterator<NodeKey> iterator() {
            return this.childNamesByKey.keySet().iterator();
        }

        protected Iterator<ChildReference> iterator(ChildReferences.Context context) {
            final ChildReferences.Changes changes = context != null ? context.changes() : null;
            final int removalCount = changes != null ? changes.removalCount() : 0;
            final Iterator<NodeKey> internalIterator = this.childNamesByKey.keySet().iterator();
            return new Iterator<ChildReference>(){
                private ChildReference next = null;

                @Override
                public boolean hasNext() {
                    while (this.next == null && internalIterator.hasNext()) {
                        ChildReference internalRef = Bucket.this.childReferenceFor((NodeKey)internalIterator.next());
                        if (removalCount > 0 && changes.isRemoved(internalRef)) continue;
                        this.next = internalRef;
                        break;
                    }
                    return this.next != null;
                }

                @Override
                public ChildReference next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ChildReference result = this.next;
                    this.next = null;
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("bucket[");
            sb.append("id='").append(this.id).append('\'');
            sb.append(", children=").append(this.childNamesByKey.values());
            sb.append(']');
            return sb.toString();
        }
    }

    static interface ChildReferenceExtractor<T> {
        public T extractFrom(ChildReference var1);
    }
}

