/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import org.mapdb.DB;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.index.local.IndexUpdater;
import org.modeshape.jcr.spi.index.provider.ProvidedIndex;

public abstract class LocalIndex<T>
implements ProvidedIndex<T> {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final String name;
    protected final String workspace;
    protected final IndexUpdater indexUpdater;
    protected final DB db;

    protected LocalIndex(String name, String workspace, DB db) {
        assert (name != null);
        assert (workspace != null);
        this.name = name;
        this.workspace = workspace;
        this.db = db;
        this.indexUpdater = new IndexUpdater(db);
    }

    @Override
    public void add(String nodeKey, String propertyName, T[] values) {
        for (T value : values) {
            this.add(nodeKey, propertyName, value);
        }
    }

    @Override
    public void remove(String nodeKey, String propertyName, T[] values) {
        for (T value : values) {
            this.remove(nodeKey, propertyName, value);
        }
    }

    @Override
    public void commit() {
        this.indexUpdater.commit();
    }
}

