/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.MultiTermQueryConstantScoreWrapper;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.FrequencyTrackingRingBuffer;

public final class UsageTrackingQueryCachingPolicy
implements QueryCachingPolicy {
    private static final int SENTINEL = Integer.MIN_VALUE;
    private final QueryCachingPolicy.CacheOnLargeSegments segmentPolicy;
    private final FrequencyTrackingRingBuffer recentlyUsedFilters;

    private static boolean isPointQuery(Query query) {
        for (Class<?> clazz = query.getClass(); clazz != Query.class; clazz = clazz.getSuperclass()) {
            String simpleName = clazz.getSimpleName();
            if (!simpleName.startsWith("Point") || !simpleName.endsWith("Query")) continue;
            return true;
        }
        return false;
    }

    static boolean isCostly(Query query) {
        return query instanceof MultiTermQuery || query instanceof MultiTermQueryConstantScoreWrapper || UsageTrackingQueryCachingPolicy.isPointQuery(query) || "TermsQuery".equals(query.getClass().getSimpleName());
    }

    static boolean isCheap(Query query) {
        return query instanceof TermQuery;
    }

    public UsageTrackingQueryCachingPolicy(int minIndexSize, float minSizeRatio, int historySize) {
        this(new QueryCachingPolicy.CacheOnLargeSegments(minIndexSize, minSizeRatio), historySize);
    }

    public UsageTrackingQueryCachingPolicy() {
        this(QueryCachingPolicy.CacheOnLargeSegments.DEFAULT, 256);
    }

    private UsageTrackingQueryCachingPolicy(QueryCachingPolicy.CacheOnLargeSegments segmentPolicy, int historySize) {
        this.segmentPolicy = segmentPolicy;
        this.recentlyUsedFilters = new FrequencyTrackingRingBuffer(historySize, Integer.MIN_VALUE);
    }

    protected int minFrequencyToCache(Query query) {
        if (UsageTrackingQueryCachingPolicy.isCostly(query)) {
            return 2;
        }
        if (UsageTrackingQueryCachingPolicy.isCheap(query)) {
            return 20;
        }
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUse(Query query) {
        assert (!(query instanceof BoostQuery));
        assert (!(query instanceof ConstantScoreQuery));
        int hashCode = query.hashCode();
        UsageTrackingQueryCachingPolicy usageTrackingQueryCachingPolicy = this;
        synchronized (usageTrackingQueryCachingPolicy) {
            this.recentlyUsedFilters.add(hashCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int frequency(Query query) {
        assert (!(query instanceof BoostQuery));
        assert (!(query instanceof ConstantScoreQuery));
        int hashCode = query.hashCode();
        UsageTrackingQueryCachingPolicy usageTrackingQueryCachingPolicy = this;
        synchronized (usageTrackingQueryCachingPolicy) {
            return this.recentlyUsedFilters.frequency(hashCode);
        }
    }

    @Override
    public boolean shouldCache(Query query, LeafReaderContext context) throws IOException {
        int minFrequency;
        DisjunctionMaxQuery dmq;
        BooleanQuery bq;
        if (query instanceof MatchAllDocsQuery || query instanceof MatchNoDocsQuery) {
            return false;
        }
        if (query instanceof BooleanQuery && (bq = (BooleanQuery)query).clauses().isEmpty()) {
            return false;
        }
        if (query instanceof DisjunctionMaxQuery && (dmq = (DisjunctionMaxQuery)query).getDisjuncts().isEmpty()) {
            return false;
        }
        if (!this.segmentPolicy.shouldCache(query, context)) {
            return false;
        }
        int frequency = this.frequency(query);
        return frequency >= (minFrequency = this.minFrequencyToCache(query));
    }
}

