/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.jcr.query.qom.Constraint;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LRUQueryCache;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.Bits;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.index.lucene.FieldUtil;
import org.modeshape.jcr.index.lucene.LuceneConfig;
import org.modeshape.jcr.index.lucene.LuceneIndexException;
import org.modeshape.jcr.index.lucene.LuceneIndexProviderI18n;
import org.modeshape.jcr.index.lucene.query.LuceneQueryFactory;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.provider.Filter;

@Immutable
@ThreadSafe
public class Searcher {
    protected static final float DEFAULT_SCORE = 1.0f;
    private static final Logger LOGGER = Logger.getLogger(Searcher.class);
    private static final int MAX_QUERIES_TO_CACHE = 200;
    private static final long MAX_RAM_BYTES_TO_USE = 0x3200000L;
    private static final Set<String> ID_FIELD_SET = Collections.singleton(":id:");
    private final SearcherManager searchManager;
    private final ScheduledExecutorService searchManagerRefreshService;
    private final ScheduledFuture<?> searchManagerRefreshResult;
    private final QueryCache queryCache;

    protected Searcher(LuceneConfig config, IndexWriter writer, String name) {
        this.searchManager = config.searchManager(writer);
        this.queryCache = new LRUQueryCache(200, 0x3200000L);
        this.searchManagerRefreshService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(name + "-lucene-search-manager-refresher"));
        this.searchManagerRefreshResult = this.searchManagerRefreshService.scheduleWithFixedDelay(new SearchManagerRefresher(), 0L, config.refreshTimeSeconds(), TimeUnit.SECONDS);
    }

    protected void close() {
        try {
            this.searchManagerRefreshResult.cancel(true);
            this.searchManagerRefreshService.shutdown();
            this.searchManager.close();
        }
        catch (IOException e) {
            LOGGER.warn((Throwable)e, (I18nResource)LuceneIndexProviderI18n.warnErrorWhileClosingSearcher, new Object[0]);
        }
    }

    protected Filter.Results filter(IndexConstraints indexConstraints, LuceneQueryFactory queryFactory, long cardinalityEstimate) {
        Query query = this.createQueryFromConstraints(indexConstraints.getConstraints(), queryFactory);
        return new LuceneResults(query, queryFactory.scoreDocuments(), cardinalityEstimate);
    }

    protected long estimateCardinality(List<Constraint> andedConstraints, LuceneQueryFactory queryFactory) throws IOException {
        return this.search(searcher -> {
            Query query = this.createQueryFromConstraints(andedConstraints, queryFactory);
            return searcher.count(query);
        }, true);
    }

    protected Document loadDocumentById(String id) throws IOException {
        return this.search(searcher -> {
            DocumentByIdCollector collector = new DocumentByIdCollector();
            searcher.search((Query)FieldUtil.idQuery(id), (Collector)collector);
            return collector.document();
        }, true);
    }

    private Query createQueryFromConstraints(Collection<Constraint> andedConstraints, LuceneQueryFactory queryFactory) {
        if (andedConstraints.isEmpty()) {
            return new MatchAllDocsQuery();
        }
        if (andedConstraints.size() == 1) {
            return queryFactory.createQuery(andedConstraints.iterator().next());
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setDisableCoord(true);
        for (Constraint constraint : andedConstraints) {
            builder.add(queryFactory.createQuery(constraint), BooleanClause.Occur.MUST);
        }
        return builder.build();
    }

    protected void refreshSearchManager(boolean async) {
        try {
            if (!async) {
                this.searchManager.maybeRefreshBlocking();
            } else if (!this.searchManager.maybeRefresh()) {
                LOGGER.debug("Attempted to perform a search manager refresh, but another thread is already doing this.", new Object[0]);
            }
        }
        catch (IOException e) {
            LOGGER.warn((Throwable)e, (I18nResource)LuceneIndexProviderI18n.warnErrorWhileClosingSearcher, new Object[0]);
        }
    }

    protected <T> T search(Searchable<T> searchable, boolean refreshReader) {
        if (refreshReader) {
            this.refreshSearchManager(false);
        }
        IndexSearcher searcher = null;
        try {
            searcher = (IndexSearcher)this.searchManager.acquire();
            searcher.setQueryCache(this.queryCache);
            T t = searchable.search(searcher);
            return t;
        }
        catch (IOException e) {
            throw new LuceneIndexException(e);
        }
        finally {
            if (searcher != null) {
                try {
                    this.searchManager.release((Object)searcher);
                }
                catch (IOException e) {
                    LOGGER.debug((Throwable)e, "Cannot release Lucene searcher", new Object[0]);
                }
            }
        }
    }

    private static class DocumentByIdCollector
    extends SimpleCollector {
        private LeafReader currentReader;
        private Document document;

        private DocumentByIdCollector() {
        }

        public void collect(int doc) throws IOException {
            if (this.document != null) {
                throw new CollectionTerminatedException();
            }
            this.document = this.currentReader.document(doc);
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            if (this.document != null) {
                throw new CollectionTerminatedException();
            }
            this.currentReader = context.reader();
        }

        public boolean needsScores() {
            return false;
        }

        protected Document document() {
            return this.document;
        }
    }

    protected class SearchManagerRefresher
    implements Runnable {
        protected SearchManagerRefresher() {
        }

        @Override
        public void run() {
            Searcher.this.refreshSearchManager(true);
        }
    }

    @FunctionalInterface
    protected static interface Searchable<T> {
        public T search(IndexSearcher var1) throws IOException;
    }

    private static class IdsCollector
    extends SimpleCollector {
        private final float[] scores;
        private BitSet docHits;
        private Scorer scorer;
        private int docBase;
        private Bits liveDocs;

        protected IdsCollector(boolean scoring, int maxDoc) {
            this.scores = scoring ? new float[maxDoc] : null;
            this.docHits = new BitSet(maxDoc);
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.docBase = context.docBase;
            this.liveDocs = context.reader().getLiveDocs();
        }

        public void setScorer(Scorer scorer) throws IOException {
            if (this.isScoring()) {
                this.scorer = scorer;
            }
        }

        public void collect(int doc) throws IOException {
            if (this.liveDocs != null && !this.liveDocs.get(doc)) {
                return;
            }
            int docId = doc + this.docBase;
            if (this.isScoring()) {
                this.scores[docId] = this.scorer.score();
            }
            this.docHits.set(docId);
        }

        public boolean needsScores() {
            return this.isScoring();
        }

        protected BitSet documents() {
            return this.docHits;
        }

        protected Float scoreFor(int docId) {
            return Float.valueOf(this.isScoring() ? this.scores[docId] : 1.0f);
        }

        private boolean isScoring() {
            return this.scores != null;
        }
    }

    private class LuceneResults
    implements Filter.Results {
        private final boolean scoreDocuments;
        private final long size;
        private Query query;
        private Iterator<NodeKey> keysIterator;
        private Iterator<Float> scoresIterator;
        private int currentBatch;

        protected LuceneResults(Query query, boolean scoreDocuments, long size) {
            this.scoreDocuments = scoreDocuments;
            this.query = query;
            this.currentBatch = 0;
            this.size = size;
        }

        public Filter.ResultBatch getNextBatch(int batchSize) {
            int startPosition;
            int endPosition;
            final boolean hasNextBatch = (long)(endPosition = (int)Math.min(this.size, (long)((startPosition = this.currentBatch++ * batchSize) + batchSize))) != this.size;
            final int size = endPosition - startPosition;
            return new Filter.ResultBatch(){
                private int keysCount = 0;
                private int scoresCount = 0;

                public Iterable<NodeKey> keys() {
                    return () -> new Iterator<NodeKey>(){

                        @Override
                        public boolean hasNext() {
                            if (keysCount == size) {
                                return false;
                            }
                            if (LuceneResults.this.keysIterator == null) {
                                this.runQuery();
                            }
                            return LuceneResults.this.keysIterator.hasNext();
                        }

                        @Override
                        public NodeKey next() {
                            if (keysCount++ == size) {
                                throw new NoSuchElementException();
                            }
                            if (LuceneResults.this.keysIterator == null) {
                                this.runQuery();
                            }
                            return (NodeKey)LuceneResults.this.keysIterator.next();
                        }
                    };
                }

                public Iterable<Float> scores() {
                    return () -> new Iterator<Float>(){

                        @Override
                        public boolean hasNext() {
                            if (scoresCount == size) {
                                return false;
                            }
                            if (LuceneResults.this.scoresIterator == null) {
                                this.runQuery();
                            }
                            return LuceneResults.this.scoresIterator.hasNext();
                        }

                        @Override
                        public Float next() {
                            if (scoresCount++ == size) {
                                throw new NoSuchElementException();
                            }
                            if (LuceneResults.this.scoresIterator == null) {
                                this.runQuery();
                            }
                            return (Float)LuceneResults.this.scoresIterator.next();
                        }
                    };
                }

                public boolean hasNext() {
                    return hasNextBatch;
                }

                public int size() {
                    return size;
                }

                private void runQuery() {
                    if (LuceneResults.this.keysIterator == null && LuceneResults.this.scoresIterator == null) {
                        Map results = Searcher.this.search(searcher -> LuceneResults.this.getSearchResults(searcher), true);
                        LuceneResults.this.keysIterator = results.keySet().iterator();
                        LuceneResults.this.scoresIterator = results.values().iterator();
                    }
                }
            };
        }

        private Map<NodeKey, Float> getSearchResults(IndexSearcher searcher) throws IOException {
            IdsCollector collector = new IdsCollector(this.scoreDocuments, searcher.getIndexReader().maxDoc());
            searcher.search(this.query, (Collector)collector);
            BitSet docIds = collector.documents();
            LinkedHashMap<NodeKey, Float> results = new LinkedHashMap<NodeKey, Float>();
            int i = docIds.nextSetBit(0);
            while (i >= 0) {
                try {
                    Document document = searcher.doc(i, ID_FIELD_SET);
                    String id = document.getBinaryValue(":id:").utf8ToString();
                    Float score = collector.scoreFor(i);
                    results.put(new NodeKey(id), score);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                i = docIds.nextSetBit(i + 1);
            }
            return results;
        }

        public void close() {
            this.keysIterator = null;
            this.scoresIterator = null;
            this.query = null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.query.toString());
            sb.append("=").append("[").append(this.size).append(" keys]");
            return sb.toString();
        }
    }
}

