/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import org.apache.lucene.search.Query;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.index.lucene.query.CaseOperations;
import org.modeshape.jcr.index.lucene.query.CompareQuery;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.ValueComparators;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;

@Immutable
public class ComparePathQuery
extends CompareQuery<Path> {
    protected static final CompareQuery.Evaluator<Path> PATH_IS_LESS_THAN = new CompareQuery.Evaluator<Path>(){

        @Override
        public boolean satisfiesConstraint(Path nodePath, Path constraintPath) {
            return ValueComparators.PATH_COMPARATOR.compare(nodePath, constraintPath) < 0;
        }

        public String toString() {
            return " < ";
        }
    };
    protected static final CompareQuery.Evaluator<Path> PATH_IS_LESS_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Path>(){

        @Override
        public boolean satisfiesConstraint(Path nodePath, Path constraintPath) {
            return ValueComparators.PATH_COMPARATOR.compare(nodePath, constraintPath) <= 0;
        }

        public String toString() {
            return " <= ";
        }
    };
    protected static final CompareQuery.Evaluator<Path> PATH_IS_GREATER_THAN = new CompareQuery.Evaluator<Path>(){

        @Override
        public boolean satisfiesConstraint(Path nodePath, Path constraintPath) {
            return ValueComparators.PATH_COMPARATOR.compare(nodePath, constraintPath) > 0;
        }

        public String toString() {
            return " > ";
        }
    };
    protected static final CompareQuery.Evaluator<Path> PATH_IS_GREATER_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Path>(){

        @Override
        public boolean satisfiesConstraint(Path nodePath, Path constraintPath) {
            return ValueComparators.PATH_COMPARATOR.compare(nodePath, constraintPath) >= 0;
        }

        public String toString() {
            return " >= ";
        }
    };

    public static ComparePathQuery createQueryForNodesWithPathGreaterThan(Path constraintPath, String fieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new ComparePathQuery(fieldName, constraintPath, (ValueFactory<Path>)factories.getPathFactory(), (ValueFactory<String>)factories.getStringFactory(), PATH_IS_GREATER_THAN, caseOperation);
    }

    public static ComparePathQuery createQueryForNodesWithPathGreaterThanOrEqualTo(Path constraintPath, String fieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new ComparePathQuery(fieldName, constraintPath, (ValueFactory<Path>)factories.getPathFactory(), (ValueFactory<String>)factories.getStringFactory(), PATH_IS_GREATER_THAN_OR_EQUAL_TO, caseOperation);
    }

    public static ComparePathQuery createQueryForNodesWithPathLessThan(Path constraintPath, String fieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new ComparePathQuery(fieldName, constraintPath, (ValueFactory<Path>)factories.getPathFactory(), (ValueFactory<String>)factories.getStringFactory(), PATH_IS_LESS_THAN, caseOperation);
    }

    public static ComparePathQuery createQueryForNodesWithPathLessThanOrEqualTo(Path constraintPath, String fieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new ComparePathQuery(fieldName, constraintPath, (ValueFactory<Path>)factories.getPathFactory(), (ValueFactory<String>)factories.getStringFactory(), PATH_IS_LESS_THAN_OR_EQUAL_TO, caseOperation);
    }

    protected ComparePathQuery(String fieldName, Path constraintPath, ValueFactory<Path> pathFactory, ValueFactory<String> stringFactory, CompareQuery.Evaluator<Path> evaluator, CaseOperations.CaseOperation caseOperation) {
        super(fieldName, constraintPath, pathFactory, stringFactory, evaluator, caseOperation);
    }

    public Query clone() {
        return new ComparePathQuery(this.field(), (Path)this.constraintValue, (ValueFactory<Path>)this.valueTypeFactory, (ValueFactory<String>)this.stringFactory, this.evaluator, this.caseOperation);
    }
}

