/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.epub;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.xml.SimpleNamespaceContext;
import org.modeshape.sequencer.epub.EpubMetadataProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EpubMetadata {
    static final String[] MIME_TYPE_STRINGS = new String[]{"application/epub+zip"};
    static final String DUBLIN_CORE_PREFIX = "dc";
    static final String DUBLIN_CORE_URI = "http://purl.org/dc/elements/1.1/";
    private List<EpubMetadataProperty> title = new ArrayList<EpubMetadataProperty>();
    private List<EpubMetadataProperty> creator = new ArrayList<EpubMetadataProperty>();
    private List<EpubMetadataProperty> contributor = new ArrayList<EpubMetadataProperty>();
    private List<EpubMetadataProperty> language = new ArrayList<EpubMetadataProperty>();
    private List<EpubMetadataProperty> identifier = new ArrayList<EpubMetadataProperty>();
    private List<EpubMetadataProperty> description = new ArrayList<EpubMetadataProperty>();
    private List<EpubMetadataProperty> publisher = new ArrayList<EpubMetadataProperty>();
    private List<EpubMetadataProperty> rights = new ArrayList<EpubMetadataProperty>();
    private List<EpubMetadataProperty> date = new ArrayList<EpubMetadataProperty>();
    private List<EpubMetadataProperty> alternateScript = new ArrayList<EpubMetadataProperty>();
    private InputStream in;

    public EpubMetadata(InputStream inputStream) {
        this.in = inputStream;
    }

    public boolean check() throws Exception {
        File fileCopy = File.createTempFile("modeshape-sequencer-epub", ".tmp");
        IoUtil.write((InputStream)this.in, (OutputStream)new BufferedOutputStream(new FileOutputStream(fileCopy)));
        List<Object> rootfiles = new ArrayList();
        try (ZipInputStream zipStream = new ZipInputStream(new FileInputStream(fileCopy));){
            rootfiles = this.getRootfiles(zipStream);
        }
        if (!rootfiles.isEmpty()) {
            zipStream = new ZipInputStream(new FileInputStream(fileCopy));
            var4_5 = null;
            try {
                ZipEntry entry = null;
                while ((entry = zipStream.getNextEntry()) != null) {
                    String entryName = entry.getName();
                    if (!rootfiles.contains(entryName)) continue;
                    this.checkRootfile(zipStream, entry);
                }
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (zipStream != null) {
                    if (var4_5 != null) {
                        try {
                            zipStream.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        zipStream.close();
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("No rootfile package found in given EPUB file.");
        }
        boolean deleted = false;
        try {
            deleted = fileCopy.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!deleted) {
            fileCopy.deleteOnExit();
        }
        return true;
    }

    private boolean checkRootfile(ZipInputStream zipStream, ZipEntry entry) throws Exception {
        Node node;
        ArrayList<EpubMetadataProperty> properties = new ArrayList<EpubMetadataProperty>();
        HashMap<String, EpubMetadataProperty> propertiesWithId = new HashMap<String, EpubMetadataProperty>();
        ByteArrayOutputStream content = this.getZipEntryContent(zipStream, entry);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(content.toByteArray()));
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext().setNamespace(DUBLIN_CORE_PREFIX, DUBLIN_CORE_URI));
        XPathExpression expr = xpath.compile("//dc:*");
        NodeList metadata = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < metadata.getLength(); ++i) {
            EpubMetadataProperty property = new EpubMetadataProperty();
            node = metadata.item(i);
            property.setName(node.getLocalName());
            property.setValue(node.getTextContent());
            Node nodeId = node.getAttributes().getNamedItem("id");
            if (nodeId != null) {
                String id = nodeId.getTextContent();
                if (propertiesWithId.containsKey(id)) continue;
                propertiesWithId.put(id, property);
                continue;
            }
            properties.add(property);
        }
        NodeList metadataRefines = doc.getElementsByTagName("meta");
        for (int i = 0; i < metadataRefines.getLength(); ++i) {
            Node languageAttribute;
            String propertyName;
            String refinesId;
            node = metadataRefines.item(i);
            Node refines = node.getAttributes().getNamedItem("refines");
            if (refines == null || !propertiesWithId.containsKey(refinesId = refines.getTextContent().substring(1))) continue;
            EpubMetadataProperty property = (EpubMetadataProperty)propertiesWithId.get(refinesId);
            Node schemeAttribute = node.getAttributes().getNamedItem("scheme");
            if (schemeAttribute != null) {
                property.setScheme(schemeAttribute.getTextContent());
            }
            if ((propertyName = node.getAttributes().getNamedItem("property").getTextContent()).equals("title-type")) {
                property.setTitleType(node.getTextContent());
                continue;
            }
            if (propertyName.equals("identifier-type")) {
                property.setIdentifierType(node.getTextContent());
                continue;
            }
            if (propertyName.equals("metadata-authority")) {
                property.setMetadataAuthority(node.getTextContent());
                continue;
            }
            if (propertyName.equals("role")) {
                property.setRole(node.getTextContent());
                continue;
            }
            if (propertyName.equals("display-seq")) {
                property.setDisplaySeq(Long.parseLong(node.getTextContent()));
                continue;
            }
            if (propertyName.equals("group-position")) {
                property.setGroupPosition(Long.parseLong(node.getTextContent()));
                continue;
            }
            if (propertyName.equals("file-as")) {
                property.setFileAs(node.getTextContent());
                continue;
            }
            if (!propertyName.equals("alternate-script") || (languageAttribute = node.getAttributes().getNamedItem("xml:lang")) == null) continue;
            property.setAlternateScript(new EpubMetadataProperty.AlternateScript(node.getTextContent(), languageAttribute.getTextContent()));
        }
        properties.addAll(propertiesWithId.values());
        for (EpubMetadataProperty prop : properties) {
            String propertyName = prop.getName();
            if (propertyName.equals("identifier")) {
                this.getIdentifier().add(prop);
                continue;
            }
            if (propertyName.equals("title")) {
                this.getTitle().add(prop);
                continue;
            }
            if (propertyName.equals("language")) {
                this.getLanguage().add(prop);
                continue;
            }
            if (propertyName.equals("contributor")) {
                this.getContributor().add(prop);
                continue;
            }
            if (propertyName.equals("creator")) {
                this.getCreator().add(prop);
                continue;
            }
            if (propertyName.equals("description")) {
                this.getDescription().add(prop);
                continue;
            }
            if (propertyName.equals("publisher")) {
                this.getPublisher().add(prop);
                continue;
            }
            if (propertyName.equals("rights")) {
                this.getRights().add(prop);
                continue;
            }
            if (!propertyName.equals("date")) continue;
            this.getDate().add(prop);
        }
        return true;
    }

    private List<String> getRootfiles(ZipInputStream zipStream) throws Exception {
        ArrayList<String> rootfiles = new ArrayList<String>();
        ZipEntry entry = null;
        while ((entry = zipStream.getNextEntry()) != null) {
            String entryName = entry.getName();
            if (!entryName.endsWith("META-INF/container.xml")) continue;
            ByteArrayOutputStream content = this.getZipEntryContent(zipStream, entry);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(content.toByteArray()));
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("/container/rootfiles/rootfile");
            NodeList rootfileNodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < rootfileNodes.getLength(); ++i) {
                Node node = rootfileNodes.item(i);
                rootfiles.add(node.getAttributes().getNamedItem("full-path").getNodeValue());
            }
        }
        return rootfiles;
    }

    private ByteArrayOutputStream getZipEntryContent(ZipInputStream zipStream, ZipEntry entry) throws IOException {
        try (ByteArrayOutputStream content = new ByteArrayOutputStream();){
            int read;
            byte[] bytes = new byte[(int)entry.getSize()];
            while ((read = zipStream.read(bytes, 0, bytes.length)) != -1) {
                content.write(bytes, 0, read);
            }
            ByteArrayOutputStream byteArrayOutputStream = content;
            return byteArrayOutputStream;
        }
    }

    public List<EpubMetadataProperty> getTitle() {
        return this.title;
    }

    public List<EpubMetadataProperty> getCreator() {
        return this.creator;
    }

    public List<EpubMetadataProperty> getContributor() {
        return this.contributor;
    }

    public List<EpubMetadataProperty> getLanguage() {
        return this.language;
    }

    public List<EpubMetadataProperty> getIdentifier() {
        return this.identifier;
    }

    public List<EpubMetadataProperty> getDescription() {
        return this.description;
    }

    public List<EpubMetadataProperty> getPublisher() {
        return this.publisher;
    }

    public List<EpubMetadataProperty> getRights() {
        return this.rights;
    }

    public List<EpubMetadataProperty> getDate() {
        return this.date;
    }

    public List<EpubMetadataProperty> getAlternateScript() {
        return this.alternateScript;
    }
}

