/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.StashApplyFailureException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StashApplyCommand
extends GitCommand<ObjectId> {
    private static final String DEFAULT_REF = "stash@{0}";
    private String stashRef;
    private boolean applyIndex = true;
    private boolean applyUntracked = true;
    private boolean ignoreRepositoryState;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;

    public StashApplyCommand(Repository repo) {
        super(repo);
    }

    public StashApplyCommand setStashRef(String stashRef) {
        this.stashRef = stashRef;
        return this;
    }

    public StashApplyCommand ignoreRepositoryState(boolean willIgnoreRepositoryState) {
        this.ignoreRepositoryState = willIgnoreRepositoryState;
        return this;
    }

    private ObjectId getStashId() throws GitAPIException {
        ObjectId stashId;
        String revision = this.stashRef != null ? this.stashRef : DEFAULT_REF;
        try {
            stashId = this.repo.resolve(revision);
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision), e);
        }
        if (stashId == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision));
        }
        return stashId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObjectId call() throws GitAPIException, WrongRepositoryStateException, NoHeadException, StashApplyFailureException {
        this.checkCallable();
        if (!this.ignoreRepositoryState && this.repo.getRepositoryState() != RepositoryState.SAFE) {
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().stashApplyOnUnsafeRepository, new Object[]{this.repo.getRepositoryState()}));
        }
        ObjectReader reader = this.repo.newObjectReader();
        try {
            ObjectId objectId;
            try {
                boolean ok;
                RevWalk revWalk = new RevWalk(reader);
                ObjectId headCommit = this.repo.resolve("HEAD");
                if (headCommit == null) {
                    throw new NoHeadException(JGitText.get().stashApplyWithoutHead);
                }
                ObjectId stashId = this.getStashId();
                RevCommit stashCommit = revWalk.parseCommit(stashId);
                if (stashCommit.getParentCount() < 2 || stashCommit.getParentCount() > 3) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().stashCommitIncorrectNumberOfParents, stashId.name(), stashCommit.getParentCount()));
                }
                ObjectId headTree = this.repo.resolve("HEAD^{tree}");
                RevCommit stashIndexCommit = revWalk.parseCommit(stashCommit.getParent(1));
                RevCommit stashHeadCommit = stashCommit.getParent(0);
                RevCommit untrackedCommit = null;
                if (this.applyUntracked && stashCommit.getParentCount() == 3) {
                    untrackedCommit = revWalk.parseCommit(stashCommit.getParent(2));
                }
                ResolveMerger merger = (ResolveMerger)this.strategy.newMerger(this.repo);
                merger.setCommitNames(new String[]{"stashed HEAD", "HEAD", "stash"});
                merger.setBase(stashHeadCommit);
                merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                if (!merger.merge(headCommit, stashCommit)) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                DirCache dc = this.repo.lockDirCache();
                DirCacheCheckout dco = new DirCacheCheckout(this.repo, headTree, dc, merger.getResultTreeId());
                dco.setFailOnConflict(true);
                dco.checkout();
                if (this.applyIndex) {
                    ResolveMerger ixMerger = (ResolveMerger)this.strategy.newMerger(this.repo, true);
                    ixMerger.setCommitNames(new String[]{"stashed HEAD", "HEAD", "stashed index"});
                    ixMerger.setBase(stashHeadCommit);
                    ok = ixMerger.merge(headCommit, stashIndexCommit);
                    if (!ok) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                    this.resetIndex(revWalk.parseTree(ixMerger.getResultTreeId()));
                }
                if (untrackedCommit != null) {
                    ResolveMerger untrackedMerger = (ResolveMerger)this.strategy.newMerger(this.repo, true);
                    untrackedMerger.setCommitNames(new String[]{"stashed HEAD", "HEAD", "untracked files"});
                    untrackedMerger.setBase(stashHeadCommit);
                    ok = untrackedMerger.merge(headCommit, untrackedCommit);
                    if (!ok) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                    try {
                        RevTree untrackedTree = revWalk.parseTree(untrackedMerger.getResultTreeId());
                        this.resetUntracked(untrackedTree);
                    }
                    catch (CheckoutConflictException e) {
                        throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                    }
                }
                objectId = stashId;
                Object var17_19 = null;
            }
            catch (JGitInternalException e) {
                throw e;
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().stashApplyFailed, e);
            }
            reader.release();
            return objectId;
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            reader.release();
            throw throwable;
        }
    }

    public void setApplyIndex(boolean applyIndex) {
        this.applyIndex = applyIndex;
    }

    public StashApplyCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public void setApplyUntracked(boolean applyUntracked) {
        this.applyUntracked = applyUntracked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIndex(RevTree tree) throws IOException {
        DirCache dc = this.repo.lockDirCache();
        TreeWalk walk = null;
        try {
            DirCacheBuilder builder = dc.builder();
            walk = new TreeWalk(this.repo);
            walk.addTree(tree);
            walk.addTree(new DirCacheIterator(dc));
            walk.setRecursive(true);
            while (walk.next()) {
                AbstractTreeIterator cIter = walk.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                DirCacheEntry entry = new DirCacheEntry(walk.getRawPath());
                entry.setFileMode(cIter.getEntryFileMode());
                entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                DirCacheIterator dcIter = walk.getTree(1, DirCacheIterator.class);
                if (dcIter != null && dcIter.idEqual(cIter)) {
                    DirCacheEntry indexEntry = dcIter.getDirCacheEntry();
                    entry.setLastModified(indexEntry.getLastModified());
                    entry.setLength(indexEntry.getLength());
                }
                builder.add(entry);
            }
            builder.commit();
            Object var10_9 = null;
            dc.unlock();
            if (walk != null) {
                walk.release();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            dc.unlock();
            if (walk != null) {
                walk.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUntracked(RevTree tree) throws CheckoutConflictException, IOException {
        TreeWalk walk = new TreeWalk(this.repo);
        try {
            walk.addTree(tree);
            walk.addTree(new FileTreeIterator(this.repo));
            walk.setRecursive(true);
            ObjectReader reader = walk.getObjectReader();
            while (walk.next()) {
                AbstractTreeIterator cIter = walk.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                DirCacheEntry entry = new DirCacheEntry(walk.getRawPath());
                entry.setFileMode(cIter.getEntryFileMode());
                entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                FileTreeIterator fIter = walk.getTree(1, FileTreeIterator.class);
                if (fIter != null && fIter.isModified(entry, true, reader)) {
                    throw new CheckoutConflictException(entry.getPathString());
                }
                this.checkoutPath(entry, reader);
            }
            Object var8_7 = null;
            walk.release();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            walk.release();
            throw throwable;
        }
    }

    private void checkoutPath(DirCacheEntry entry, ObjectReader reader) {
        try {
            DirCacheCheckout.checkoutEntry(this.repo, entry, reader);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, entry.getPathString()), e);
        }
    }
}

