/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.modeshape.schematic.DocumentFactory;
import org.modeshape.schematic.SchemaLibrary;
import org.modeshape.schematic.SchematicDb;
import org.modeshape.schematic.SchematicDbProvider;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.Json;
import org.modeshape.schematic.document.ParsingException;
import org.modeshape.schematic.internal.InMemorySchemaLibrary;

public class Schematic
extends DocumentFactory {
    public static final String TYPE_FIELD = "type";

    public static <T extends SchematicDb> T getDb(InputStream configInputStream) throws ParsingException, RuntimeException {
        Document document = Json.read(configInputStream);
        return Schematic.getDb(document, Schematic.class.getClassLoader());
    }

    public static <T extends SchematicDb> T getDb(Document document) throws RuntimeException {
        return Schematic.getDb(document, Schematic.class.getClassLoader());
    }

    public static <T extends SchematicDb> T getDb(Document document, ClassLoader cl) throws RuntimeException {
        String type = document.getString(TYPE_FIELD);
        if (type == null) {
            throw new IllegalArgumentException("The configuration document '" + document + "' does not contain a '" + TYPE_FIELD + "' field");
        }
        ServiceLoader<SchematicDbProvider> providers = ServiceLoader.load(SchematicDbProvider.class, cl);
        ArrayList raisedExceptions = new ArrayList();
        return (T)StreamSupport.stream(providers.spliterator(), false).map(provider -> Schematic.getDbFromProvider(type, document, raisedExceptions, provider)).filter(Objects::nonNull).findFirst().orElseThrow(() -> {
            if (!raisedExceptions.isEmpty()) {
                return (RuntimeException)raisedExceptions.get(0);
            }
            return new RuntimeException("None of the existing persistence providers could return a Schematic DB with type '" + type + "'");
        });
    }

    private static SchematicDb getDbFromProvider(String alias, Document document, List<RuntimeException> raisedExceptions, SchematicDbProvider<?> provider) {
        try {
            return provider.getDB(alias, document);
        }
        catch (RuntimeException re) {
            raisedExceptions.add(re);
            return null;
        }
        catch (Exception e) {
            raisedExceptions.add(new RuntimeException(e));
            return null;
        }
    }

    public static SchemaLibrary createSchemaLibrary() {
        return new InMemorySchemaLibrary("In-memory schema library");
    }

    public static SchemaLibrary createSchemaLibrary(String name) {
        return new InMemorySchemaLibrary(name != null ? name : "In-memory schema library");
    }
}

