/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.ISecurityManagement;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.DelegatingClassLoader;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.subsystem.MappedAttributeDefinition;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.document.Changes;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableArray;
import org.modeshape.schematic.document.EditableDocument;
import org.modeshape.schematic.document.Editor;
import org.wildfly.clustering.jgroups.ChannelFactory;

public class RepositoryService
implements Service<JcrRepository>,
Environment {
    private static final Logger LOG = Logger.getLogger((String)RepositoryService.class.getPackage().getName());
    private final InjectedValue<ModeShapeEngine> engineInjector = new InjectedValue();
    private final InjectedValue<BinaryStorage> binaryStorageInjector = new InjectedValue();
    private final InjectedValue<String> dataDirectoryPathInjector = new InjectedValue();
    private final InjectedValue<ModuleLoader> moduleLoaderInjector = new InjectedValue();
    private final InjectedValue<RepositoryStatistics> monitorInjector = new InjectedValue();
    private final InjectedValue<ChannelFactory> channelFactoryInjector = new InjectedValue();
    private final InjectedValue<ISecurityManagement> securityManagementServiceInjector = new InjectedValue();
    private final RepositoryConfiguration repositoryConfiguration;
    private final Set<ModuleIdentifier> additionalModuleDependencies = new LinkedHashSet<ModuleIdentifier>();
    private String journalPath;
    private String journalRelativeTo;

    public RepositoryService(RepositoryConfiguration repositoryConfiguration, String additionalModuleDependencies) {
        this.repositoryConfiguration = repositoryConfiguration;
        if (!StringUtil.isBlank((String)additionalModuleDependencies)) {
            for (String moduleName : additionalModuleDependencies.split(",")) {
                ModuleIdentifier moduleId = this.moduleIdentifierFromName(moduleName);
                if (moduleId == null) continue;
                this.additionalModuleDependencies.add(moduleId);
            }
        }
    }

    public JcrRepository getValue() throws IllegalStateException, IllegalArgumentException {
        try {
            return this.getEngine().getRepository(this.repositoryName());
        }
        catch (NoSuchRepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    private ModeShapeEngine getEngine() {
        return (ModeShapeEngine)this.engineInjector.getValue();
    }

    public ClassLoader getClassLoader(Object caller, String ... classpathEntries) {
        caller = Objects.requireNonNull(caller, "caller");
        Stream<ModuleIdentifier> optionalModuleIds = Arrays.stream(classpathEntries).filter(Objects::nonNull).map(this::moduleIdentifierFromName).filter(Objects::nonNull);
        List delegatingLoaders = Stream.concat(optionalModuleIds, this.additionalModuleDependencies.stream()).map(moduleId -> {
            try {
                return this.moduleLoader().loadModule(moduleId).getClassLoader();
            }
            catch (ModuleLoadException e) {
                LOG.warnv("Cannot load module from classpath entry with identifier: {0}", moduleId);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        ClassLoader currentLoader = this.getClass().getClassLoader();
        ClassLoader callerLoader = caller.getClass().getClassLoader();
        if (!callerLoader.equals(currentLoader)) {
            if (callerLoader.getParent().equals(currentLoader)) {
                currentLoader = callerLoader;
            } else {
                delegatingLoaders.add(callerLoader);
            }
        }
        return delegatingLoaders.isEmpty() ? currentLoader : new DelegatingClassLoader(currentLoader, delegatingLoaders);
    }

    private ModuleIdentifier moduleIdentifierFromName(String moduleName) {
        if (StringUtil.isBlank((String)moduleName)) {
            return null;
        }
        try {
            return ModuleIdentifier.fromString((String)moduleName.trim());
        }
        catch (IllegalArgumentException e) {
            LOG.warnv("{0} is not a valid module identifier", (Object)moduleName);
            return null;
        }
    }

    public void shutdown() {
    }

    public Channel getChannel(String name) throws Exception {
        ChannelFactory channelFactory = (ChannelFactory)this.channelFactoryInjector.getOptionalValue();
        if (channelFactory != null) {
            return channelFactory.createChannel(name);
        }
        String clusterConfig = this.repositoryConfiguration.getClustering().getConfiguration();
        assert (clusterConfig != null);
        FileInputStream configStream = new FileInputStream(clusterConfig);
        XmlConfigurator configurator = XmlConfigurator.getInstance((InputStream)configStream);
        return new JChannel((ProtocolStackConfigurator)configurator);
    }

    public final String repositoryName() {
        return this.repositoryConfiguration.getName();
    }

    public void start(StartContext arg0) throws StartException {
        ModeShapeEngine engine = this.getEngine();
        try {
            String repositoryName = this.repositoryName();
            BinaryStorage binaryStorageConfig = (BinaryStorage)this.binaryStorageInjector.getValue();
            assert (binaryStorageConfig != null);
            EditableDocument binaryConfig = binaryStorageConfig.getBinaryConfiguration();
            EditableDocument config = Schematic.newDocument((Document)this.repositoryConfiguration.getDocument());
            config.getOrCreateDocument("storage").setDocument("binaryStorage", (Document)binaryConfig);
            if (config.containsField("journaling")) {
                if (StringUtil.isBlank((String)this.journalRelativeTo)) {
                    this.journalRelativeTo = (String)this.getDataDirectoryPathInjector().getValue();
                }
                if (StringUtil.isBlank((String)this.journalPath)) {
                    this.journalPath = "journal";
                }
                String finalJournalLocation = this.journalRelativeTo + "/" + this.journalPath;
                config.getDocument("journaling").setString("location", finalJournalLocation);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debugv("ModeShape configuration for '{0}' repository: {1}", (Object)repositoryName, (Object)config);
                Problems problems = this.repositoryConfiguration.validate();
                if (!problems.isEmpty()) {
                    LOG.debugv("Problems with configuration for '{0}' repository: {1}", (Object)repositoryName, (Object)problems);
                }
            }
            RepositoryConfiguration updatedConfiguration = new RepositoryConfiguration((Document)config, repositoryName);
            engine.deploy(updatedConfiguration.with((Environment)this));
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        ModeShapeEngine engine = this.getEngine();
        if (engine != null) {
            try {
                engine.undeploy(this.repositoryName());
            }
            catch (NoSuchRepositoryException noSuchRepositoryException) {
                // empty catch block
            }
        }
    }

    public void changeField(MappedAttributeDefinition defn, ModelNode newValue) throws RepositoryException, OperationFailedException {
        String fieldName2;
        Editor editor;
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor fieldContainer = editor = config.edit();
        for (String fieldName2 : defn.getPathToContainerOfField()) {
            fieldContainer = editor.getOrCreateDocument(fieldName2);
        }
        Object rawValue = defn.getTypedValue(newValue);
        fieldName2 = defn.getFieldName();
        fieldContainer.set(fieldName2, rawValue);
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeIndexProviderField(MappedAttributeDefinition defn, ModelNode newValue, String indexProviderName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        List<String> pathToContainer = defn.getPathToContainerOfField();
        EditableDocument providers = editor.getOrCreateDocument(pathToContainer.get(0));
        for (String configuredProviderName : providers.keySet()) {
            if (!indexProviderName.equals(configuredProviderName)) continue;
            EditableDocument provider = (EditableDocument)providers.get(configuredProviderName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            provider.set(fieldName, rawValue);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeIndexDefinitionField(MappedAttributeDefinition defn, ModelNode newValue, String indexDefinitionName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        List<String> pathToContainer = defn.getPathToContainerOfField();
        EditableDocument indexes = editor.getOrCreateDocument(pathToContainer.get(0));
        for (String configuredIndexName : indexes.keySet()) {
            if (!indexDefinitionName.equals(configuredIndexName)) continue;
            EditableDocument provider = (EditableDocument)indexes.get(configuredIndexName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            provider.set(fieldName, rawValue);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeSequencerField(MappedAttributeDefinition defn, ModelNode newValue, String sequencerName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        List<String> pathToContainer = defn.getPathToContainerOfField();
        EditableDocument sequencing = editor.getOrCreateDocument(pathToContainer.get(0));
        EditableArray sequencers = sequencing.getOrCreateArray(pathToContainer.get(1));
        for (String configuredSequencerName : sequencers.keySet()) {
            if (!sequencerName.equals(configuredSequencerName)) continue;
            EditableDocument sequencer = (EditableDocument)sequencers.get(configuredSequencerName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            sequencer.set(fieldName, rawValue);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changePersistenceField(MappedAttributeDefinition defn, ModelNode newValue) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        EditableDocument persistence = editor.getOrCreateDocument("storage").getOrCreateDocument("persistence");
        String fieldName = defn.getFieldName();
        Object rawValue = defn.getTypedValue(newValue);
        persistence.set(fieldName, rawValue);
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeSourceField(MappedAttributeDefinition defn, ModelNode newValue, String sourceName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        EditableDocument externalSources = editor.getOrCreateDocument("externalSources");
        EditableDocument externalSource = externalSources.getDocument(sourceName);
        assert (externalSource != null);
        String fieldName = defn.getFieldName();
        Object rawValue = defn.getTypedValue(newValue);
        externalSource.set(fieldName, rawValue);
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeTextExtractorField(MappedAttributeDefinition defn, ModelNode newValue, String extractorName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        List<String> pathToContainer = defn.getPathToContainerOfField();
        EditableDocument textExtracting = editor.getOrCreateDocument(pathToContainer.get(1));
        EditableDocument extractors = textExtracting.getOrCreateDocument(pathToContainer.get(2));
        for (String configuredExtractorName : extractors.keySet()) {
            if (!extractorName.equals(configuredExtractorName)) continue;
            EditableDocument extractor = (EditableDocument)extractors.get(configuredExtractorName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            extractor.set(fieldName, rawValue);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeAuthenticatorField(MappedAttributeDefinition defn, ModelNode newValue, String authenticatorName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        EditableDocument security = editor.getOrCreateDocument("security");
        EditableArray providers = security.getOrCreateArray("providers");
        for (String configuredAuthenticatorName : providers.keySet()) {
            if (!authenticatorName.equals(configuredAuthenticatorName)) continue;
            boolean found = false;
            for (Object nested : providers) {
                EditableDocument doc;
                if (!(nested instanceof EditableDocument) || !(doc = (EditableDocument)nested).getString("name").equals(configuredAuthenticatorName)) continue;
                String fieldName = defn.getFieldName();
                Object rawValue = defn.getTypedValue(newValue);
                doc.set(fieldName, rawValue);
                found = true;
                break;
            }
            if (found) break;
            EditableDocument doc = Schematic.newDocument();
            doc.set("name", (Object)configuredAuthenticatorName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            doc.set(fieldName, rawValue);
            providers.add((Object)doc);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public InjectedValue<BinaryStorage> getBinaryStorageInjector() {
        return this.binaryStorageInjector;
    }

    public InjectedValue<RepositoryStatistics> getMonitorInjector() {
        return this.monitorInjector;
    }

    public InjectedValue<ModeShapeEngine> getEngineInjector() {
        return this.engineInjector;
    }

    public InjectedValue<String> getDataDirectoryPathInjector() {
        return this.dataDirectoryPathInjector;
    }

    public InjectedValue<ModuleLoader> getModuleLoaderInjector() {
        return this.moduleLoaderInjector;
    }

    public InjectedValue<ISecurityManagement> getSecurityManagementServiceInjector() {
        return this.securityManagementServiceInjector;
    }

    public InjectedValue<ChannelFactory> getChannelFactoryInjector() {
        return this.channelFactoryInjector;
    }

    private ModuleLoader moduleLoader() {
        return (ModuleLoader)this.moduleLoaderInjector.getValue();
    }

    public void setJournalPath(String journalPath) {
        this.journalPath = journalPath;
    }

    public void setJournalRelativeTo(String journalRelativeTo) {
        this.journalRelativeTo = journalRelativeTo;
    }
}

