/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.Properties;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.AuthenticatorService;
import org.modeshape.jboss.subsystem.AddressContext;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;

public class AddAuthenticator
extends AbstractAddStepHandler {
    public static final AddAuthenticator INSTANCE = new AddAuthenticator();

    private AddAuthenticator() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddAuthenticator.populate(operation, model);
    }

    static void populate(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.AUTHENTICATOR_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceTarget target = context.getServiceTarget();
        Properties props = new Properties();
        AddressContext addressContext = AddressContext.forOperation(operation);
        String repositoryName = addressContext.repositoryName();
        String authenticatorName = addressContext.lastPathElementValue();
        props.put("name", authenticatorName);
        for (String key : operation.keys()) {
            ModelNode node;
            if (key.equals("address") || key.equals("operation") || key.equals("operation-headers") || !(node = operation.get(key)).isDefined()) continue;
            if (key.equals("classname") && ModelAttributes.AUTHENTICATOR_CLASSNAME.isMarshallable(operation)) {
                props.put("classname", node.asString());
                continue;
            }
            if (key.equals("module") && ModelAttributes.MODULE.isMarshallable(operation)) {
                props.put("classloader", node.asString());
                continue;
            }
            if (key.equals("properties")) {
                for (Property property : node.asPropertyList()) {
                    props.put(property.getName(), property.getValue().asString());
                }
                continue;
            }
            props.put(key, node.asString());
        }
        AuthenticatorService authenticatorService = new AuthenticatorService(repositoryName, props);
        ServiceName serviceName = ModeShapeServiceNames.authenticatorServiceName(repositoryName, authenticatorName);
        ServiceBuilder authenticatorBuilder = target.addService(serviceName, (Service)authenticatorService);
        authenticatorBuilder.addDependency(ModeShapeServiceNames.ENGINE, ModeShapeEngine.class, authenticatorService.getModeShapeEngineInjector());
        authenticatorBuilder.addDependency(ModeShapeServiceNames.repositoryServiceName(repositoryName), JcrRepository.class, authenticatorService.getJcrRepositoryInjector());
        authenticatorBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

