/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.PersistenceService;
import org.modeshape.jboss.subsystem.AddressContext;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.schematic.DocumentFactory;
import org.modeshape.schematic.document.EditableDocument;

public class AddFilePersistence
extends AbstractAddStepHandler {
    public static final AddFilePersistence INSTANCE = new AddFilePersistence();

    private AddFilePersistence() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.PERSISTENCE_FS_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        AddressContext addressContext = AddressContext.forOperation(operation);
        String repositoryName = addressContext.repositoryName();
        String type = addressContext.lastPathElementValue();
        EditableDocument persistenceConfig = DocumentFactory.newDocument();
        persistenceConfig.setString("type", "file");
        ModelNode path = ModelAttributes.FS_PATH.resolveModelAttribute(context, operation);
        String pathString = path.isDefined() ? path.asString() : "${jboss.server.data.dir}/modeshape/" + repositoryName;
        persistenceConfig.setString(ModelAttributes.FS_PATH.getFieldName(), pathString);
        ModelNode compress = ModelAttributes.FS_COMPRESS.resolveModelAttribute(context, operation);
        if (compress.isDefined()) {
            persistenceConfig.setBoolean(ModelAttributes.FS_COMPRESS.getFieldName(), compress.asBoolean());
        }
        PersistenceService persistenceService = new PersistenceService(repositoryName, persistenceConfig);
        ServiceBuilder serviceBuilder = target.addService(ModeShapeServiceNames.persistenceFSServiceName(repositoryName, type), (Service)persistenceService);
        serviceBuilder.addDependency(ModeShapeServiceNames.ENGINE, ModeShapeEngine.class, persistenceService.getModeShapeEngineInjector());
        serviceBuilder.addDependency(ModeShapeServiceNames.repositoryServiceName(repositoryName), JcrRepository.class, persistenceService.getJcrRepositoryInjector());
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        serviceBuilder.install();
    }
}

