/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.lifecycle.JBossLifeCycleListener;
import org.modeshape.jboss.service.EngineService;
import org.modeshape.jboss.service.ReferenceFactoryService;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.ModeShapeEngine;

class AddModeShapeSubsystem
extends AbstractAddStepHandler {
    public static final AddModeShapeSubsystem INSTANCE = new AddModeShapeSubsystem();

    AddModeShapeSubsystem() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.SUBSYSTEM_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        this.initializeModeShapeEngine(context);
    }

    private void initializeModeShapeEngine(OperationContext context) {
        ServiceTarget target = context.getServiceTarget();
        JBossLifeCycleListener shutdownListener = new JBossLifeCycleListener();
        EngineService engine = new EngineService(new ModeShapeEngine());
        ServiceBuilder engineBuilder = target.addService(ModeShapeServiceNames.ENGINE, (Service)engine);
        ServiceController controller = engineBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        controller.getServiceContainer().addTerminateListener((ServiceContainer.TerminateListener)shutdownListener);
        ReferenceFactoryService referenceFactoryService = new ReferenceFactoryService();
        ServiceName referenceFactoryServiceName = ModeShapeServiceNames.ENGINE.append(new String[]{"reference-factory"});
        ServiceBuilder referenceBuilder = target.addService(referenceFactoryServiceName, referenceFactoryService);
        referenceBuilder.addDependency(ModeShapeServiceNames.ENGINE, ModeShapeEngine.class, referenceFactoryService.getInjector());
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)"jcr/");
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binderService);
        binderBuilder.addDependency(ModeShapeServiceNames.ENGINE, ModeShapeEngine.class, (Injector)new ManagedReferenceInjector((Injector)binderService.getManagedObjectInjector()));
        binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector());
        Logger.getLogger(((Object)((Object)this)).getClass()).debugv("Binding ModeShape to JNDI name {0}", (Object)bindInfo.getAbsoluteJndiName());
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

