/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.services.path.RelativePathService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.security.service.SecurityManagementService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.ISecurityManagement;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jboss.metric.ModelMetrics;
import org.modeshape.jboss.metric.MonitorService;
import org.modeshape.jboss.security.JBossDomainAuthenticationProvider;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.service.BinaryStorageService;
import org.modeshape.jboss.service.ReferenceFactoryService;
import org.modeshape.jboss.service.RepositoryService;
import org.modeshape.jboss.subsystem.AddressContext;
import org.modeshape.jboss.subsystem.ModeShapeJndiNames;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableArray;
import org.modeshape.schematic.document.EditableDocument;
import org.wildfly.clustering.jgroups.ChannelFactory;

public class AddRepository
extends AbstractAddStepHandler {
    public static final AddRepository INSTANCE = new AddRepository();
    private static final Logger LOG = Logger.getLogger((String)AddRepository.class.getPackage().getName());

    private AddRepository() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.REPOSITORY_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
        for (AttributeDefinition attributeDefinition : ModelMetrics.ALL_METRICS) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    private ModelNode attribute(OperationContext context, ModelNode model, AttributeDefinition defn) throws OperationFailedException {
        assert (defn.getDefaultValue() != null && defn.getDefaultValue().isDefined());
        return defn.resolveModelAttribute(context, model);
    }

    private String attribute(OperationContext context, ModelNode model, AttributeDefinition defn, String defaultValue) throws OperationFailedException {
        ModelNode value = defn.resolveModelAttribute(context, model);
        return value.isDefined() ? value.asString() : defaultValue;
    }

    private Integer intAttribute(OperationContext context, ModelNode model, AttributeDefinition defn, Integer defaultValue) throws OperationFailedException {
        ModelNode value = defn.resolveModelAttribute(context, model);
        if (value == null || !value.isDefined()) {
            return defaultValue;
        }
        return value.asInt();
    }

    private Long longAttribute(OperationContext context, ModelNode model, AttributeDefinition defn, Long defaultValue) throws OperationFailedException {
        ModelNode value = defn.resolveModelAttribute(context, model);
        if (value == null || !value.isDefined()) {
            return defaultValue;
        }
        return value.asLong();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        AddressContext addressContext = AddressContext.forOperation(operation);
        String repositoryName = addressContext.repositoryName();
        String clusterName = this.attribute(context, model, (AttributeDefinition)ModelAttributes.CLUSTER_NAME, null);
        boolean enableMonitoring = this.attribute(context, model, (AttributeDefinition)ModelAttributes.ENABLE_MONITORING).asBoolean();
        String gcThreadPool = this.attribute(context, model, (AttributeDefinition)ModelAttributes.GARBAGE_COLLECTION_THREAD_POOL, null);
        String gcInitialTime = this.attribute(context, model, (AttributeDefinition)ModelAttributes.GARBAGE_COLLECTION_INITIAL_TIME, null);
        int gcIntervalInHours = this.attribute(context, model, (AttributeDefinition)ModelAttributes.GARBAGE_COLLECTION_INTERVAL).asInt();
        String optThreadPool = this.attribute(context, model, (AttributeDefinition)ModelAttributes.DOCUMENT_OPTIMIZATION_THREAD_POOL, null);
        String optInitialTime = this.attribute(context, model, (AttributeDefinition)ModelAttributes.DOCUMENT_OPTIMIZATION_INITIAL_TIME, null);
        int optIntervalInHours = this.attribute(context, model, (AttributeDefinition)ModelAttributes.DOCUMENT_OPTIMIZATION_INTERVAL).asInt();
        Integer optTarget = this.intAttribute(context, model, (AttributeDefinition)ModelAttributes.DOCUMENT_OPTIMIZATION_CHILD_COUNT_TARGET, null);
        Integer eventBusSize = this.intAttribute(context, model, (AttributeDefinition)ModelAttributes.EVENT_BUS_SIZE, null);
        Integer optTolerance = this.intAttribute(context, model, (AttributeDefinition)ModelAttributes.DOCUMENT_OPTIMIZATION_CHILD_COUNT_TOLERANCE, null);
        Long lockTimeoutMillis = this.longAttribute(context, model, (AttributeDefinition)ModelAttributes.LOCK_TIMEOUT_MILLIS, null);
        EditableDocument configDoc = Schematic.newDocument();
        configDoc.set("name", (Object)repositoryName);
        configDoc.set("jndiName", (Object)"");
        String jndiName = "jcr/" + repositoryName;
        String jndiAlias = ModeShapeJndiNames.jndiNameFrom(model, repositoryName);
        if (jndiName.equals(jndiAlias)) {
            jndiAlias = null;
        }
        if (eventBusSize != null) {
            configDoc.setNumber("eventBusSize", eventBusSize.intValue());
        }
        if (lockTimeoutMillis != null) {
            configDoc.setNumber("lockTimeoutMillis", lockTimeoutMillis.longValue());
        }
        ArrayList<String> additionalClasspathEntries = new ArrayList<String>();
        this.enableMonitoring(enableMonitoring, configDoc);
        this.parseCustomNodeTypes(model, configDoc, additionalClasspathEntries);
        EditableDocument workspacesDoc = this.parseWorkspaces(context, model, configDoc, additionalClasspathEntries);
        this.parseSecurity(context, model, configDoc);
        RepositoryConfiguration repositoryConfig = new RepositoryConfiguration((Document)configDoc, repositoryName);
        String additionalModuleDependencies = this.attribute(context, model, (AttributeDefinition)ModelAttributes.REPOSITORY_MODULE_DEPENDENCIES, null);
        RepositoryService repositoryService = new RepositoryService(repositoryConfig, additionalModuleDependencies);
        ServiceName repositoryServiceName = ModeShapeServiceNames.repositoryServiceName(repositoryName);
        this.parseSequencing(model, configDoc);
        this.parseTextExtraction(model, configDoc);
        this.parseReindexing(model, configDoc);
        this.parseJournaling(repositoryService, context, model, configDoc);
        ServiceBuilder repositoryServiceBuilder = target.addService(repositoryServiceName, (Service)repositoryService);
        repositoryServiceBuilder.addDependency(ModeShapeServiceNames.ENGINE, ModeShapeEngine.class, repositoryService.getEngineInjector());
        repositoryServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        if (gcThreadPool != null) {
            configDoc.getOrCreateDocument("garbageCollection").setString("threadPool", gcThreadPool);
        }
        if (gcInitialTime != null) {
            configDoc.getOrCreateDocument("garbageCollection").setString("initialTime", gcInitialTime);
        }
        configDoc.getOrCreateDocument("garbageCollection").setNumber("intervalInHours", gcIntervalInHours);
        if (optTarget != null) {
            EditableDocument docOpt = configDoc.getOrCreateDocument("storage").getOrCreateDocument("documentOptimization");
            if (optThreadPool != null) {
                docOpt.setString("threadPool", optThreadPool);
            }
            if (optInitialTime != null) {
                docOpt.setString("initialTime", optInitialTime);
            }
            docOpt.setNumber("intervalInHours", optIntervalInHours);
            docOpt.setNumber("childCountTarget", optTarget.intValue());
            if (optTolerance != null) {
                docOpt.setNumber("childCountTolerance", optTolerance.intValue());
            }
        }
        if (!StringUtil.isBlank((String)clusterName)) {
            String clusterConfig = this.attribute(context, model, (AttributeDefinition)ModelAttributes.CLUSTER_CONFIG, null);
            this.parseClustering(clusterName, clusterConfig, configDoc);
            String clusterStackName = this.attribute(context, model, (AttributeDefinition)ModelAttributes.CLUSTER_STACK, null);
            if (!StringUtil.isBlank((String)clusterStackName)) {
                repositoryServiceBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"jgroups", "factory", clusterStackName}), ChannelFactory.class, repositoryService.getChannelFactoryInjector());
            }
        }
        repositoryServiceBuilder.addDependency(SecurityManagementService.SERVICE_NAME, ISecurityManagement.class, repositoryService.getSecurityManagementServiceInjector());
        repositoryServiceBuilder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, repositoryService.getModuleLoaderInjector());
        ReferenceFactoryService referenceFactoryService = new ReferenceFactoryService();
        ServiceName referenceFactoryServiceName = ModeShapeServiceNames.referenceFactoryServiceName(repositoryName);
        ServiceBuilder referenceBuilder = target.addService(referenceFactoryServiceName, referenceFactoryService);
        referenceBuilder.addDependency(repositoryServiceName, JcrRepository.class, referenceFactoryService.getInjector());
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binder);
        if (jndiAlias != null) {
            ContextNames.BindInfo aliasInfo = ContextNames.bindInfoFor((String)jndiAlias);
            ServiceName alias = aliasInfo.getBinderServiceName();
            binderBuilder.addAliases(new ServiceName[]{alias});
            LOG.debugv("Binding repository {0} to JNDI name {1} and {2}", (Object)repositoryName, (Object)bindInfo.getAbsoluteJndiName(), (Object)aliasInfo.getAbsoluteJndiName());
        } else {
            LOG.debugv("Binding repository {0} to JNDI name {1}", (Object)repositoryName, (Object)bindInfo.getAbsoluteJndiName());
        }
        binderBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, (Injector)binder.getManagedObjectInjector());
        binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector());
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceName dataDirServiceName = ModeShapeServiceNames.dataDirectoryServiceName(repositoryName);
        RelativePathService.addService((ServiceName)dataDirServiceName, (String)("modeshape/" + repositoryName), (String)"jboss.server.data.dir", (ServiceTarget)target);
        repositoryServiceBuilder.addDependency(dataDirServiceName, String.class, repositoryService.getDataDirectoryPathInjector());
        BinaryStorageService defaultBinaryService = BinaryStorageService.createDefault();
        ServiceName defaultBinaryStorageServiceName = ModeShapeServiceNames.binaryStorageDefaultServiceName(repositoryName);
        ServiceBuilder binaryStorageBuilder = target.addService(defaultBinaryStorageServiceName, (Service)defaultBinaryService);
        binaryStorageBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        repositoryServiceBuilder.addDependency(defaultBinaryStorageServiceName, BinaryStorage.class, repositoryService.getBinaryStorageInjector());
        MonitorService monitorService = new MonitorService();
        ServiceBuilder monitorBuilder = target.addService(ModeShapeServiceNames.monitorServiceName(repositoryName), (Service)monitorService);
        monitorBuilder.addDependency(ModeShapeServiceNames.repositoryServiceName(repositoryName), JcrRepository.class, monitorService.getJcrRepositoryInjector());
        monitorBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        repositoryServiceBuilder.install();
        referenceBuilder.install();
        binderBuilder.install();
        binaryStorageBuilder.install();
        monitorBuilder.install();
    }

    private void parseClustering(String clusterName, String clusterConfig, EditableDocument configDoc) {
        EditableDocument clustering = configDoc.getOrCreateDocument("clustering");
        clustering.setString("clusterName", clusterName);
        if (!StringUtil.isBlank((String)clusterConfig)) {
            clustering.setString("configuration", clusterConfig);
        }
    }

    private void parseTextExtraction(ModelNode model, EditableDocument configDoc) {
        if (model.hasDefined("text-extractors-thread-pool-name")) {
            EditableDocument extractors = configDoc.getOrCreateDocument("textExtraction");
            String poolName = model.get("text-extractors-thread-pool-name").asString();
            extractors.set("threadPool", (Object)poolName);
        }
        if (model.hasDefined("text-extractors-max-pool-size")) {
            EditableDocument sequencing = configDoc.getOrCreateDocument("textExtraction");
            int maxPoolSize = model.get("text-extractors-max-pool-size").asInt();
            sequencing.set("maxPoolSize", (Object)maxPoolSize);
        }
    }

    private void parseReindexing(ModelNode model, EditableDocument configDoc) {
        EditableDocument reindexing;
        if (model.hasDefined("reindexing-async")) {
            reindexing = configDoc.getOrCreateDocument("reindexing");
            boolean async = model.get("reindexing-async").asBoolean();
            reindexing.set("async", (Object)async);
        }
        if (model.hasDefined("reindexing-mode")) {
            reindexing = configDoc.getOrCreateDocument("reindexing");
            String mode = model.get("reindexing-mode").asString();
            reindexing.set("mode", (Object)mode);
        }
    }

    private void parseSequencing(ModelNode model, EditableDocument configDoc) {
        EditableDocument sequencing;
        if (model.hasDefined("sequencers-thread-pool-name")) {
            sequencing = configDoc.getOrCreateDocument("sequencing");
            String sequencingThreadPool = model.get("sequencers-thread-pool-name").asString();
            sequencing.set("threadPool", (Object)sequencingThreadPool);
        }
        if (model.hasDefined("sequencers-max-pool-size")) {
            sequencing = configDoc.getOrCreateDocument("sequencing");
            int maxPoolSize = model.get("sequencers-max-pool-size").asInt();
            sequencing.set("maxPoolSize", (Object)maxPoolSize);
        }
    }

    private void parseSecurity(OperationContext context, ModelNode model, EditableDocument configDoc) throws OperationFailedException {
        EditableDocument security = configDoc.getOrCreateDocument("security");
        EditableDocument anon = security.getOrCreateDocument("anonymous");
        String anonUsername = this.attribute(context, model, (AttributeDefinition)ModelAttributes.ANONYMOUS_USERNAME).asString();
        boolean useAnonIfFailed = this.attribute(context, model, (AttributeDefinition)ModelAttributes.USE_ANONYMOUS_IF_AUTH_FAILED).asBoolean();
        anon.set("username", (Object)anonUsername);
        anon.set("useOnFailedLogin", (Object)useAnonIfFailed);
        List modelNodes = model.hasDefined("anonymous-roles") ? model.get("anonymous-roles").asList() : ModelAttributes.ANONYMOUS_ROLES.getDefaultValue().asList();
        for (ModelNode roleNode : modelNodes) {
            EditableArray anonymousRolesArray = anon.getOrCreateArray("roles");
            String roleName = roleNode.asString();
            if (StringUtil.isBlank((String)roleName)) continue;
            anonymousRolesArray.addString(roleName);
        }
        EditableArray providers = security.getOrCreateArray("providers");
        String securityDomain = this.attribute(context, model, (AttributeDefinition)ModelAttributes.SECURITY_DOMAIN).asString();
        EditableDocument jboss = Schematic.newDocument();
        jboss.set("classname", (Object)JBossDomainAuthenticationProvider.class.getName());
        jboss.set("securityDomain", (Object)securityDomain);
        providers.add((Object)jboss);
        EditableDocument servlet = Schematic.newDocument();
        servlet.set("classname", (Object)"servlet");
        providers.add((Object)servlet);
    }

    private EditableDocument parseWorkspaces(OperationContext context, ModelNode model, EditableDocument configDoc, List<String> additionalClasspathEntries) throws OperationFailedException {
        EditableDocument initialContentDocument;
        EditableDocument workspacesDoc = configDoc.getOrCreateDocument("workspaces");
        boolean allowWorkspaceCreation = this.attribute(context, model, (AttributeDefinition)ModelAttributes.ALLOW_WORKSPACE_CREATION).asBoolean();
        String defaultWorkspaceName = this.attribute(context, model, (AttributeDefinition)ModelAttributes.DEFAULT_WORKSPACE).asString();
        workspacesDoc.set("allowCreation", (Object)allowWorkspaceCreation);
        workspacesDoc.set("default", (Object)defaultWorkspaceName);
        if (model.hasDefined("cache-size")) {
            workspacesDoc.set("cacheSize", (Object)model.get("cache-size").asInt());
        }
        if (model.hasDefined("predefined-workspace-names")) {
            for (ModelNode name : model.get("predefined-workspace-names").asList()) {
                workspacesDoc.getOrCreateArray("predefined").add((Object)name.asString());
            }
            if (model.hasDefined("workspaces-initial-content")) {
                initialContentDocument = workspacesDoc.getOrCreateDocument("initialContent");
                List workspacesInitialContent = model.get("workspaces-initial-content").asList();
                for (ModelNode initialContent : workspacesInitialContent) {
                    Property initialContentProperty = initialContent.asProperty();
                    initialContentDocument.set(initialContentProperty.getName(), (Object)initialContentProperty.getValue().asString());
                }
            }
        }
        if (model.hasDefined("default-initial-content")) {
            initialContentDocument = workspacesDoc.getOrCreateDocument("initialContent");
            initialContentDocument.set("*", (Object)model.get("default-initial-content").asString());
        }
        return workspacesDoc;
    }

    private void parseJournaling(RepositoryService repositoryService, OperationContext context, ModelNode model, EditableDocument configDoc) throws OperationFailedException {
        if (model.hasDefined("journaling")) {
            EditableDocument journaling = configDoc.getOrCreateDocument("journaling");
            if (model.hasDefined("journal-enabled")) {
                boolean enabled = this.attribute(context, model, (AttributeDefinition)ModelAttributes.JOURNAL_ENABLED).asBoolean();
                journaling.setBoolean("enabled", enabled);
            }
            if (model.hasDefined("journal-relative-to")) {
                String relativeTo = this.attribute(context, model, (AttributeDefinition)ModelAttributes.JOURNAL_RELATIVE_TO).asString();
                repositoryService.setJournalRelativeTo(relativeTo);
            }
            if (model.hasDefined("journal-path")) {
                String path = this.attribute(context, model, (AttributeDefinition)ModelAttributes.JOURNAL_PATH).asString();
                repositoryService.setJournalPath(path);
            }
            int maxDaysToKeepRecords = this.attribute(context, model, (AttributeDefinition)ModelAttributes.MAX_DAYS_TO_KEEP_RECORDS).asInt();
            journaling.setNumber("maxDaysToKeepRecords", maxDaysToKeepRecords);
            boolean asyncWrites = this.attribute(context, model, (AttributeDefinition)ModelAttributes.ASYNC_WRITES).asBoolean();
            journaling.setBoolean("asyncWritesEnabled", asyncWrites);
            String gcThreadPool = this.attribute(context, model, (AttributeDefinition)ModelAttributes.JOURNAL_GC_THREAD_POOL).asString();
            journaling.setString("threadPool", gcThreadPool);
            String gcInitialTime = this.attribute(context, model, (AttributeDefinition)ModelAttributes.JOURNAL_GC_INITIAL_TIME).asString();
            journaling.setString("initialTime", gcInitialTime);
        }
    }

    private void parseCustomNodeTypes(ModelNode model, EditableDocument configDoc, List<String> additionalClasspathEntries) {
        if (model.hasDefined("node-types")) {
            EditableArray nodeTypesArray = configDoc.getOrCreateArray("node-types");
            for (ModelNode nodeType : model.get("node-types").asList()) {
                nodeTypesArray.add((Object)nodeType.asString());
            }
        }
    }

    private void enableMonitoring(boolean enableMonitoring, EditableDocument configDoc) {
        EditableDocument monitoring = configDoc.getOrCreateDocument("monitoring");
        monitoring.set("enabled", (Object)enableMonitoring);
    }
}

