/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;

public class AddressContext {
    private final String repositoryName;
    private final PathAddress pathAddress;

    private AddressContext(ModelNode operation) {
        if (operation == null) {
            throw new IllegalArgumentException("The operation node cannot be null");
        }
        ModelNode address = operation.require("address");
        this.pathAddress = PathAddress.pathAddress((ModelNode)address);
        String repositoryName = null;
        for (PathElement element : this.pathAddress) {
            if (!element.getKey().equalsIgnoreCase("repository")) continue;
            repositoryName = element.getValue();
            break;
        }
        this.repositoryName = repositoryName;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String lastPathElementValue() {
        return this.pathAddress.getLastElement().getValue();
    }

    public static AddressContext forOperation(ModelNode operation) {
        return new AddressContext(operation);
    }
}

