/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.modeshape.jboss.subsystem.Attribute;
import org.modeshape.jboss.subsystem.ModeShapeAuthenticatorResource;
import org.modeshape.jboss.subsystem.ModeShapeBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeCassandraBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeCompositeBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeCustomBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeDatabaseBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeDbPersistenceResource;
import org.modeshape.jboss.subsystem.ModeShapeFileBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeFilePersistenceResource;
import org.modeshape.jboss.subsystem.ModeShapeIndexDefinitionResource;
import org.modeshape.jboss.subsystem.ModeShapeIndexProviderResource;
import org.modeshape.jboss.subsystem.ModeShapeMongoBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeRepositoryResource;
import org.modeshape.jboss.subsystem.ModeShapeRootResource;
import org.modeshape.jboss.subsystem.ModeShapeSequencerResource;
import org.modeshape.jboss.subsystem.ModeShapeSourceResource;
import org.modeshape.jboss.subsystem.ModeShapeSubsystemXMLWriter;
import org.modeshape.jboss.subsystem.ModeShapeTextExtractorResource;
import org.modeshape.jboss.subsystem.ModeShapeTransientBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeWebAppResource;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "modeshape";
    public static final String JBOSS_DATA_DIR_VARIABLE = "jboss.server.data.dir";
    public static final String JBOSS_CONFIG_DIR_VARIABLE = "jboss.server.config.dir";
    protected static final int MANAGEMENT_API_MAJOR_VERSION = 3;
    protected static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final String RESOURCE_NAME = ModeShapeExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"modeshape");
    static final PathElement WEBAPP_PATH = PathElement.pathElement((String)"webapp");
    static final PathElement REPOSITORY_PATH = PathElement.pathElement((String)"repository");
    static final PathElement SEQUENCER_PATH = PathElement.pathElement((String)"sequencer");
    static final PathElement INDEX_PROVIDER_PATH = PathElement.pathElement((String)"index-provider");
    static final PathElement DB_PERSISTENCE_PATH = PathElement.pathElement((String)Attribute.DB_PERSISTENCE.getLocalName());
    static final PathElement FS_PERSISTENCE_PATH = PathElement.pathElement((String)Attribute.FS_PERSISTENCE.getLocalName());
    static final PathElement INDEX_DEFINITION_PATH = PathElement.pathElement((String)"index");
    static final PathElement SOURCE_PATH = PathElement.pathElement((String)"source");
    static final PathElement TEXT_EXTRACTOR_PATH = PathElement.pathElement((String)"text-extractor");
    static final PathElement AUTHENTICATOR_PATH = PathElement.pathElement((String)"authenticator");

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, ModeShapeExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, ModelVersion.create((int)3, (int)0));
        registration.registerXMLElementWriter((XMLElementWriter)new ModeShapeSubsystemXMLWriter());
        ManagementResourceRegistration modeShapeSubsystem = registration.registerSubsystemModel((ResourceDefinition)ModeShapeRootResource.INSTANCE);
        modeShapeSubsystem.registerSubModel((ResourceDefinition)ModeShapeWebAppResource.INSTANCE);
        ManagementResourceRegistration repositorySubmodel = modeShapeSubsystem.registerSubModel((ResourceDefinition)ModeShapeRepositoryResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeDbPersistenceResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeFilePersistenceResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeSequencerResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeIndexProviderResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeIndexDefinitionResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeSourceResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeTextExtractorResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeAuthenticatorResource.INSTANCE);
        ManagementResourceRegistration binaryStorageSubmodel = repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeBinaryStorageResource.INSTANCE);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeFileBinaryStorageResource.DEFAULT);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeDatabaseBinaryStorageResource.DEFAULT);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCustomBinaryStorageResource.DEFAULT);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeTransientBinaryStorageResource.DEFAULT);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCassandraBinaryStorageResource.DEFAULT);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeMongoBinaryStorageResource.DEFAULT);
        ManagementResourceRegistration compositeStorageSubmodel = binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCompositeBinaryStorageResource.INSTANCE);
        compositeStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeFileBinaryStorageResource.NESTED);
        compositeStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeDatabaseBinaryStorageResource.NESTED);
        compositeStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCustomBinaryStorageResource.NESTED);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), reader);
        }
    }

    public static final class ModuleID {
        public static final String MAIN = "org.modeshape";
    }
}

