/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;

public class TransactionalWorkspaceCaches {
    private static final Logger LOGGER = Logger.getLogger(TransactionalWorkspaceCache.class);
    private final TransactionManager txnMgr;
    private final Map<Transaction, Map<String, TransactionalWorkspaceCache>> transactionalCachesByTransaction = new ConcurrentHashMap<Transaction, Map<String, TransactionalWorkspaceCache>>();

    public TransactionalWorkspaceCaches(Transactions transactions) {
        CheckArg.isNotNull((Object)transactions, (String)"transactions");
        this.txnMgr = transactions.getTransactionManager();
    }

    protected WorkspaceCache getTransactionalCache(WorkspaceCache globalWorkspaceCache) throws Exception {
        Transaction txn = this.txnMgr.getTransaction();
        if (txn == null || txn.getStatus() != 0) {
            return globalWorkspaceCache;
        }
        String workspaceName = globalWorkspaceCache.getWorkspaceName();
        return this.transactionalCachesByTransaction.computeIfAbsent(txn, this::newCacheMapForTransaction).computeIfAbsent(workspaceName, wsName -> new TransactionalWorkspaceCache(globalWorkspaceCache, this, txn));
    }

    private Map<String, TransactionalWorkspaceCache> newCacheMapForTransaction(final Transaction txn) {
        try {
            txn.registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    Map cachesByWsName = (Map)TransactionalWorkspaceCaches.this.transactionalCachesByTransaction.remove(txn);
                    cachesByWsName.clear();
                }
            });
        }
        catch (RollbackException | SystemException e) {
            throw new RuntimeException(e);
        }
        return new ConcurrentHashMap<String, TransactionalWorkspaceCache>();
    }

    public synchronized void rollbackActiveTransactionsForWorkspace(String workspaceName) {
        ArrayList toRemove = new ArrayList();
        this.transactionalCachesByTransaction.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(workspaceName)).forEach(entry -> {
            Transaction tx = (Transaction)entry.getKey();
            toRemove.add(tx);
            try {
                tx.rollback();
            }
            catch (SystemException e) {
                LOGGER.error((Throwable)e, (I18nResource)JcrI18n.errorWhileRollingBackActiveTransactionUsingWorkspaceThatIsBeingDeleted, new Object[]{workspaceName, e.getMessage()});
            }
        });
        this.transactionalCachesByTransaction.keySet().removeAll(toRemove);
    }

    protected void clearAllCachesForTransaction(Transaction txn) {
        this.transactionalCachesByTransaction.getOrDefault(txn, Collections.emptyMap()).forEach((wsName, txWsCache) -> txWsCache.internalClear());
    }

    protected void dispatchChangesForTransaction(Transaction txn, ChangeSet changes) {
        this.transactionalCachesByTransaction.getOrDefault(txn, Collections.emptyMap()).forEach((wsName, txWsCache) -> txWsCache.internalChangedWithinTransaction(changes));
    }
}

