/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.odf.NSNormalizerContentHandler;
import org.apache.tika.sax.ElementMappingContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class OpenDocumentContentParser
extends AbstractParser {
    public static final String TEXT_NS = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    public static final String TABLE_NS = "urn:oasis:names:tc:opendocument:xmlns:table:1.0";
    public static final String STYLE_NS = "urn:oasis:names:tc:opendocument:xmlns:style:1.0";
    public static final String FORMATTING_OBJECTS_NS = "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0";
    public static final String OFFICE_NS = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
    public static final String SVG_NS = "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0";
    public static final String PRESENTATION_NS = "urn:oasis:names:tc:opendocument:xmlns:presentation:1.0";
    public static final String DRAW_NS = "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0";
    public static final String XLINK_NS = "http://www.w3.org/1999/xlink";
    protected static final char[] TAB = new char[]{'\t'};
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private static final HashMap<QName, ElementMappingContentHandler.TargetElement> MAPPINGS = new HashMap();

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return Collections.emptySet();
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        this.parseInternal(stream, (ContentHandler)new XHTMLContentHandler(handler, metadata), metadata, context);
    }

    void parseInternal(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        OpenDocumentElementMappingContentHandler dh = new OpenDocumentElementMappingContentHandler(handler, MAPPINGS);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (SAXNotRecognizedException e) {
                // empty catch block
            }
            SAXParser parser = factory.newSAXParser();
            parser.parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler((ContentHandler)((Object)new NSNormalizerContentHandler((ContentHandler)((Object)dh)))));
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("XML parser configuration error", (Throwable)e);
        }
    }

    static {
        MAPPINGS.put(new QName(TEXT_NS, "p"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "p"));
        MAPPINGS.put(new QName(TEXT_NS, "line-break"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "br"));
        MAPPINGS.put(new QName(TEXT_NS, "list-item"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "li"));
        MAPPINGS.put(new QName(TEXT_NS, "note"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(OFFICE_NS, "annotation"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(PRESENTATION_NS, "notes"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(DRAW_NS, "object"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "object"));
        MAPPINGS.put(new QName(DRAW_NS, "text-box"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "div"));
        MAPPINGS.put(new QName(SVG_NS, "title"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "span"));
        MAPPINGS.put(new QName(SVG_NS, "desc"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "span"));
        MAPPINGS.put(new QName(TEXT_NS, "span"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "span"));
        HashMap<QName, QName> aAttsMapping = new HashMap<QName, QName>();
        aAttsMapping.put(new QName(XLINK_NS, "href"), new QName("href"));
        aAttsMapping.put(new QName(XLINK_NS, "title"), new QName("title"));
        MAPPINGS.put(new QName(TEXT_NS, "a"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "a", aAttsMapping));
        MAPPINGS.put(new QName(TABLE_NS, "table"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "table"));
        MAPPINGS.put(new QName(TABLE_NS, "table-row"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "tr"));
        HashMap<QName, QName> tableCellAttsMapping = new HashMap<QName, QName>();
        tableCellAttsMapping.put(new QName(TABLE_NS, "number-columns-spanned"), new QName("colspan"));
        tableCellAttsMapping.put(new QName(TABLE_NS, "number-rows-spanned"), new QName("rowspan"));
        tableCellAttsMapping.put(new QName(TABLE_NS, "number-columns-repeated"), new QName("colspan"));
        MAPPINGS.put(new QName(TABLE_NS, "table-cell"), new ElementMappingContentHandler.TargetElement("http://www.w3.org/1999/xhtml", "td", tableCellAttsMapping));
    }

    private static final class OpenDocumentElementMappingContentHandler
    extends ElementMappingContentHandler {
        private final ContentHandler handler;
        private final BitSet textNodeStack = new BitSet();
        private int nodeDepth = 0;
        private int completelyFiltered = 0;
        private Stack<String> headingStack = new Stack();
        private Map<String, TextStyle> textStyleMap = new HashMap<String, TextStyle>();
        private Map<String, ListStyle> listStyleMap = new HashMap<String, ListStyle>();
        private TextStyle textStyle;
        private TextStyle lastTextStyle;
        private Stack<ListStyle> listStyleStack = new Stack();
        private ListStyle listStyle;

        private OpenDocumentElementMappingContentHandler(ContentHandler handler, Map<QName, ElementMappingContentHandler.TargetElement> mappings) {
            super(handler, mappings);
            this.handler = handler;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.completelyFiltered == 0 && this.nodeDepth > 0 && this.textNodeStack.get(this.nodeDepth - 1)) {
                this.lazyEndSpan();
                super.characters(ch, start, length);
            }
        }

        private boolean needsCompleteFiltering(String namespaceURI, String localName) {
            if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI)) {
                return localName.endsWith("-template") || localName.endsWith("-style");
            }
            return OpenDocumentContentParser.TABLE_NS.equals(namespaceURI) && "covered-table-cell".equals(localName);
        }

        private String getXHTMLHeaderTagName(Attributes atts) {
            String depthStr = atts.getValue(OpenDocumentContentParser.TEXT_NS, "outline-level");
            if (depthStr == null) {
                return "h1";
            }
            int depth = Integer.parseInt(depthStr);
            if (depth >= 6) {
                return "h6";
            }
            if (depth <= 1) {
                return "h1";
            }
            return "h" + depth;
        }

        private boolean isTextNode(String namespaceURI, String localName) {
            if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && !localName.equals("page-number") && !localName.equals("page-count")) {
                return true;
            }
            if (OpenDocumentContentParser.SVG_NS.equals(namespaceURI)) {
                return "title".equals(localName) || "desc".equals(localName);
            }
            return false;
        }

        private void startList(String name) throws SAXException {
            String elementName = "ul";
            if (name != null) {
                ListStyle style = this.listStyleMap.get(name);
                elementName = style != null ? style.getTag() : "ul";
                this.listStyleStack.push(style);
            }
            this.handler.startElement("http://www.w3.org/1999/xhtml", elementName, elementName, EMPTY_ATTRIBUTES);
        }

        private void endList() throws SAXException {
            String elementName = "ul";
            if (!this.listStyleStack.isEmpty()) {
                ListStyle style = this.listStyleStack.pop();
                elementName = style != null ? style.getTag() : "ul";
            }
            this.handler.endElement("http://www.w3.org/1999/xhtml", elementName, elementName);
        }

        private void startSpan(String name) throws SAXException {
            if (name == null) {
                return;
            }
            TextStyle style = this.textStyleMap.get(name);
            if (style == null) {
                return;
            }
            if (!style.underlined && this.lastTextStyle != null && this.lastTextStyle.underlined) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "u", "u");
            }
            if (!style.italic && this.lastTextStyle != null && this.lastTextStyle.italic) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "i", "i");
            }
            if (!style.bold && this.lastTextStyle != null && this.lastTextStyle.bold) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "b", "b");
            }
            if (style.bold && (this.lastTextStyle == null || !this.lastTextStyle.bold)) {
                this.handler.startElement("http://www.w3.org/1999/xhtml", "b", "b", EMPTY_ATTRIBUTES);
            }
            if (style.italic && (this.lastTextStyle == null || !this.lastTextStyle.italic)) {
                this.handler.startElement("http://www.w3.org/1999/xhtml", "i", "i", EMPTY_ATTRIBUTES);
            }
            if (style.underlined && (this.lastTextStyle == null || !this.lastTextStyle.underlined)) {
                this.handler.startElement("http://www.w3.org/1999/xhtml", "u", "u", EMPTY_ATTRIBUTES);
            }
            this.textStyle = style;
            this.lastTextStyle = null;
        }

        private void endSpan() throws SAXException {
            this.lastTextStyle = this.textStyle;
            this.textStyle = null;
        }

        private void lazyEndSpan() throws SAXException {
            if (this.lastTextStyle == null) {
                return;
            }
            if (this.lastTextStyle.underlined) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "u", "u");
            }
            if (this.lastTextStyle.italic) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "i", "i");
            }
            if (this.lastTextStyle.bold) {
                this.handler.endElement("http://www.w3.org/1999/xhtml", "b", "b");
            }
            this.lastTextStyle = null;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            assert (this.nodeDepth >= 0);
            if (OpenDocumentContentParser.STYLE_NS.equals(namespaceURI) && "style".equals(localName)) {
                String family = attrs.getValue(OpenDocumentContentParser.STYLE_NS, "family");
                if ("text".equals(family)) {
                    this.textStyle = new TextStyle();
                    String name = attrs.getValue(OpenDocumentContentParser.STYLE_NS, "name");
                    this.textStyleMap.put(name, this.textStyle);
                }
            } else if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && "list-style".equals(localName)) {
                this.listStyle = new ListStyle();
                String name = attrs.getValue(OpenDocumentContentParser.STYLE_NS, "name");
                this.listStyleMap.put(name, this.listStyle);
            } else if (this.textStyle != null && OpenDocumentContentParser.STYLE_NS.equals(namespaceURI) && "text-properties".equals(localName)) {
                String underlineStyle;
                String fontWeight;
                String fontStyle = attrs.getValue(OpenDocumentContentParser.FORMATTING_OBJECTS_NS, "font-style");
                if ("italic".equals(fontStyle) || "oblique".equals(fontStyle)) {
                    this.textStyle.italic = true;
                }
                if ("bold".equals(fontWeight = attrs.getValue(OpenDocumentContentParser.FORMATTING_OBJECTS_NS, "font-weight")) || "bolder".equals(fontWeight) || fontWeight != null && Character.isDigit(fontWeight.charAt(0)) && Integer.valueOf(fontWeight) > 500) {
                    this.textStyle.bold = true;
                }
                if ((underlineStyle = attrs.getValue(OpenDocumentContentParser.STYLE_NS, "text-underline-style")) != null) {
                    this.textStyle.underlined = true;
                }
            } else if (this.listStyle != null && OpenDocumentContentParser.TEXT_NS.equals(namespaceURI)) {
                if ("list-level-style-bullet".equals(localName)) {
                    this.listStyle.ordered = false;
                } else if ("list-level-style-number".equals(localName)) {
                    this.listStyle.ordered = true;
                }
            }
            this.textNodeStack.set(this.nodeDepth++, this.isTextNode(namespaceURI, localName));
            assert (this.completelyFiltered >= 0);
            if (this.needsCompleteFiltering(namespaceURI, localName)) {
                ++this.completelyFiltered;
            }
            if (this.completelyFiltered == 0) {
                if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && "h".equals(localName)) {
                    String el = this.headingStack.push(this.getXHTMLHeaderTagName(attrs));
                    this.handler.startElement("http://www.w3.org/1999/xhtml", el, el, EMPTY_ATTRIBUTES);
                } else if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && "list".equals(localName)) {
                    this.startList(attrs.getValue(OpenDocumentContentParser.TEXT_NS, "style-name"));
                } else if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && "span".equals(localName)) {
                    this.startSpan(attrs.getValue(OpenDocumentContentParser.TEXT_NS, "style-name"));
                } else {
                    super.startElement(namespaceURI, localName, qName, attrs);
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (OpenDocumentContentParser.STYLE_NS.equals(namespaceURI) && "style".equals(localName)) {
                this.textStyle = null;
            } else if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && "list-style".equals(localName)) {
                this.listStyle = null;
            }
            if (this.completelyFiltered == 0) {
                if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && "h".equals(localName)) {
                    String el = this.headingStack.pop();
                    this.handler.endElement("http://www.w3.org/1999/xhtml", el, el);
                } else if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && "list".equals(localName)) {
                    this.endList();
                } else if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && "span".equals(localName)) {
                    this.endSpan();
                } else {
                    if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && "p".equals(localName)) {
                        this.lazyEndSpan();
                    }
                    super.endElement(namespaceURI, localName, qName);
                }
                if (OpenDocumentContentParser.TEXT_NS.equals(namespaceURI) && ("tab-stop".equals(localName) || "tab".equals(localName))) {
                    this.characters(TAB, 0, TAB.length);
                }
            }
            if (this.needsCompleteFiltering(namespaceURI, localName)) {
                --this.completelyFiltered;
            }
            assert (this.completelyFiltered >= 0);
            --this.nodeDepth;
            assert (this.nodeDepth >= 0);
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void endPrefixMapping(String prefix) {
        }
    }

    private static class ListStyle
    implements Style {
        public boolean ordered;

        private ListStyle() {
        }

        public String getTag() {
            return this.ordered ? "ol" : "ul";
        }
    }

    private static class TextStyle
    implements Style {
        public boolean italic;
        public boolean bold;
        public boolean underlined;

        private TextStyle() {
        }
    }

    private static interface Style {
    }
}

