/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.optimize;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.model.AllNodes;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.EquiJoinCondition;
import org.modeshape.jcr.query.model.JoinCondition;
import org.modeshape.jcr.query.model.SameNodeJoinCondition;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.optimize.PushProjects;
import org.modeshape.jcr.query.optimize.PushSelectCriteria;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.query.plan.PlanUtil;
import org.modeshape.jcr.query.validate.Schemata;

@Immutable
public class RewriteIdentityJoins
implements OptimizerRule {
    public static final RewriteIdentityJoins INSTANCE = new RewriteIdentityJoins();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        if (!context.getHints().hasJoin) {
            return plan;
        }
        HashMap<SelectorName, SelectorName> rewrittenSelectors = null;
        int rewrittenJoins = 0;
        int numJoins = 0;
        for (PlanNode joinNode : plan.findAllAtOrBelow(PlanNode.Type.JOIN)) {
            SameNodeJoinCondition sameNodeCondition;
            ++numJoins;
            JoinCondition condition = joinNode.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
            if (condition instanceof EquiJoinCondition) {
                PlanNode leftNode = joinNode.getFirstChild().findAtOrBelow(PlanNode.Type.SOURCE);
                PlanNode rightNode = joinNode.getLastChild().findAtOrBelow(PlanNode.Type.SOURCE);
                assert (leftNode != null);
                assert (rightNode != null);
                EquiJoinCondition equiJoin = (EquiJoinCondition)condition;
                Schemata schemata = context.getSchemata();
                assert (schemata != null);
                SelectorName leftTableName = leftNode.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class);
                SelectorName rightTableName = rightNode.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class);
                assert (leftTableName != null);
                assert (rightTableName != null);
                if (!leftTableName.equals(rightTableName)) continue;
                Schemata.Table table = schemata.getTable(leftTableName);
                if (table == null) {
                    context.getProblems().addError(GraphI18n.tableDoesNotExist, new Object[]{leftTableName});
                    continue;
                }
                String leftColumnName = equiJoin.getProperty1Name();
                String rightColumnName = equiJoin.getProperty2Name();
                Schemata.Column leftColumn = table.getColumn(leftColumnName);
                Schemata.Column rightColumn = table.getColumn(rightColumnName);
                if (leftColumn == null || rightColumn == null || !table.hasKey(leftColumn) || rightColumn != leftColumn && !table.hasKey(rightColumn)) continue;
                if (rewrittenSelectors == null) {
                    rewrittenSelectors = new HashMap();
                }
                this.rewriteJoinNode(context, joinNode, rewrittenSelectors);
                ++rewrittenJoins;
                continue;
            }
            if (!(condition instanceof SameNodeJoinCondition) || (sameNodeCondition = (SameNodeJoinCondition)condition).getSelector2Path() != null) continue;
            if (rewrittenSelectors == null) {
                rewrittenSelectors = new HashMap<SelectorName, SelectorName>();
            }
            this.rewriteJoinNode(context, joinNode, rewrittenSelectors);
            ++rewrittenJoins;
        }
        if (rewrittenSelectors != null && !rewrittenSelectors.isEmpty()) {
            ruleStack.addFirst(this);
            if (!(ruleStack.peek() instanceof PushSelectCriteria)) {
                ruleStack.addFirst(PushProjects.INSTANCE);
                if (context.getHints().hasCriteria) {
                    ruleStack.addFirst(PushSelectCriteria.INSTANCE);
                }
            }
            rewrittenSelectors.remove(AllNodes.ALL_NODES_NAME);
            PlanUtil.replaceReferencesToRemovedSource(context, plan, (Map<SelectorName, SelectorName>)rewrittenSelectors);
            assert (rewrittenJoins > 0);
            if (rewrittenJoins == numJoins) {
                assert (plan.findAllAtOrBelow(PlanNode.Type.JOIN).isEmpty());
                context.getHints().hasJoin = false;
            }
        }
        return plan;
    }

    protected void rewriteJoinNode(QueryContext context, PlanNode joinNode, Map<SelectorName, SelectorName> rewrittenSelectors) {
        PlanNode topRightSelect;
        PlanNode rightChild = joinNode.getLastChild();
        rightChild.removeFromParent();
        PlanNode rightSource = rightChild.findAtOrBelow(PlanNode.Type.SOURCE);
        PlanNode leftChild = joinNode.getFirstChild();
        joinNode.extractFromParent();
        PlanNode leftSource = leftChild.findAtOrBelow(PlanNode.Type.SOURCE);
        PlanNode rightProject = rightChild.findAtOrBelow(PlanNode.Type.PROJECT);
        if (rightProject != null) {
            PlanNode leftProject = leftChild.findAtOrBelow(PlanNode.Type.PROJECT);
            if (leftProject != null) {
                List<Column> leftColumns = leftProject.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
                for (Column rightColumn : rightProject.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class)) {
                    Iterator<SelectorName> iterator = leftProject.getSelectors().iterator();
                    if (iterator.hasNext()) {
                        SelectorName leftSelector = iterator.next();
                        rightColumn = rightColumn.with(leftSelector);
                    }
                    if (leftColumns.contains(rightColumn)) continue;
                    leftColumns.add(rightColumn);
                }
            } else {
                leftProject = new PlanNode(PlanNode.Type.PROJECT);
                leftProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, rightProject.getProperty(PlanNode.Property.PROJECT_COLUMNS));
                leftChild.getFirstChild().insertAsParent(leftProject);
            }
        }
        SelectorName rightTableName = rightSource.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class);
        SelectorName rightTableAlias = rightSource.getProperty(PlanNode.Property.SOURCE_ALIAS, SelectorName.class);
        SelectorName leftTableAlias = leftSource.getProperty(PlanNode.Property.SOURCE_ALIAS, SelectorName.class);
        if (leftTableAlias != null) {
            if (rightTableName != null) {
                rewrittenSelectors.put(rightTableName, leftTableAlias);
            }
            if (rightTableAlias != null) {
                rewrittenSelectors.put(rightTableAlias, leftTableAlias);
            }
        } else {
            SelectorName leftTableName = leftSource.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class);
            assert (leftTableName != null);
            if (rightTableName != null) {
                rewrittenSelectors.put(rightTableName, leftTableName);
            }
            if (rightTableAlias != null) {
                rewrittenSelectors.put(rightTableAlias, leftTableName);
            }
        }
        if ((topRightSelect = rightChild.findAtOrBelow(PlanNode.Type.SELECT)) != null) {
            PlanNode bottomRightSelect = topRightSelect;
            this.replaceInSelectNodeReferencesToRemovedSource(context, topRightSelect, rewrittenSelectors);
            while (!bottomRightSelect.getFirstChild().isNot(PlanNode.Type.SELECT)) {
                bottomRightSelect = bottomRightSelect.getFirstChild();
                this.replaceInSelectNodeReferencesToRemovedSource(context, bottomRightSelect, rewrittenSelectors);
            }
            topRightSelect.setParent(null);
            bottomRightSelect.removeAllChildren();
            leftSource.getParent().addLastChild(topRightSelect);
            leftSource.setParent(bottomRightSelect);
        }
        PlanUtil.removeDuplicateSelectNodesUnderEachAccessNode(context, leftChild);
    }

    private void replaceInSelectNodeReferencesToRemovedSource(QueryContext context, PlanNode selectNode, Map<SelectorName, SelectorName> rewrittenSelectors) {
        Constraint newConstraint;
        Constraint constraint = selectNode.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
        if (constraint != (newConstraint = PlanUtil.replaceReferencesToRemovedSource(context, constraint, rewrittenSelectors))) {
            selectNode.setProperty(PlanNode.Property.SELECT_CRITERIA, newConstraint);
        }
        for (SelectorName selectorName : selectNode.getSelectors()) {
            SelectorName replacement = rewrittenSelectors.get(selectorName);
            if (replacement == null) continue;
            selectNode.replaceSelector(selectorName, replacement);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

