/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jboss.security.JBossDomainAuthenticationProvider;
import org.modeshape.jcr.ConfigurationException;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.document.Changes;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableArray;
import org.modeshape.schematic.document.EditableDocument;
import org.modeshape.schematic.document.Editor;

public class AuthenticatorService
implements Service<JcrRepository> {
    private final InjectedValue<ModeShapeEngine> engineInjector = new InjectedValue();
    private final InjectedValue<JcrRepository> jcrRepositoryInjector = new InjectedValue();
    private final Properties authenticatorProperties;
    private final String repositoryName;

    public AuthenticatorService(String repositoryName, Properties extractorProperties) {
        this.repositoryName = repositoryName;
        this.authenticatorProperties = extractorProperties;
    }

    public JcrRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return (JcrRepository)this.jcrRepositoryInjector.getValue();
    }

    private ModeShapeEngine getModeShapeEngine() {
        return (ModeShapeEngine)this.engineInjector.getValue();
    }

    public void start(StartContext arg0) throws StartException {
        ModeShapeEngine engine = this.getModeShapeEngine();
        JcrRepository repository = null;
        try {
            repository = engine.getRepository(this.repositoryName);
        }
        catch (NoSuchRepositoryException e) {
            throw new StartException((Throwable)e);
        }
        RepositoryConfiguration repositoryConfig = repository.getConfiguration();
        Editor configEditor = repositoryConfig.edit();
        EditableDocument security = configEditor.getOrCreateDocument("security");
        EditableArray providers = security.getOrCreateArray("providers");
        EditableDocument provider = Schematic.newDocument();
        String providerName = this.authenticatorProperties.getProperty("name");
        provider.set("name", (Object)providerName);
        for (Object key : this.authenticatorProperties.keySet()) {
            String keyStr = (String)key;
            if ("name".equals(keyStr)) continue;
            Object value = this.authenticatorProperties.get(keyStr);
            if (value instanceof List) {
                for (Object val : (List)value) {
                    provider.getOrCreateArray(keyStr).addValue(val);
                }
                continue;
            }
            provider.set(keyStr, value);
        }
        int providerPosition = 0;
        for (int i = 0; i < providers.size(); ++i) {
            boolean isBuiltinProvider;
            providerPosition = i;
            Document document = (Document)providers.get(i);
            String className = document.getString("classname");
            boolean bl = isBuiltinProvider = !StringUtil.isBlank((String)className) && (className.equalsIgnoreCase(JBossDomainAuthenticationProvider.class.getName()) || className.equalsIgnoreCase("servlet"));
            if (isBuiltinProvider) break;
        }
        providers.add(providerPosition, (Object)provider);
        Changes changes = configEditor.getChanges();
        Problems validationResults = repositoryConfig.validate(changes);
        if (validationResults.hasErrors()) {
            String msg = JcrI18n.errorsInRepositoryConfiguration.text(new Object[]{this.repositoryName, validationResults.errorCount(), validationResults.toString()});
            throw new StartException(msg);
        }
        try {
            engine.update(this.repositoryName, changes);
        }
        catch (RepositoryException | ConfigurationException e) {
            throw new StartException(e);
        }
    }

    public void stop(StopContext arg0) {
    }

    public InjectedValue<ModeShapeEngine> getModeShapeEngineInjector() {
        return this.engineInjector;
    }

    public InjectedValue<JcrRepository> getJcrRepositoryInjector() {
        return this.jcrRepositoryInjector;
    }
}

