/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AbstractAddBinaryStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.schematic.document.EditableDocument;

public class AddS3BinaryStorage
extends AbstractAddBinaryStorage {
    public static final AddS3BinaryStorage INSTANCE = new AddS3BinaryStorage();

    private AddS3BinaryStorage() {
    }

    @Override
    protected void writeBinaryStorageConfiguration(String repositoryName, OperationContext context, ModelNode model, EditableDocument binaries) throws OperationFailedException {
        binaries.set("type", (Object)"s3");
        String username = ModelAttributes.S3_USERNAME.resolveModelAttribute(context, model).asString();
        binaries.setString("username", username);
        String password = ModelAttributes.S3_PASSWORD.resolveModelAttribute(context, model).asString();
        binaries.setString("password", password);
        String bucketName = ModelAttributes.S3_BUCKET_NAME.resolveModelAttribute(context, model).asString();
        binaries.setString("bucketName", bucketName);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddS3BinaryStorage.populate(operation, model, ModelAttributes.S3_BINARY_STORAGE_ATTRIBUTES);
    }
}

