/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.bkd.PointReader;

final class OfflinePointReader
implements PointReader {
    long countLeft;
    final IndexInput in;
    private final byte[] packedValue;
    private long ord;
    private int docID;
    private boolean checked;

    OfflinePointReader(Directory tempDir, String tempFileName, int packedBytesLength, long start, long length) throws IOException {
        int bytesPerDoc = packedBytesLength + 4 + 8;
        if ((start + length) * (long)bytesPerDoc + (long)CodecUtil.footerLength() > tempDir.fileLength(tempFileName)) {
            throw new IllegalArgumentException("requested slice is beyond the length of this file: start=" + start + " length=" + length + " bytesPerDoc=" + bytesPerDoc + " fileLength=" + tempDir.fileLength(tempFileName) + " tempFileName=" + tempFileName);
        }
        this.in = start == 0L && length * (long)bytesPerDoc == tempDir.fileLength(tempFileName) - (long)CodecUtil.footerLength() ? tempDir.openChecksumInput(tempFileName, IOContext.READONCE) : tempDir.openInput(tempFileName, IOContext.READONCE);
        long seekFP = start * (long)bytesPerDoc;
        this.in.seek(seekFP);
        this.countLeft = length;
        this.packedValue = new byte[packedBytesLength];
    }

    @Override
    public boolean next() throws IOException {
        if (this.countLeft >= 0L) {
            if (this.countLeft == 0L) {
                return false;
            }
            --this.countLeft;
        }
        try {
            this.in.readBytes(this.packedValue, 0, this.packedValue.length);
        }
        catch (EOFException eofe) {
            assert (this.countLeft == -1L);
            return false;
        }
        this.docID = this.in.readInt();
        this.ord = this.in.readLong();
        return true;
    }

    @Override
    public byte[] packedValue() {
        return this.packedValue;
    }

    @Override
    public long ord() {
        return this.ord;
    }

    @Override
    public int docID() {
        return this.docID;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.countLeft == 0L && this.in instanceof ChecksumIndexInput && !this.checked) {
                this.checked = true;
                CodecUtil.checkFooter((ChecksumIndexInput)this.in);
            }
        }
        finally {
            this.in.close();
        }
    }
}

