/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.relational;

import java.util.Arrays;
import java.util.List;
import org.modeshape.schematic.document.Document;

public final class RelationalDbConfig {
    public static final String ALIAS1 = "db";
    public static final String ALIAS2 = "database";
    public static List<String> ALIASES = Arrays.asList("db", "database");
    public static final String DROP_ON_EXIT = "dropOnExit";
    public static final String CREATE_ON_START = "createOnStart";
    public static final String TABLE_NAME = "tableName";
    public static final String FETCH_SIZE = "fetchSize";
    public static final String COMPRESS = "compress";
    public static final String CONNECTION_URL = "connectionUrl";
    public static final String DRIVER = "driver";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String DATASOURCE_JNDI_NAME = "dataSourceJndiName";
    public static final String POOL_SIZE = "poolSize";
    protected static final String DEFAULT_CONNECTION_URL = "jdbc:h2:mem:modeshape;DB_CLOSE_DELAY=0;MVCC=TRUE";
    protected static final String DEFAULT_DRIVER = "org.h2.Driver";
    protected static final String DEFAULT_USERNAME = "sa";
    protected static final String DEFAULT_PASSWORD = "";
    protected static final String DEFAULT_TABLE_NAME = "MODESHAPE_REPOSITORY";
    protected static final int DEFAULT_FETCH_SIZE = 1000;
    protected static final int DEFAULT_POOL_SIZE = 50;
    private final boolean createOnStart;
    private final boolean dropOnExit;
    private final String tableName;
    private final int fetchSize;
    private final boolean compress;
    private final String connectionUrl;
    private final String driver;
    private final String username;
    private final String password;
    private final String datasourceJNDIName;
    private final int poolSize;

    protected RelationalDbConfig(Document document) {
        this.connectionUrl = document.getString(CONNECTION_URL, DEFAULT_CONNECTION_URL);
        this.driver = document.getString(DRIVER, DEFAULT_DRIVER);
        this.username = document.getString(USERNAME, DEFAULT_USERNAME);
        this.password = document.getString(PASSWORD, DEFAULT_PASSWORD);
        this.datasourceJNDIName = document.getString(DATASOURCE_JNDI_NAME, null);
        this.createOnStart = this.propertyAsBoolean(document, CREATE_ON_START, true);
        this.dropOnExit = this.propertyAsBoolean(document, DROP_ON_EXIT, false);
        this.tableName = document.getString(TABLE_NAME, DEFAULT_TABLE_NAME);
        this.fetchSize = this.propertyAsInt(document, FETCH_SIZE, 1000);
        this.compress = this.propertyAsBoolean(document, COMPRESS, false);
        this.poolSize = this.propertyAsInt(document, POOL_SIZE, 50);
    }

    protected String connectionUrl() {
        return this.connectionUrl;
    }

    protected String driver() {
        return this.driver;
    }

    protected String password() {
        return this.password;
    }

    protected String username() {
        return this.username;
    }

    protected String datasourceJNDIName() {
        return this.datasourceJNDIName;
    }

    protected boolean createOnStart() {
        return this.createOnStart;
    }

    protected boolean dropOnExit() {
        return this.dropOnExit;
    }

    protected String tableName() {
        return this.tableName;
    }

    protected int fetchSize() {
        return this.fetchSize;
    }

    protected boolean compress() {
        return this.compress;
    }

    protected int poolSize() {
        return this.poolSize;
    }

    private int propertyAsInt(Document document, String propertyName, int defaultValue) {
        Object value = document.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    private boolean propertyAsBoolean(Document document, String propertyName, boolean defaultValue) {
        Object value = document.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    public String toString() {
        return "RelationalDbConfig[createOnStart=" + this.createOnStart + ", dropOnExit=" + this.dropOnExit + ", tableName='" + this.tableName + '\'' + ", fetchSize=" + this.fetchSize + ", compress=" + this.compress + ", connectionUrl='" + this.connectionUrl + '\'' + ", driver='" + this.driver + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", datasourceJNDIName='" + this.datasourceJNDIName + '\'' + ']';
    }
}

