/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;

@Immutable
public abstract class ConstantScoreWeightQuery
extends Query {
    private final String field;

    protected ConstantScoreWeightQuery(String field) {
        CheckArg.isNotNull((Object)field, (String)"field");
        this.field = field;
    }

    protected String field() {
        return this.field;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Set<String> fieldSet = Collections.singleton(this.field);
        return new RandomAccessWeight(this){

            protected Bits getMatchingDocs(LeafReaderContext context) throws IOException {
                LeafReader leafReader = context.reader();
                Bits liveDocs = leafReader.getLiveDocs();
                int docsCount = liveDocs != null ? liveDocs.length() : leafReader.numDocs();
                FixedBitSet result = new FixedBitSet(leafReader.maxDoc());
                for (int i = 0; i < docsCount; ++i) {
                    Document document;
                    IndexableField[] fields;
                    if (liveDocs != null && !liveDocs.get(i) || (fields = (document = leafReader.document(i, fieldSet)).getFields(ConstantScoreWeightQuery.this.field)).length == 0 || !ConstantScoreWeightQuery.this.areValid(fields)) continue;
                    result.set(i);
                }
                return result.cardinality() > 0 ? result : null;
            }
        };
    }

    protected abstract boolean areValid(IndexableField ... var1);
}

