/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.jcr.RepositoryException;
import javax.transaction.SystemException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.jcr.BackupDocumentReader;
import org.modeshape.jcr.BackupDocumentWriter;
import org.modeshape.jcr.BackupObserver;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrProblems;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.api.BackupOptions;
import org.modeshape.jcr.api.Problems;
import org.modeshape.jcr.api.RestoreOptions;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.document.LocalDocumentStore;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.SchematicEntry;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableArray;
import org.modeshape.schematic.document.EditableDocument;
import org.modeshape.schematic.document.Json;

public class BackupService {
    protected static final Logger LOGGER = Logger.getLogger(BackupService.class);
    protected static final String CHANGED_AREA_DIR_NAME = "changes";
    protected static final String BINARY_AREA_DIR_NAME = "binaries";
    protected static final String DOCUMENTS_FILENAME_PREFIX = "documents";
    protected static final String SUMMARY_FILE_NAME = "summary_of_changes.json";
    protected static final String BINARY_EXTENSION = ".bin";
    protected static final int NUM_CHARS_IN_FILENAME_SUFFIX = 6;
    private final JcrRepository.RunningState runningState;
    private final LocalDocumentStore documentStore;
    private final BinaryStore binaryStore;
    private final RepositoryCache repositoryCache;

    protected BackupService(JcrRepository.RunningState runningState) {
        this.runningState = runningState;
        this.documentStore = this.runningState.documentStore().localStore();
        this.binaryStore = this.runningState.binaryStore();
        this.repositoryCache = this.runningState.repositoryCache();
    }

    protected void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problems backupRepository(File backupDirectory, BackupOptions options) throws RepositoryException {
        JcrProblems jcrProblems;
        BackupActivity backupActivity = this.createBackupActivity(backupDirectory, options);
        if (this.runningState.suspendExistingUserTransaction()) {
            LOGGER.debug("Suspended existing active user transaction before the backup operation starts", new Object[0]);
        }
        try {
            jcrProblems = new JcrProblems(backupActivity.execute());
        }
        catch (Throwable throwable) {
            try {
                this.runningState.resumeExistingUserTransaction();
                throw throwable;
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }
        this.runningState.resumeExistingUserTransaction();
        return jcrProblems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problems restoreRepository(JcrRepository repository, File backupDirectory, RestoreOptions options) throws RepositoryException {
        JcrProblems problems;
        String backupLocString;
        block8: {
            backupLocString = backupDirectory.getAbsolutePath();
            LOGGER.debug("Beginning restore of '{0}' repository from {1} with options {2}", new Object[]{repository.getName(), backupLocString, options});
            repository.prepareToRestore();
            RestoreActivity restoreActivity = this.createRestoreActivity(backupDirectory, options);
            problems = null;
            try {
                if (this.runningState.suspendExistingUserTransaction()) {
                    LOGGER.debug("Suspended existing active user transaction before the restore operation starts", new Object[0]);
                }
                if ((problems = new JcrProblems(restoreActivity.execute())).hasProblems()) break block8;
                try {
                    repository.completeRestore(options);
                }
                catch (Throwable t) {
                    restoreActivity.problems.addError(t, JcrI18n.repositoryCannotBeRestartedAfterRestore, new Object[]{repository.getName(), t.getMessage()});
                }
                finally {
                    this.runningState.resumeExistingUserTransaction();
                }
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }
        LOGGER.debug("Completed restore of '{0}' repository from {1}", new Object[]{repository.getName(), backupLocString});
        return problems;
    }

    public BackupActivity createBackupActivity(File backupDirectory, BackupOptions options) {
        return new BackupActivity(backupDirectory, this.documentStore, this.binaryStore, this.repositoryCache, options);
    }

    public RestoreActivity createRestoreActivity(File backupDirectory, RestoreOptions options) {
        return new RestoreActivity(backupDirectory, this.documentStore, this.binaryStore, this.repositoryCache, options);
    }

    @NotThreadSafe
    public static final class RestoreActivity
    extends Activity {
        private final RestoreOptions options;

        protected RestoreActivity(File backupDirectory, LocalDocumentStore documentStore, BinaryStore binaryStore, RepositoryCache repositoryCache, RestoreOptions options) {
            super(backupDirectory, documentStore, binaryStore, repositoryCache);
            CheckArg.isNotNull((Object)options, (String)"restoreOptions");
            this.options = options;
        }

        @Override
        public org.modeshape.common.collection.Problems execute() {
            boolean includeBinaries;
            boolean bl = includeBinaries = this.binaryDirectory.exists() && this.binaryDirectory.canRead() && this.options.includeBinaries();
            if (includeBinaries) {
                LOGGER.debug("restoring binary files...", new Object[0]);
                this.removeExistingBinaryFiles();
                this.restoreBinaryFiles();
                if (this.problems.hasErrors()) {
                    return this.problems;
                }
            }
            this.removeExistingDocuments();
            if (this.problems.hasErrors()) {
                return this.problems;
            }
            this.restoreDocuments(this.backupDirectory);
            this.restoreDocuments(this.changeDirectory);
            if (this.problems.hasErrors()) {
                this.removeExistingBinaryFiles();
                this.removeExistingDocuments();
            }
            return this.problems;
        }

        private void removeExistingBinaryFiles() {
            try {
                Iterable<BinaryKey> keys = this.binaryStore.getAllBinaryKeys();
                this.binaryStore.markAsUnused(keys);
            }
            catch (BinaryStoreException e) {
                I18n msg = JcrI18n.problemsGettingBinaryKeysFromBinaryStore;
                this.problems.addError(msg, new Object[]{this.repositoryName(), this.backupLocation(), e.getMessage()});
            }
        }

        private void removeExistingDocuments() {
            LOGGER.debug("clearing existing persistent store...", new Object[0]);
            try {
                this.documentStore.runInTransaction(() -> {
                    this.documentStore.removeAll();
                    return null;
                }, 0, new String[0]);
            }
            catch (Throwable t) {
                this.problems.addError(t, JcrI18n.unexpectedProblemDuringRestore, new Object[]{t.getMessage()});
            }
        }

        private void restoreBinaryFiles() {
            for (File segment1Dir : this.binaryDirectory.listFiles()) {
                for (File segment2Dir : segment1Dir.listFiles()) {
                    for (File segment3Dir : segment2Dir.listFiles()) {
                        List<BinaryKey> restoredKeys = Arrays.stream(segment3Dir.listFiles()).map(this::restoreBinaryFile).filter(Objects::nonNull).collect(Collectors.toList());
                        try {
                            this.binaryStore.markAsUsed(restoredKeys);
                        }
                        catch (BinaryStoreException e) {
                            I18n msg = JcrI18n.problemsGettingBinaryKeysFromBinaryStore;
                            this.problems.addError(msg, new Object[]{this.repositoryName(), this.backupLocation(), e.getMessage()});
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BinaryKey restoreBinaryFile(File binaryFile) {
            BinaryKey binaryKey;
            if (!binaryFile.exists()) {
                return null;
            }
            if (!binaryFile.canRead()) {
                I18n msg = JcrI18n.problemsReadingBinaryFromBackup;
                BinaryKey key = this.binaryKeyFor(binaryFile, false);
                this.problems.addError(msg, new Object[]{key.toString(), this.repositoryName(), this.backupLocation()});
            }
            boolean isCompressed = FileUtil.getExtension((String)binaryFile.getAbsolutePath()).equals(".gz");
            InputStream stream = new FileInputStream(binaryFile);
            if (isCompressed) {
                stream = new GZIPInputStream(stream);
            }
            stream = new BufferedInputStream(stream);
            try {
                BinaryValue stored = this.binaryStore.storeValue(stream, isCompressed);
                assert (stored.getKey().equals(this.binaryKeyFor(binaryFile, isCompressed)));
                binaryKey = stored.getKey();
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Exception e) {
                    I18n msg = JcrI18n.problemsReadingBinaryFromBackup;
                    BinaryKey key = this.binaryKeyFor(binaryFile, isCompressed);
                    this.problems.addError((Throwable)e, msg, new Object[]{key.toString(), this.repositoryName(), this.backupLocation()});
                    return null;
                }
            }
            stream.close();
            return binaryKey;
        }

        protected BinaryKey binaryKeyFor(File binaryFile, boolean isCompressed) {
            String filename = binaryFile.getName();
            String sha1 = filename.replace(BackupService.BINARY_EXTENSION, "");
            if (isCompressed) {
                sha1 = sha1.replace(".gz", "");
            }
            return new BinaryKey(sha1);
        }

        protected void restoreDocuments(File directory) {
            BackupDocumentReader reader = new BackupDocumentReader(directory, BackupService.DOCUMENTS_FILENAME_PREFIX, (org.modeshape.common.collection.Problems)this.problems);
            LOGGER.debug("Restoring documents from {0}", new Object[]{directory.getAbsolutePath()});
            int count = 0;
            int batchSize = this.options.batchSize();
            int batchCounter = 0;
            ArrayList<Document> documentsBatch = new ArrayList<Document>();
            boolean eod = false;
            while (!eod) {
                while (batchCounter++ < batchSize) {
                    Document doc = reader.read();
                    if (doc == null) {
                        eod = true;
                        break;
                    }
                    documentsBatch.add(doc);
                }
                count += documentsBatch.size();
                if (documentsBatch.isEmpty()) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("restoring documents batch [{0}, {1}]", new Object[]{count - documentsBatch.size(), count - 1});
                }
                this.writeDocumentsBatch(documentsBatch);
                if (this.problems.hasErrors()) {
                    return;
                }
                documentsBatch.clear();
                batchCounter = 0;
            }
            LOGGER.debug("Restored {0} documents from {1}", new Object[]{count, directory.getAbsolutePath()});
        }

        private void writeDocumentsBatch(List<Document> documents) {
            try {
                this.documentStore.runInTransaction(() -> {
                    documents.forEach(this::restoreDocument);
                    return null;
                }, 0, new String[0]);
            }
            catch (Throwable t) {
                this.problems.addError(t, JcrI18n.unexpectedProblemDuringRestore, new Object[]{t.getMessage()});
            }
        }

        private void restoreDocument(Document document) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("restoring doc: {0}", new Object[]{document});
            }
            this.documentStore.put(document);
        }
    }

    @NotThreadSafe
    public static class BackupActivity
    extends Activity {
        private final BackupObserver observer;
        protected final ExecutorService changedDocumentWorker;
        protected final BlockingQueue<NodeKey> changedDocumentQueue;
        protected final BackupOptions options;

        protected BackupActivity(File backupDirectory, LocalDocumentStore documentStore, BinaryStore binaryStore, RepositoryCache repositoryCache, BackupOptions options) {
            super(backupDirectory, documentStore, binaryStore, repositoryCache);
            CheckArg.isNotNull((Object)options, (String)"options");
            CheckArg.isPositive((long)options.documentsPerFile(), (String)"documentsPerFile");
            this.options = options;
            this.changedDocumentQueue = new LinkedBlockingQueue<NodeKey>();
            NamedThreadFactory threadFactory = new NamedThreadFactory("modeshape-backup");
            this.changedDocumentWorker = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
            this.observer = new BackupObserver(this.changedDocumentQueue);
        }

        protected boolean initializeAreaOnDisk() {
            try {
                if (this.backupDirectory.exists()) {
                    if (!this.backupDirectory.isDirectory() || !this.backupDirectory.canWrite()) {
                        this.problems.addError(JcrI18n.existsAndMustBeWritableDirectory, new Object[]{this.backupLocation()});
                        return false;
                    }
                } else {
                    this.backupDirectory.mkdirs();
                }
                this.changeDirectory.mkdirs();
                if (this.options.includeBinaries()) {
                    this.binaryDirectory.mkdirs();
                }
            }
            catch (RuntimeException e) {
                this.problems.addError((Throwable)e, JcrI18n.problemInitializingBackupArea, new Object[]{this.backupLocation(), e.getMessage()});
            }
            return true;
        }

        protected void writeToContentArea(SchematicEntry document, BackupDocumentWriter contentWriter) {
            contentWriter.write(document.source());
        }

        protected void writeToContentArea(BinaryKey key, InputStream binaryContent) {
            String sha1 = key.toString();
            File first = new File(this.binaryDirectory, sha1.substring(0, 2));
            File second = new File(first, sha1.substring(2, 4));
            File third = new File(second, sha1.substring(4, 6));
            third.mkdirs();
            String filename = sha1 + BackupService.BINARY_EXTENSION;
            if (this.options.compress()) {
                filename = filename + ".gz";
            }
            File file = new File(third, filename);
            try {
                OutputStream outputStream = new FileOutputStream(file);
                if (this.options.compress()) {
                    outputStream = new GZIPOutputStream(outputStream);
                }
                outputStream = new BufferedOutputStream(outputStream);
                IoUtil.write((InputStream)binaryContent, (OutputStream)outputStream);
            }
            catch (Throwable t) {
                this.problems.addError(JcrI18n.problemsWritingDocumentToBackup, new Object[]{file.getAbsolutePath(), t.getMessage()});
            }
        }

        protected void writeToChangedArea(SchematicEntry entry, BackupDocumentWriter changesWriter) {
            LOGGER.debug("Writing document to change area of backup for {0} repository at {1}", new Object[]{this.repositoryName(), this.backupLocation()});
            changesWriter.write(entry.source());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeToChangedArea(Iterable<BinaryKey> unusedBinaries) {
            LOGGER.debug("Writing unused binaries to change area of backup for {0} repository at {1}", new Object[]{this.repositoryName(), this.backupLocation()});
            File file = new File(this.changeDirectory, BackupService.SUMMARY_FILE_NAME);
            try {
                EditableDocument doc = Schematic.newDocument();
                EditableArray keys = doc.setArray("unusedBinaryKeys");
                for (BinaryKey key : unusedBinaries) {
                    if (key == null) continue;
                    keys.add((Object)key.toString());
                }
                try (FileOutputStream outputStream = new FileOutputStream(file);){
                    Json.write((Document)doc, (OutputStream)outputStream);
                    outputStream.flush();
                }
            }
            catch (Throwable t) {
                this.problems.addError(JcrI18n.problemsWritingDocumentToBackup, new Object[]{file.getAbsolutePath(), t.getMessage()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public org.modeshape.common.collection.Problems execute() {
            if (!this.initializeAreaOnDisk()) {
                return this.problems;
            }
            LOGGER.debug("Starting backup of '{0}' repository into {1}", new Object[]{this.repositoryName(), this.backupLocation()});
            BackupDocumentWriter contentWriter = new BackupDocumentWriter(this.backupDirectory, BackupService.DOCUMENTS_FILENAME_PREFIX, this.options.documentsPerFile(), this.options.compress(), (org.modeshape.common.collection.Problems)this.problems);
            BackupDocumentWriter changesWriter = new BackupDocumentWriter(this.changeDirectory, BackupService.DOCUMENTS_FILENAME_PREFIX, this.options.documentsPerFile(), this.options.compress(), (org.modeshape.common.collection.Problems)this.problems);
            long numBinaryValues = 0L;
            NodeKey metadataKey = this.repositoryCache.getRepositoryMetadataDocumentKey();
            try {
                Object msg;
                AtomicBoolean continueWritingChangedDocuments = new AtomicBoolean(true);
                CountDownLatch changesLatch = new CountDownLatch(1);
                this.changedDocumentWorker.submit(() -> {
                    SchematicEntry entry;
                    NodeKey key;
                    try {
                        while (continueWritingChangedDocuments.get()) {
                            key = this.changedDocumentQueue.poll(1L, TimeUnit.SECONDS);
                            if (key == null || key.equals(metadataKey)) continue;
                            entry = this.documentStore.get(key.toString());
                            this.writeToChangedArea(entry, changesWriter);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    while (!this.changedDocumentQueue.isEmpty()) {
                        key = (NodeKey)this.changedDocumentQueue.poll();
                        if (key == null || key.equals(metadataKey)) continue;
                        entry = this.documentStore.get(key.toString());
                        this.writeToChangedArea(entry, changesWriter);
                    }
                    changesLatch.countDown();
                });
                this.repositoryCache.changeBus().register(this.observer);
                try {
                    AtomicInteger counter = new AtomicInteger();
                    List<String> keys = this.documentStore.keys();
                    keys.remove(metadataKey.toString());
                    int totalDocumentsCount = keys.size();
                    int batchSize = this.options.batchSize();
                    for (int startIdx = 0; startIdx < totalDocumentsCount; startIdx += batchSize) {
                        int estimatedEndIdx = startIdx + batchSize;
                        int endIdx = estimatedEndIdx < totalDocumentsCount ? estimatedEndIdx : totalDocumentsCount;
                        LOGGER.debug("writing batch [{0}, {1}] of documents from the content store...", new Object[]{startIdx, endIdx});
                        List<String> batchKeys = keys.subList(startIdx, endIdx);
                        this.batchWriteDocuments(batchKeys, contentWriter);
                        counter.addAndGet(batchKeys.size());
                        if (endIdx == totalDocumentsCount) break;
                    }
                    LOGGER.debug("Wrote {0} documents to {1}", new Object[]{counter, this.backupDirectory.getAbsolutePath()});
                    SchematicEntry entry = this.documentStore.get(metadataKey.toString());
                    this.writeToContentArea(entry, contentWriter);
                }
                catch (Exception e) {
                    msg = JcrI18n.problemObtainingDocumentsToBackup;
                    this.problems.addError((I18n)msg, new Object[]{this.repositoryName(), this.backupLocation(), e.getMessage()});
                }
                finally {
                    try {
                        this.repositoryCache.changeBus().unregister(this.observer);
                    }
                    finally {
                        continueWritingChangedDocuments.set(false);
                        this.changedDocumentWorker.shutdown();
                    }
                }
                if (this.options.includeBinaries()) {
                    LOGGER.debug("writing used binaries to backup location...", new Object[0]);
                    try {
                        int counter = 0;
                        for (BinaryKey binaryKey : this.binaryStore.getAllBinaryKeys()) {
                            try {
                                this.writeToContentArea(binaryKey, this.binaryStore.getInputStream(binaryKey));
                                ++counter;
                            }
                            catch (BinaryStoreException e) {
                                this.problems.addError(JcrI18n.problemsWritingBinaryToBackup, new Object[]{binaryKey, this.backupLocation(), e.getMessage()});
                            }
                        }
                        LOGGER.debug("Wrote {0} binary values to {1}", new Object[]{counter, this.binaryDirectory.getAbsolutePath()});
                        numBinaryValues += (long)counter;
                    }
                    catch (BinaryStoreException e) {
                        msg = JcrI18n.problemsGettingBinaryKeysFromBinaryStore;
                        this.problems.addError((I18n)msg, new Object[]{this.repositoryName(), this.backupLocation(), e.getMessage()});
                    }
                    int counter = 0;
                    LOGGER.debug("writing recently used binaries to backup location...", new Object[0]);
                    for (BinaryKey binaryKey : this.observer.getUsedBinaryKeys()) {
                        try {
                            this.writeToContentArea(binaryKey, this.binaryStore.getInputStream(binaryKey));
                            ++counter;
                        }
                        catch (BinaryStoreException e) {
                            this.problems.addError(JcrI18n.problemsWritingBinaryToBackup, new Object[]{binaryKey, this.backupLocation(), e.getMessage()});
                        }
                    }
                    LOGGER.debug("Wrote {0} recent binary values to {1}", new Object[]{counter, this.binaryDirectory.getAbsolutePath()});
                    numBinaryValues += (long)counter;
                    LOGGER.debug("writing unused binaries to the backup location...", new Object[0]);
                    this.writeToChangedArea(this.observer.getUnusedBinaryKeys());
                }
                changesLatch.await(30L, TimeUnit.SECONDS);
                LOGGER.debug("Completed backup of '{0}' repository into {1} (contains {2} nodes and {3} binary values)", new Object[]{this.repositoryName(), this.backupLocation(), contentWriter.getDocumentCount() + changesWriter.getDocumentCount(), numBinaryValues});
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                I18n msg = JcrI18n.interruptedWhilePerformingBackup;
                this.problems.addError(msg, new Object[]{this.repositoryName(), this.backupLocation(), e.getMessage()});
            }
            catch (CancellationException e) {
                this.problems.addError(JcrI18n.backupOperationWasCancelled, new Object[]{this.repositoryName(), this.backupLocation(), e.getMessage()});
            }
            finally {
                contentWriter.close();
                changesWriter.close();
            }
            return this.problems;
        }

        private void batchWriteDocuments(List<String> keys, BackupDocumentWriter contentWriter) {
            this.documentStore.load(keys).forEach(entry -> {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("backing up doc: {0}", new Object[]{entry.source()});
                }
                this.writeToContentArea((SchematicEntry)entry, contentWriter);
            });
        }
    }

    @NotThreadSafe
    public static abstract class Activity {
        protected final RepositoryCache repositoryCache;
        protected final File backupDirectory;
        protected final File changeDirectory;
        protected final File binaryDirectory;
        protected final LocalDocumentStore documentStore;
        protected final BinaryStore binaryStore;
        protected final SimpleProblems problems;
        private final String backupLocation;

        protected Activity(File backupDirectory, LocalDocumentStore documentStore, BinaryStore binaryStore, RepositoryCache repositoryCache) {
            this.backupDirectory = backupDirectory;
            this.changeDirectory = new File(this.backupDirectory, BackupService.CHANGED_AREA_DIR_NAME);
            this.binaryDirectory = new File(this.backupDirectory, BackupService.BINARY_AREA_DIR_NAME);
            this.backupLocation = this.backupDirectory.getAbsolutePath();
            this.documentStore = documentStore;
            this.binaryStore = binaryStore;
            this.repositoryCache = repositoryCache;
            this.problems = new SimpleProblems();
        }

        public abstract org.modeshape.common.collection.Problems execute();

        protected final String repositoryName() {
            return this.repositoryCache.getName();
        }

        protected final String backupLocation() {
            return this.backupLocation;
        }
    }

    protected static class FieldName {
        public static final String UNUSED_BINARY_KEYS = "unusedBinaryKeys";

        protected FieldName() {
        }
    }
}

