/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.EmptyIterator;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.DocumentNotFoundException;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.AbstractChildReferences;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.UnionIterator;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.schematic.document.Document;

public class ImmutableChildReferences {
    protected static final ChildReferences EMPTY_CHILD_REFERENCES = EmptyChildReferences.INSTANCE;
    protected static final Iterator<ChildReference> EMPTY_ITERATOR = new EmptyIterator();
    protected static final Iterator<NodeKey> EMPTY_KEY_ITERATOR = new EmptyIterator();

    public static ChildReferences create(DocumentTranslator documentTranslator, Document document, String childrenFieldName, boolean allowsSNS) {
        return new Medium(documentTranslator, document, childrenFieldName, allowsSNS);
    }

    public static ChildReferences union(ChildReferences first, ChildReferences second) {
        long firstSize = first.size();
        long secondSize = second.size();
        if (firstSize == 0L && secondSize == 0L) {
            return EMPTY_CHILD_REFERENCES;
        }
        if (firstSize == 0L) {
            return second;
        }
        if (secondSize == 0L) {
            return first;
        }
        return new ReferencesUnion(first, second);
    }

    public static ChildReferences create(ChildReferences first, DocumentTranslator.ChildReferencesInfo firstSegmentingInfo, WorkspaceCache cache, boolean allowsSNS) {
        if (firstSegmentingInfo == null || firstSegmentingInfo.nextKey == null) {
            return first;
        }
        return new Segmented(cache, first, firstSegmentingInfo, allowsSNS);
    }

    public static ChildReferences create(ChildReferences first, DocumentTranslator.ChildReferencesInfo firstSegmentingInfo, ChildReferences second, WorkspaceCache cache, boolean allowsSNS) {
        if (firstSegmentingInfo == null || firstSegmentingInfo.nextKey == null) {
            return ImmutableChildReferences.union(first, second);
        }
        Segmented segmentedReferences = new Segmented(cache, first, firstSegmentingInfo, allowsSNS);
        return ImmutableChildReferences.union(segmentedReferences, second);
    }

    protected static class Segment {
        private final ChildReferences references;
        private final String nextKey;
        private final boolean allowsSNS;
        private Segment next;

        protected Segment(ChildReferences references, String nextKey, boolean allowsSNS) {
            this.nextKey = nextKey;
            this.references = references;
            this.allowsSNS = allowsSNS;
        }

        public ChildReferences getReferences() {
            return this.references;
        }

        public Segment next(WorkspaceCache cache) {
            if (this.next == null && this.nextKey != null) {
                Document blockDoc = cache.blockFor(this.nextKey);
                if (blockDoc == null) {
                    throw new DocumentNotFoundException(this.nextKey);
                }
                ChildReferences refs = cache.translator().getChildReferencesFromBlock(blockDoc, this.allowsSNS);
                DocumentTranslator.ChildReferencesInfo nextNextKey = cache.translator().getChildReferencesInfo(blockDoc);
                this.next = new Segment(refs, nextNextKey != null ? nextNextKey.nextKey : null, this.allowsSNS);
            }
            return this.next;
        }

        public Iterator<NodeKey> keys() {
            return this.references.getAllKeys();
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            Iterator<ChildReference> iter = this.references.iterator();
            if (iter.hasNext()) {
                sb.append(iter.next());
                while (iter.hasNext()) {
                    sb.append(", ");
                    sb.append(iter.next());
                }
            }
            return sb;
        }
    }

    public static class ReferencesUnion
    extends AbstractChildReferences {
        private final ChildReferences firstReferences;
        protected final ChildReferences secondReferences;

        ReferencesUnion(ChildReferences firstReferences, ChildReferences secondReferences) {
            this.firstReferences = firstReferences;
            this.secondReferences = secondReferences;
        }

        @Override
        public long size() {
            return this.secondReferences.size() + this.firstReferences.size();
        }

        @Override
        public int getChildCount(Name name) {
            return this.secondReferences.getChildCount(name) + this.firstReferences.getChildCount(name);
        }

        @Override
        public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
            ChildReference firstReferencesChild = this.firstReferences.getChild(name, snsIndex, context);
            if (firstReferencesChild != null) {
                return firstReferencesChild;
            }
            return this.secondReferences.getChild(name, snsIndex, context);
        }

        @Override
        public boolean hasChild(NodeKey key) {
            return this.secondReferences.hasChild(key) || this.firstReferences.hasChild(key);
        }

        @Override
        public ChildReference getChild(NodeKey key) {
            return this.getChild(key, this.defaultContext());
        }

        @Override
        public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
            ChildReference firstReferencesChild = this.firstReferences.getChild(key, context);
            if (firstReferencesChild != null) {
                return firstReferencesChild;
            }
            return this.secondReferences.getChild(key, context);
        }

        @Override
        public Iterator<ChildReference> iterator() {
            return new UnionIterator<ChildReference>(this.firstReferences.iterator(), this.secondReferences);
        }

        @Override
        public Iterator<ChildReference> iterator(final Name name) {
            Iterable<ChildReference> second = new Iterable<ChildReference>(){

                @Override
                public Iterator<ChildReference> iterator() {
                    return secondReferences.iterator(name);
                }
            };
            return new UnionIterator<ChildReference>(this.firstReferences.iterator(name), second);
        }

        @Override
        public Iterator<NodeKey> getAllKeys() {
            HashSet<NodeKey> externalKeys = new HashSet<NodeKey>();
            Iterator<NodeKey> externalKeysIterator = this.secondReferences.getAllKeys();
            while (externalKeysIterator.hasNext()) {
                externalKeys.add(externalKeysIterator.next());
            }
            return new UnionIterator<NodeKey>(this.firstReferences.getAllKeys(), externalKeys);
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            sb.append("<second references=").append(this.secondReferences.toString());
            sb.append(">, <first references=").append(this.firstReferences.toString()).append(">");
            return sb;
        }

        @Override
        public boolean allowsSNS() {
            return this.firstReferences.allowsSNS() || this.secondReferences.allowsSNS();
        }
    }

    @Immutable
    public static class Segmented
    extends AbstractChildReferences {
        protected final WorkspaceCache cache;
        protected final long totalSize;
        protected final boolean allowsSNS;
        private Segment firstSegment;

        public Segmented(WorkspaceCache cache, ChildReferences firstSegment, DocumentTranslator.ChildReferencesInfo info, boolean allowsSNS) {
            this.cache = cache;
            this.totalSize = info.totalSize;
            this.firstSegment = new Segment(firstSegment, info.nextKey, allowsSNS);
            this.allowsSNS = allowsSNS;
        }

        @Override
        public long size() {
            return this.totalSize;
        }

        @Override
        public boolean supportsGetChildReferenceByKey() {
            return this.size() != -1L;
        }

        @Override
        public int getChildCount(Name name) {
            int result = 0;
            for (Segment segment = this.firstSegment; segment != null; segment = segment.next(this.cache)) {
                result += segment.getReferences().getChildCount(name);
            }
            return result;
        }

        @Override
        public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
            ChildReference result = null;
            for (Segment segment = this.firstSegment; segment != null; segment = segment.next(this.cache)) {
                result = segment.getReferences().getChild(name, snsIndex, context);
                if (result == null) continue;
                return result;
            }
            return result;
        }

        @Override
        public boolean hasChild(NodeKey key) {
            for (Segment segment = this.firstSegment; segment != null; segment = segment.next(this.cache)) {
                if (!segment.getReferences().hasChild(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ChildReference getChild(NodeKey key) {
            return this.getChild(key, this.defaultContext());
        }

        @Override
        public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
            ChildReference result = null;
            for (Segment segment = this.firstSegment; segment != null; segment = segment.next(this.cache)) {
                result = segment.getReferences().getChild(key, context);
                if (result == null) continue;
                return result;
            }
            return result;
        }

        @Override
        public Iterator<ChildReference> iterator(final Name name, final ChildReferences.Context context) {
            final Segment firstSegment = this.firstSegment;
            return new Iterator<ChildReference>(){
                private Segment segment;
                private Iterator<ChildReference> iter;
                private ChildReference next;
                {
                    this.segment = firstSegment;
                    this.iter = this.segment != null ? this.segment.getReferences().iterator(name, context) : EMPTY_ITERATOR;
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    if (!this.iter.hasNext()) {
                        while (this.segment != null) {
                            this.segment = this.segment.next(cache);
                            if (this.segment == null) continue;
                            this.iter = this.segment.getReferences().iterator(name, context);
                            if (!this.iter.hasNext()) continue;
                            this.next = this.iter.next();
                            return true;
                        }
                        return false;
                    }
                    this.next = this.iter.next();
                    return true;
                }

                @Override
                public ChildReference next() {
                    try {
                        if (this.next == null) {
                            if (this.hasNext()) {
                                ChildReference childReference = this.next;
                                return childReference;
                            }
                            throw new NoSuchElementException();
                        }
                        ChildReference childReference = this.next;
                        return childReference;
                    }
                    finally {
                        this.next = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Iterator<ChildReference> iterator(final ChildReferences.Context context) {
            final Segment firstSegment = this.firstSegment;
            return new Iterator<ChildReference>(){
                private Segment segment;
                private Iterator<ChildReference> iter;
                private ChildReference next;
                {
                    this.segment = firstSegment;
                    this.iter = this.segment != null ? this.segment.getReferences().iterator(context) : EMPTY_ITERATOR;
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    if (!this.iter.hasNext()) {
                        while (this.segment != null) {
                            this.segment = this.segment.next(cache);
                            if (this.segment == null) continue;
                            this.iter = this.segment.getReferences().iterator(context);
                            if (!this.iter.hasNext()) continue;
                            this.next = this.iter.next();
                            return true;
                        }
                        return false;
                    }
                    this.next = this.iter.next();
                    return true;
                }

                @Override
                public ChildReference next() {
                    try {
                        if (this.next == null) {
                            if (this.hasNext()) {
                                ChildReference childReference = this.next;
                                return childReference;
                            }
                            throw new NoSuchElementException();
                        }
                        ChildReference childReference = this.next;
                        return childReference;
                    }
                    finally {
                        this.next = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Iterator<NodeKey> getAllKeys() {
            final Segment firstSegment = this.firstSegment;
            return new Iterator<NodeKey>(){
                private Segment segment;
                private Iterator<NodeKey> iter;
                private NodeKey next;
                {
                    this.segment = firstSegment;
                    this.iter = this.segment != null ? this.segment.keys() : EMPTY_KEY_ITERATOR;
                }

                @Override
                public boolean hasNext() {
                    if (!this.iter.hasNext()) {
                        while (this.segment != null) {
                            this.segment = this.segment.next(cache);
                            if (this.segment == null) continue;
                            this.iter = this.segment.keys();
                            if (!this.iter.hasNext()) continue;
                            this.next = this.iter.next();
                            return true;
                        }
                        return false;
                    }
                    this.next = this.iter.next();
                    return true;
                }

                @Override
                public NodeKey next() {
                    try {
                        if (this.next == null) {
                            if (this.hasNext()) {
                                NodeKey nodeKey = this.next;
                                return nodeKey;
                            }
                            throw new NoSuchElementException();
                        }
                        NodeKey nodeKey = this.next;
                        return nodeKey;
                    }
                    finally {
                        this.next = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            Segment segment = this.firstSegment;
            while (segment != null) {
                segment.toString(sb);
                if (segment.next != null) {
                    sb.append(", ");
                } else if (segment.nextKey != null) {
                    sb.append(", <segment=").append(segment.nextKey).append('>');
                }
                segment = segment.next;
            }
            return sb;
        }

        @Override
        public boolean allowsSNS() {
            return this.allowsSNS;
        }
    }

    @Immutable
    protected static final class Medium
    extends AbstractChildReferences {
        private final Map<NodeKey, ChildReference> childReferencesByKey;
        private final Map<Name, List<NodeKey>> childKeysByName;
        private final boolean allowsSNS;

        protected Medium(DocumentTranslator documentTranslator, Document document, String childrenFieldName, boolean allowsSNS) {
            this.allowsSNS = allowsSNS;
            this.childKeysByName = new HashMap<Name, List<NodeKey>>();
            this.childReferencesByKey = new LinkedHashMap<NodeKey, ChildReference>();
            List documentArray = document.getArray(childrenFieldName);
            if (documentArray == null || documentArray.isEmpty()) {
                return;
            }
            for (Object value : documentArray) {
                ChildReference ref = documentTranslator.childReferenceFrom(value);
                if (ref == null) continue;
                Name refName = ref.getName();
                NodeKey refKey = ref.getKey();
                ChildReference old = this.childReferencesByKey.get(refKey);
                if (old != null && old.getName().equals(ref.getName())) continue;
                List<NodeKey> keysWithName = this.childKeysByName.get(refName);
                if (allowsSNS) {
                    int currentSNS = keysWithName != null ? this.childKeysByName.get(refName).size() : 0;
                    ChildReference refWithSNS = ref.with(currentSNS + 1);
                    this.childReferencesByKey.put(refKey, refWithSNS);
                } else {
                    this.childReferencesByKey.put(refKey, ref);
                }
                if (keysWithName == null) {
                    keysWithName = new ArrayList<NodeKey>();
                    this.childKeysByName.put(refName, keysWithName);
                }
                keysWithName.add(refKey);
            }
        }

        @Override
        public long size() {
            return this.childReferencesByKey.size();
        }

        @Override
        public int getChildCount(Name name) {
            List<NodeKey> nodeKeys = this.childKeysByName.get(name);
            return nodeKeys != null ? nodeKeys.size() : 0;
        }

        @Override
        public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
            if (!this.allowsSNS && snsIndex > 1) {
                return null;
            }
            ChildReferences.Changes changes = null;
            Iterator<ChildReferences.ChildInsertions> insertions = null;
            boolean includeRenames = false;
            if (context == null) {
                context = new ChildReferences.SingleNameContext();
            } else {
                changes = context.changes();
                if (changes != null) {
                    insertions = changes.insertions(name);
                    includeRenames = changes.isRenamed(name);
                }
            }
            List<NodeKey> childrenWithSameName = this.childKeysByName.get(name);
            if (changes == null) {
                if (childrenWithSameName == null) {
                    return null;
                }
                if (snsIndex > childrenWithSameName.size()) {
                    return null;
                }
                NodeKey childKey = childrenWithSameName.get(snsIndex - 1);
                return this.childReferencesByKey.get(childKey);
            }
            if (childrenWithSameName == null && !includeRenames) {
                if (insertions == null) {
                    return null;
                }
                while (insertions.hasNext()) {
                    ChildReferences.ChildInsertions inserted = insertions.next();
                    for (ChildReference result : inserted.inserted()) {
                        int index = context.consume(result.getName(), result.getKey());
                        if (index != snsIndex) continue;
                        return result.with(index);
                    }
                }
                return null;
            }
            if (insertions != null || includeRenames) {
                Iterator<ChildReference> iter = this.iterator(context, name);
                while (iter.hasNext()) {
                    ChildReference ref = iter.next();
                    if (ref.getSnsIndex() != snsIndex) continue;
                    return ref;
                }
                return null;
            }
            for (NodeKey key : childrenWithSameName) {
                ChildReference childWithSameName = this.childReferencesByKey.get(key);
                if (changes.isRemoved(childWithSameName) || changes.isRenamed(childWithSameName) || snsIndex != childWithSameName.getSnsIndex()) continue;
                return childWithSameName;
            }
            return null;
        }

        @Override
        public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
            ChildReferences.Changes changes;
            ChildReference ref = this.childReferencesByKey.get(key);
            if (ref == null) {
                ChildReferences.Changes changes2;
                if (context != null && (changes2 = context.changes()) != null && (ref = changes2.inserted(key)) != null) {
                    Iterator<ChildReference> iter = this.iterator(context, ref.getName());
                    while (iter.hasNext()) {
                        ChildReference child = iter.next();
                        if (!child.getKey().equals(key)) continue;
                        return child;
                    }
                }
            } else if (context != null && (changes = context.changes()) != null) {
                Iterator<ChildReferences.ChildInsertions> insertions;
                boolean renamed = false;
                if (changes.isRenamed(ref)) {
                    Name newName = changes.renamed(key);
                    ref = ref.with(newName, 1);
                    renamed = true;
                }
                if ((insertions = changes.insertions(ref.getName())) != null || renamed) {
                    Iterator<ChildReference> iter = this.iterator(context, ref.getName());
                    while (iter.hasNext()) {
                        ChildReference child = iter.next();
                        if (!child.getKey().equals(key)) continue;
                        return child;
                    }
                }
                if (changes.isRemoved(ref)) {
                    return null;
                }
            }
            return ref;
        }

        @Override
        public ChildReference getChild(NodeKey key) {
            return this.childReferencesByKey.get(key);
        }

        @Override
        public boolean hasChild(NodeKey key) {
            return this.childReferencesByKey.containsKey(key);
        }

        @Override
        public Iterator<ChildReference> iterator(Name name) {
            List<NodeKey> childKeys = this.childKeysByName.get(name);
            if (childKeys == null || childKeys.isEmpty()) {
                return Collections.emptyIterator();
            }
            final Iterator<NodeKey> childKeysIterator = childKeys.iterator();
            return new Iterator<ChildReference>(){

                @Override
                public boolean hasNext() {
                    return childKeysIterator.hasNext();
                }

                @Override
                public ChildReference next() {
                    return (ChildReference)childReferencesByKey.get(childKeysIterator.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Iterator<ChildReference> iterator() {
            return this.childReferencesByKey.values().iterator();
        }

        @Override
        public Iterator<ChildReference> iterator(Name name, ChildReferences.Context context) {
            if (context != null && context.changes() != null) {
                return super.iterator(name, context);
            }
            return this.iterator(name);
        }

        @Override
        public Iterator<ChildReference> iterator(ChildReferences.Context context) {
            if (context != null && context.changes() != null) {
                return super.iterator(context);
            }
            return this.iterator();
        }

        @Override
        public Iterator<NodeKey> getAllKeys() {
            return this.childReferencesByKey.keySet().iterator();
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            Iterator<ChildReference> iter = this.childReferencesByKey.values().iterator();
            if (iter.hasNext()) {
                sb.append(iter.next());
                while (iter.hasNext()) {
                    sb.append(", ");
                    sb.append(iter.next());
                }
            }
            return sb;
        }

        @Override
        public boolean allowsSNS() {
            return this.allowsSNS;
        }
    }

    @Immutable
    protected static final class EmptyChildReferences
    implements ChildReferences {
        public static final ChildReferences INSTANCE = new EmptyChildReferences();

        private EmptyChildReferences() {
        }

        @Override
        public boolean supportsGetChildReferenceByKey() {
            return true;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int getChildCount(Name name) {
            return 0;
        }

        @Override
        public ChildReference getChild(Name name) {
            return null;
        }

        @Override
        public ChildReference getChild(Name name, int snsIndex) {
            return null;
        }

        @Override
        public ChildReference getChild(Name name, int snsIndex, ChildReferences.Context context) {
            return null;
        }

        @Override
        public ChildReference getChild(Path.Segment segment) {
            return null;
        }

        @Override
        public ChildReference getChild(NodeKey key) {
            return null;
        }

        @Override
        public ChildReference getChild(NodeKey key, ChildReferences.Context context) {
            return null;
        }

        @Override
        public boolean hasChild(NodeKey key) {
            return false;
        }

        @Override
        public Iterator<ChildReference> iterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<ChildReference> iterator(Name name) {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<ChildReference> iterator(Name name, ChildReferences.Context context) {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<ChildReference> iterator(ChildReferences.Context context) {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<ChildReference> iterator(Collection<?> namePatterns, NamespaceRegistry registry) {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<ChildReference> iterator(ChildReferences.Context context, Collection<?> namePatterns, NamespaceRegistry registry) {
            return EMPTY_ITERATOR;
        }

        @Override
        public Iterator<NodeKey> getAllKeys() {
            return EMPTY_KEY_ITERATOR;
        }

        @Override
        public boolean allowsSNS() {
            return false;
        }
    }
}

