/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactories;

public class MapDB {
    public static final Serializer<NodeKey> NODE_KEY_SERIALIZER = new NodeKeySerializer();
    protected static final Serializer<?> DEFAULT_SERIALIZER = Serializer.BASIC;
    protected static final BTreeKeySerializer<?> DEFAULT_BTREE_KEY_SERIALIZER = BTreeKeySerializer.BASIC;

    public static Serializers serializers(ValueFactories factories) {
        return new SerializerSupplier(factories);
    }

    public static <T> BTreeKeySerializer<UniqueKey<T>> uniqueKeyBTreeSerializer(Serializer<T> serializer, Comparator<T> comparator) {
        return new UniqueKeyBTreeSerializer<T>(serializer, MapDB.uniqueKeyComparator(comparator));
    }

    public static <T> Serializer<UniqueKey<T>> uniqueKeySerializer(Serializer<T> serializer, Comparator<T> comparator) {
        return new UniqueKeySerializer<T>(serializer, MapDB.uniqueKeyComparator(comparator));
    }

    public static <T> Comparator<UniqueKey<T>> uniqueKeyComparator(Comparator<T> comparator) {
        return new UniqueKeyComparator<T>(comparator);
    }

    public static <A, B> Comparator<Fun.Tuple2<A, B>> tupleComparator(Comparator<A> aComparator, Comparator<B> bComparator) {
        return new TupleComparator<A, B>(aComparator, bComparator);
    }

    public static <A, B> BTreeKeySerializer<Fun.Tuple2<A, B>> tupleBTreeSerializer(Comparator<A> aComparator, Serializer<A> aSerializer, Serializer<B> bSerializer, Comparator<Fun.Tuple2<A, B>> tupleComparator) {
        return new LocalTuple2KeySerializer<A, B>(aComparator, aSerializer, bSerializer, tupleComparator);
    }

    private MapDB() {
    }

    protected static final class TupleComparator<A, B>
    implements Comparator<Fun.Tuple2<A, B>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Comparator<A> aComparator;
        private final Comparator<B> bComparator;

        protected TupleComparator(Comparator<A> aComparator, Comparator<B> bComparator) {
            this.aComparator = aComparator;
            this.bComparator = bComparator;
        }

        @Override
        public int compare(Fun.Tuple2<A, B> o1, Fun.Tuple2<A, B> o2) {
            int i = this.aComparator.compare(o1.a, o2.a);
            if (i != 0) {
                return i;
            }
            if (o1.b == null) {
                if (o2.b == null) {
                    return 0;
                }
                return -1;
            }
            if (o2.b == null) {
                return 1;
            }
            if (o1.b == Fun.HI) {
                if (o2.b == Fun.HI) {
                    return 0;
                }
                return 1;
            }
            if (o2.b == Fun.HI) {
                return -1;
            }
            i = this.bComparator.compare(o1.b, o2.b);
            return i;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof TupleComparator) {
                TupleComparator that = (TupleComparator)obj;
                return this.aComparator.equals(that.aComparator) && this.bComparator.equals(that.bComparator);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }
    }

    protected static final class LocalTuple2KeySerializer<A, B>
    extends BTreeKeySerializer<Fun.Tuple2<A, B>>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        protected final Comparator<A> aComparator;
        protected final Serializer<A> aSerializer;
        protected final Serializer<B> bSerializer;
        protected final Comparator<Fun.Tuple2<A, B>> comparator;

        public LocalTuple2KeySerializer(Comparator<A> aComparator, Serializer<A> aSerializer, Serializer<B> bSerializer, Comparator<Fun.Tuple2<A, B>> comparator) {
            this.aComparator = aComparator;
            this.aSerializer = aSerializer;
            this.bSerializer = bSerializer;
            this.comparator = comparator;
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            int acount = 0;
            for (int i = start; i < end; ++i) {
                Fun.Tuple2 t = (Fun.Tuple2)keys[i];
                if (acount == 0) {
                    this.aSerializer.serialize(out, t.a);
                    acount = 1;
                    while (i + acount < end && this.aComparator.compare(t.a, ((Fun.Tuple2)keys[i + acount]).a) == 0) {
                        ++acount;
                    }
                    DataOutput2.packInt((DataOutput)out, (int)acount);
                }
                this.bSerializer.serialize(out, t.b);
                --acount;
            }
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            Object a = null;
            int acount = 0;
            for (int i = start; i < end; ++i) {
                if (acount == 0) {
                    a = this.aSerializer.deserialize(in, -1);
                    acount = DataInput2.unpackInt((DataInput)in);
                }
                Object b = this.bSerializer.deserialize(in, -1);
                ret[i] = Fun.t2((Object)a, (Object)b);
                --acount;
            }
            assert (acount == 0);
            return ret;
        }

        public Comparator<Fun.Tuple2<A, B>> getComparator() {
            return this.comparator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalTuple2KeySerializer t = (LocalTuple2KeySerializer)o;
            return Fun.eq(this.aComparator, t.aComparator) && Fun.eq(this.aSerializer, t.aSerializer) && Fun.eq(this.bSerializer, t.bSerializer);
        }

        public int hashCode() {
            int result = this.aComparator != null ? this.aComparator.hashCode() : 0;
            result = 31 * result + (this.aSerializer != null ? this.aSerializer.hashCode() : 0);
            result = 31 * result + (this.bSerializer != null ? this.bSerializer.hashCode() : 0);
            return result;
        }
    }

    public static class DoubleSerializer
    implements Serializer<Double>,
    Serializable {
        private static final long serialVersionUID = 1L;

        public void serialize(DataOutput out, Double value) throws IOException {
            out.writeDouble(value);
        }

        public Double deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return null;
            }
            return in.readDouble();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof DoubleSerializer;
        }

        public int hashCode() {
            return 1;
        }

        public int fixedSize() {
            return -1;
        }
    }

    public static interface KeySerializerWithComparator<K> {
        public BTreeKeySerializer<K> withComparator(Comparator<?> var1);
    }

    public static final class DelegatingKeySerializer<K extends Comparable<K>>
    extends BTreeKeySerializer<K>
    implements Serializable,
    KeySerializerWithComparator<K> {
        private static final long serialVersionUID = 1L;
        protected final Serializer<K> defaultSerializer;
        protected final Comparator<K> comparator;

        public DelegatingKeySerializer(Serializer<K> defaultSerializer) {
            this(defaultSerializer, null);
        }

        public DelegatingKeySerializer(Serializer<K> defaultSerializer, Comparator<K> comparator) {
            this.defaultSerializer = defaultSerializer;
            this.comparator = comparator != null ? comparator : new NaturalComparator();
        }

        public Comparator<K> getComparator() {
            return this.comparator;
        }

        @Override
        public BTreeKeySerializer<K> withComparator(Comparator<?> comparator) {
            if (comparator == null) {
                return this;
            }
            return new DelegatingKeySerializer<K>(this.defaultSerializer, comparator);
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            for (int i = start; i < end; ++i) {
                this.defaultSerializer.serialize(out, (Object)((Comparable)keys[i]));
            }
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            for (int i = start; i < end; ++i) {
                ret[i] = this.defaultSerializer.deserialize(in, -1);
            }
            return ret;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof DelegatingKeySerializer) {
                DelegatingKeySerializer that = (DelegatingKeySerializer)obj;
                return this.defaultSerializer.equals(that.defaultSerializer) && this.comparator.equals(that.comparator);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "DelegatingBTreeSerializer<" + this.defaultSerializer + ">";
        }
    }

    public static class NaturalComparator<K extends Comparable<K>>
    implements Comparator<K>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(K o1, K o2) {
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof NaturalComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    public static final class UniqueKeyBTreeSerializer<K>
    extends BTreeKeySerializer<UniqueKey<K>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final Serializer<K> keySerializer;
        protected final Comparator<UniqueKey<K>> comparator;

        public UniqueKeyBTreeSerializer(Serializer<K> keySerializer, Comparator<UniqueKey<K>> comparator) {
            this.keySerializer = keySerializer;
            this.comparator = comparator;
        }

        public Comparator<UniqueKey<K>> getComparator() {
            return this.comparator;
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            for (int i = start; i < end; ++i) {
                UniqueKey key = (UniqueKey)keys[i];
                this.keySerializer.serialize(out, key.actualKey);
                out.writeLong(key.id);
            }
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            for (int i = start; i < end; ++i) {
                Object key = this.keySerializer.deserialize(in, -1);
                long id = in.readLong();
                ret[i] = new UniqueKey<Object>(key, id);
            }
            return ret;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof UniqueKeyBTreeSerializer) {
                UniqueKeyBTreeSerializer that = (UniqueKeyBTreeSerializer)obj;
                return this.keySerializer.equals(that.keySerializer) && this.comparator.equals(that.comparator);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "UniqueKeyBTreeSerializer<" + this.keySerializer + ">";
        }
    }

    public static final class UniqueKeySerializer<K>
    implements Serializer<UniqueKey<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final Serializer<K> keySerializer;
        protected final Comparator<UniqueKey<K>> comparator;

        public UniqueKeySerializer(Serializer<K> keySerializer, Comparator<UniqueKey<K>> comparator) {
            this.keySerializer = keySerializer;
            this.comparator = comparator;
        }

        public UniqueKey<K> deserialize(DataInput in, int available) throws IOException {
            Object actualKey = this.keySerializer.deserialize(in, available);
            long id = in.readLong();
            return new UniqueKey<Object>(actualKey, id);
        }

        public void serialize(DataOutput out, UniqueKey<K> value) throws IOException {
            this.keySerializer.serialize(out, value.actualKey);
            out.writeLong(value.id);
        }

        public int fixedSize() {
            return -1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof UniqueKeySerializer) {
                UniqueKeySerializer that = (UniqueKeySerializer)obj;
                return this.keySerializer.equals(that.keySerializer) && this.comparator.equals(that.comparator);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "UniqueKeySerializer<" + this.keySerializer + ">";
        }
    }

    public static final class ComparableUniqueKeyComparator<K>
    implements Comparator<UniqueKey<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(UniqueKey<K> o1, UniqueKey<K> o2) {
            if (o1 == o2) {
                return 0;
            }
            int diff = ObjectUtil.compareWithNulls((Comparable)((Comparable)o1.actualKey), (Comparable)((Comparable)o2.actualKey));
            if (diff != 0) {
                return diff;
            }
            long ldiff = o1.id - o2.id;
            return ldiff == 0L ? 0 : (ldiff <= 0L ? -1 : 1);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof ComparableUniqueKeyComparator;
        }

        public int hashCode() {
            return 1;
        }
    }

    public static final class UniqueKeyComparator<K>
    implements Comparator<UniqueKey<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Comparator<K> valueComparator;

        public UniqueKeyComparator(Comparator<K> valueComparator) {
            this.valueComparator = valueComparator;
        }

        @Override
        public int compare(UniqueKey<K> o1, UniqueKey<K> o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            int diff = this.valueComparator.compare(o1.actualKey, o2.actualKey);
            if (diff != 0) {
                return diff;
            }
            long ldiff = o1.id - o2.id;
            return ldiff == 0L ? 0 : (ldiff <= 0L ? -1 : 1);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof UniqueKeyComparator) {
                UniqueKeyComparator that = (UniqueKeyComparator)obj;
                return this.valueComparator.equals(that.valueComparator);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }
    }

    public static final class UniqueKey<K>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final K actualKey;
        protected final long id;
        private final int hc;

        public UniqueKey(K actualKey, long id) {
            this.actualKey = actualKey;
            this.id = id;
            this.hc = actualKey != null ? actualKey.hashCode() : 0;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UniqueKey) {
                UniqueKey that = (UniqueKey)obj;
                if (this.actualKey == null && that.actualKey != null) {
                    return false;
                }
                if (!this.actualKey.equals(that.actualKey)) {
                    return false;
                }
                return this.id == that.id;
            }
            return false;
        }

        public String toString() {
            return "[" + this.actualKey + "," + this.id + "]";
        }
    }

    private static class BTreeKeySerializerWitheComparator<T>
    extends BTreeKeySerializer<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final BTreeKeySerializer<?> original;
        private final Comparator<T> comparator;

        protected BTreeKeySerializerWitheComparator(BTreeKeySerializer<?> original, Comparator<T> comparator) {
            this.original = original;
            this.comparator = comparator;
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            return this.original.deserialize(in, start, end, size);
        }

        public Comparator<T> getComparator() {
            return this.comparator;
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            this.original.serialize(out, start, end, keys);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof BTreeKeySerializerWitheComparator) {
                BTreeKeySerializerWitheComparator that = (BTreeKeySerializerWitheComparator)obj;
                return this.original.equals(that.original) && this.comparator.equals(this.comparator);
            }
            return false;
        }

        public int hashCode() {
            return 1;
        }
    }

    private static class NodeKeySerializer
    implements Serializer<NodeKey>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NodeKeySerializer() {
        }

        public void serialize(DataOutput out, NodeKey value) throws IOException {
            out.writeUTF(value.toString());
        }

        public NodeKey deserialize(DataInput in, int available) throws IOException {
            String keyStr = in.readUTF();
            return new NodeKey(keyStr);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof NodeKeySerializer;
        }

        public int hashCode() {
            return 1;
        }

        public int fixedSize() {
            return -1;
        }
    }

    public static final class SerializerSupplier
    implements Serializers {
        private final Map<Class<?>, Serializer<?>> serializersByClass;
        private final Map<Class<?>, Serializer<?>> nullSafeSerializersByClass;
        private final Map<Class<?>, BTreeKeySerializer<?>> bTreeKeySerializersByClass;
        private final Serializer<?> DEFAULT_NULL_SAFE_SERIALIZER = SerializerSupplier.isNullSafe(DEFAULT_SERIALIZER) ? DEFAULT_SERIALIZER : new NullSafeSerializer(DEFAULT_SERIALIZER);

        protected SerializerSupplier(ValueFactories factories) {
            this.serializersByClass = new HashMap();
            this.serializersByClass.put(String.class, Serializer.STRING);
            this.serializersByClass.put(Long.class, Serializer.LONG);
            this.serializersByClass.put(Boolean.class, Serializer.BOOLEAN);
            this.serializersByClass.put(Double.class, new DoubleSerializer());
            this.serializersByClass.put(BigDecimal.class, Serializer.JAVA);
            this.serializersByClass.put(URI.class, Serializer.JAVA);
            this.serializersByClass.put(DateTime.class, Serializer.JAVA);
            this.serializersByClass.put(Path.class, Serializer.JAVA);
            this.serializersByClass.put(Name.class, Serializer.JAVA);
            this.serializersByClass.put(Reference.class, Serializer.JAVA);
            this.serializersByClass.put(NodeKey.class, NODE_KEY_SERIALIZER);
            this.bTreeKeySerializersByClass = new HashMap();
            this.nullSafeSerializersByClass = new HashMap();
            for (Map.Entry<Class<?>, Serializer<?>> entry : this.serializersByClass.entrySet()) {
                NullSafeSerializer serializer = entry.getValue();
                DelegatingKeySerializer bTreeSerializer = new DelegatingKeySerializer(serializer);
                this.bTreeKeySerializersByClass.put(entry.getKey(), bTreeSerializer);
                NullSafeSerializer nullsafe = SerializerSupplier.isNullSafe(serializer) ? serializer : new NullSafeSerializer(serializer);
                this.nullSafeSerializersByClass.put(entry.getKey(), nullsafe);
            }
        }

        private static <T> boolean isNullSafe(Serializer<T> serializer) {
            try {
                serializer.serialize((DataOutput)new DataOutput2(), null);
                return true;
            }
            catch (IOException | NullPointerException e) {
                return false;
            }
        }

        @Override
        public Serializer<?> serializerFor(Class<?> type) {
            Serializer<?> result = this.serializersByClass.get(type);
            if (result != null) {
                return result;
            }
            return DEFAULT_SERIALIZER;
        }

        @Override
        public Serializer<?> nullSafeSerializerFor(Class<?> type) {
            Serializer<?> result = this.nullSafeSerializersByClass.get(type);
            if (result != null) {
                return result;
            }
            return this.DEFAULT_NULL_SAFE_SERIALIZER;
        }

        @Override
        public BTreeKeySerializer<?> bTreeKeySerializerFor(Class<?> type, Comparator<?> comparator, boolean pack) {
            BTreeKeySerializer<?> result;
            Map<Class<?>, BTreeKeySerializer<?>> byClass = this.bTreeKeySerializersByClass;
            BTreeKeySerializer<?> bTreeKeySerializer = result = byClass.containsKey(type) ? byClass.get(type) : DEFAULT_BTREE_KEY_SERIALIZER;
            if (result instanceof KeySerializerWithComparator) {
                KeySerializerWithComparator serializer = (KeySerializerWithComparator)result;
                assert (comparator != null);
                return serializer.withComparator(comparator);
            }
            return this.bTreeKeySerializerWith(result, comparator);
        }

        private <T> BTreeKeySerializer<T> bTreeKeySerializerWith(BTreeKeySerializer<?> original, Comparator<T> comparator) {
            return new BTreeKeySerializerWitheComparator<T>(original, comparator);
        }

        private static class NullSafeSerializer<T>
        implements Serializer<T>,
        Serializable {
            private Serializer<T> baseSerializer;

            public NullSafeSerializer(Serializer<T> baseSerializer) {
                this.baseSerializer = baseSerializer;
            }

            public void serialize(DataOutput dataOutput, T t) throws IOException {
                if (t == null) {
                    dataOutput.writeBoolean(false);
                } else {
                    dataOutput.writeBoolean(true);
                    this.baseSerializer.serialize(dataOutput, t);
                }
            }

            public T deserialize(DataInput dataInput, int i) throws IOException {
                if (!dataInput.readBoolean()) {
                    return null;
                }
                return (T)this.baseSerializer.deserialize(dataInput, i);
            }

            public int fixedSize() {
                return -1;
            }
        }
    }

    public static interface Serializers {
        public Serializer<?> serializerFor(Class<?> var1);

        public BTreeKeySerializer<?> bTreeKeySerializerFor(Class<?> var1, Comparator<?> var2, boolean var3);

        public Serializer<?> nullSafeSerializerFor(Class<?> var1);
    }
}

