/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.util.Optional;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.txn.LocalTransaction;
import org.modeshape.schematic.annotation.ThreadSafe;

@ThreadSafe
@Immutable
public class LocalTransactionManager
implements TransactionManager {
    private static final ThreadLocal<Optional<LocalTransaction>> ACTIVE_TRANSACTION = ThreadLocal.withInitial(Optional::empty);

    public void begin() throws NotSupportedException, SystemException {
        if (LocalTransactionManager.hasActiveTransaction()) {
            throw new NotSupportedException("Nested transactions are not supported");
        }
        ACTIVE_TRANSACTION.set(Optional.of(new LocalTransaction()));
    }

    protected static boolean hasActiveTransaction() {
        return ACTIVE_TRANSACTION.get().isPresent();
    }

    protected static void clear() {
        ACTIVE_TRANSACTION.set(Optional.empty());
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        LocalTransactionManager.transactionForThread().commit();
    }

    protected static LocalTransaction transactionForThread() {
        return ACTIVE_TRANSACTION.get().orElseThrow(() -> new IllegalStateException("Current thread does not have a transaction"));
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        LocalTransactionManager.transactionForThread().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        LocalTransactionManager.transactionForThread().setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        Optional<LocalTransaction> localTransaction = ACTIVE_TRANSACTION.get();
        return localTransaction.isPresent() ? localTransaction.get().getStatus() : 6;
    }

    public Transaction getTransaction() throws SystemException {
        return ACTIVE_TRANSACTION.get().orElse(null);
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        throw new UnsupportedOperationException();
    }

    public Transaction suspend() throws SystemException {
        Optional<LocalTransaction> localTransaction = ACTIVE_TRANSACTION.get();
        if (localTransaction.isPresent()) {
            LocalTransaction tx = localTransaction.get();
            LocalTransactionManager.clear();
            return tx;
        }
        return null;
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (ACTIVE_TRANSACTION.get().isPresent()) {
            throw new IllegalStateException("Current thread has a tx associated");
        }
        if (!(tobj instanceof LocalTransaction)) {
            throw new InvalidTransactionException(tobj + " is not a valid local transaction");
        }
        ACTIVE_TRANSACTION.set(Optional.of((LocalTransaction)tobj));
    }
}

