/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.document;

import java.io.Serializable;
import java.util.Arrays;
import org.modeshape.schematic.Base64;
import org.modeshape.schematic.annotation.Immutable;

@Immutable
public final class Binary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte type;
    private final byte[] data;

    public Binary(byte[] data) {
        this.type = 0;
        this.data = data;
    }

    public Binary(byte type, byte[] data) {
        this.type = type;
        this.data = data;
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int length() {
        return this.data.length;
    }

    public int hashCode() {
        return this.length();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Binary) {
            Binary that = (Binary)obj;
            if (this.getType() != that.getType()) {
                return false;
            }
            if (this.length() != that.length()) {
                return false;
            }
            return Arrays.equals(this.getBytes(), that.getBytes());
        }
        return false;
    }

    public String toString() {
        return "Binary (" + this.type + ':' + this.length() + ')';
    }

    public String getBytesInBase64() {
        return Base64.encodeBytes(this.data);
    }
}

