/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class BoostQuery
extends Query {
    private final Query query;
    private final float boost;

    public BoostQuery(Query query, float boost) {
        this.query = Objects.requireNonNull(query);
        this.boost = boost;
    }

    public Query getQuery() {
        return this.query;
    }

    public float getBoost() {
        return this.boost;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BoostQuery that = (BoostQuery)obj;
        return this.query.equals(that.query) && Float.floatToIntBits(this.boost) == Float.floatToIntBits(that.boost);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = 31 * h + this.query.hashCode();
        h = 31 * h + Float.floatToIntBits(this.boost);
        return h;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (this.boost == 1.0f) {
            return rewritten;
        }
        if (rewritten.getClass() == BoostQuery.class) {
            BoostQuery in = (BoostQuery)rewritten;
            return new BoostQuery(in.query, this.boost * in.boost);
        }
        if (this.boost == 0.0f && rewritten.getClass() != ConstantScoreQuery.class) {
            return new BoostQuery(new ConstantScoreQuery(rewritten), 0.0f);
        }
        if (this.query != rewritten) {
            return new BoostQuery(rewritten, this.boost);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.query.toString(field));
        builder.append(")");
        builder.append("^");
        builder.append(this.boost);
        return builder.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight weight = this.query.createWeight(searcher, needsScores);
        if (!needsScores) {
            return weight;
        }
        weight.normalize(1.0f, this.boost);
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
                weight.extractTerms(terms);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return weight.explain(context, doc);
            }

            @Override
            public float getValueForNormalization() throws IOException {
                return weight.getValueForNormalization();
            }

            @Override
            public void normalize(float norm, float boost) {
                weight.normalize(norm, BoostQuery.this.boost * boost);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return weight.scorer(context);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                return weight.bulkScorer(context);
            }
        };
    }
}

