/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public final class ConstantScoreQuery
extends Query {
    private final Query query;

    public ConstantScoreQuery(Query query) {
        this.query = Objects.requireNonNull(query, "Query must not be null");
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (rewritten != this.query) {
            return new ConstantScoreQuery(rewritten);
        }
        if (rewritten.getClass() == ConstantScoreQuery.class) {
            return rewritten;
        }
        if (rewritten.getClass() == BoostQuery.class) {
            return new ConstantScoreQuery(((BoostQuery)rewritten).getQuery());
        }
        return super.rewrite(reader);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight innerWeight = searcher.createWeight(this.query, false);
        if (needsScores) {
            return new ConstantScoreWeight(this){

                @Override
                public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                    BulkScorer innerScorer = innerWeight.bulkScorer(context);
                    if (innerScorer == null) {
                        return null;
                    }
                    return new ConstantBulkScorer(innerScorer, this, this.score());
                }

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    final Scorer innerScorer = innerWeight.scorer(context);
                    if (innerScorer == null) {
                        return null;
                    }
                    final float score = this.score();
                    return new FilterScorer(innerScorer){

                        @Override
                        public float score() throws IOException {
                            return score;
                        }

                        @Override
                        public int freq() throws IOException {
                            return 1;
                        }

                        @Override
                        public Collection<Scorer.ChildScorer> getChildren() {
                            return Collections.singleton(new Scorer.ChildScorer(innerScorer, "constant"));
                        }
                    };
                }
            };
        }
        return innerWeight;
    }

    @Override
    public String toString(String field) {
        return "ConstantScore(" + this.query.toString(field) + ')';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof ConstantScoreQuery) {
            ConstantScoreQuery other = (ConstantScoreQuery)o;
            return this.query.equals(other.query);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.query.hashCode();
    }

    protected class ConstantBulkScorer
    extends BulkScorer {
        final BulkScorer bulkScorer;
        final Weight weight;
        final float theScore;

        public ConstantBulkScorer(BulkScorer bulkScorer, Weight weight, float theScore) {
            this.bulkScorer = bulkScorer;
            this.weight = weight;
            this.theScore = theScore;
        }

        @Override
        public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
            return this.bulkScorer.score(this.wrapCollector(collector), acceptDocs, min, max);
        }

        private LeafCollector wrapCollector(LeafCollector collector) {
            return new FilterLeafCollector(collector){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    this.in.setScorer(new FilterScorer(scorer){

                        @Override
                        public float score() throws IOException {
                            return ConstantBulkScorer.this.theScore;
                        }

                        @Override
                        public int freq() throws IOException {
                            return 1;
                        }
                    });
                }
            };
        }

        @Override
        public long cost() {
            return this.bulkScorer.cost();
        }
    }
}

