/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;

public final class SpanBoostQuery
extends SpanQuery {
    private final SpanQuery query;
    private final float boost;

    public SpanBoostQuery(SpanQuery query, float boost) {
        this.query = Objects.requireNonNull(query);
        this.boost = boost;
    }

    public SpanQuery getQuery() {
        return this.query;
    }

    public float getBoost() {
        return this.boost;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SpanBoostQuery that = (SpanBoostQuery)obj;
        return this.query.equals(that.query) && Float.floatToIntBits(this.boost) == Float.floatToIntBits(that.boost);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = 31 * h + this.query.hashCode();
        h = 31 * h + Float.floatToIntBits(this.boost);
        return h;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.boost == 1.0f) {
            return this.query;
        }
        SpanQuery rewritten = (SpanQuery)this.query.rewrite(reader);
        if (this.query != rewritten) {
            return new SpanBoostQuery(rewritten, this.boost);
        }
        if (this.query.getClass() == SpanBoostQuery.class) {
            SpanBoostQuery in = (SpanBoostQuery)this.query;
            return new SpanBoostQuery(in.query, this.boost * in.boost);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.query.toString(field));
        builder.append(")^");
        builder.append(this.boost);
        return builder.toString();
    }

    @Override
    public String getField() {
        return this.query.getField();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final SpanWeight weight = this.query.createWeight(searcher, needsScores);
        if (!needsScores) {
            return weight;
        }
        TreeMap<Term, TermContext> terms = new TreeMap<Term, TermContext>();
        weight.extractTermContexts(terms);
        weight.normalize(1.0f, this.boost);
        return new SpanWeight(this, searcher, terms){

            @Override
            public void extractTerms(Set<Term> terms) {
                weight.extractTerms(terms);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return weight.explain(context, doc);
            }

            @Override
            public float getValueForNormalization() throws IOException {
                return weight.getValueForNormalization();
            }

            @Override
            public void normalize(float norm, float boost) {
                weight.normalize(norm, SpanBoostQuery.this.boost * boost);
            }

            @Override
            public Spans getSpans(LeafReaderContext ctx, SpanWeight.Postings requiredPostings) throws IOException {
                return weight.getSpans(ctx, requiredPostings);
            }

            @Override
            public SpanScorer scorer(LeafReaderContext context) throws IOException {
                return weight.scorer(context);
            }

            @Override
            public void extractTermContexts(Map<Term, TermContext> contexts) {
                weight.extractTermContexts(contexts);
            }
        };
    }
}

