/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.bkd.HeapPointReader;
import org.apache.lucene.util.bkd.PointReader;
import org.apache.lucene.util.bkd.PointWriter;

final class HeapPointWriter
implements PointWriter {
    int[] docIDs;
    long[] ords;
    private int nextWrite;
    private boolean closed;
    final int maxSize;
    final int valuesPerBlock;
    final int packedBytesLength;
    final List<byte[]> blocks = new ArrayList<byte[]>();

    public HeapPointWriter(int initSize, int maxSize, int packedBytesLength) {
        this.docIDs = new int[initSize];
        this.ords = new long[initSize];
        this.maxSize = maxSize;
        this.packedBytesLength = packedBytesLength;
        this.valuesPerBlock = Math.max(1, 4096 / packedBytesLength);
    }

    public void copyFrom(HeapPointWriter other) {
        if (this.docIDs.length < other.nextWrite) {
            throw new IllegalStateException("docIDs.length=" + this.docIDs.length + " other.nextWrite=" + other.nextWrite);
        }
        System.arraycopy(other.docIDs, 0, this.docIDs, 0, other.nextWrite);
        System.arraycopy(other.ords, 0, this.ords, 0, other.nextWrite);
        for (byte[] block : other.blocks) {
            this.blocks.add((byte[])block.clone());
        }
        this.nextWrite = other.nextWrite;
    }

    void readPackedValue(int index, byte[] bytes) {
        assert (bytes.length == this.packedBytesLength);
        int block = index / this.valuesPerBlock;
        int blockIndex = index % this.valuesPerBlock;
        System.arraycopy(this.blocks.get(block), blockIndex * this.packedBytesLength, bytes, 0, this.packedBytesLength);
    }

    void writePackedValue(int index, byte[] bytes) {
        assert (bytes.length == this.packedBytesLength);
        int block = index / this.valuesPerBlock;
        int blockIndex = index % this.valuesPerBlock;
        while (this.blocks.size() <= block) {
            int valuesInBlock = Math.min(this.valuesPerBlock, this.maxSize - this.blocks.size() * this.valuesPerBlock);
            this.blocks.add(new byte[valuesInBlock * this.packedBytesLength]);
        }
        System.arraycopy(bytes, 0, this.blocks.get(block), blockIndex * this.packedBytesLength, this.packedBytesLength);
    }

    private int[] growExact(int[] arr, int size) {
        assert (size > arr.length);
        int[] newArr = new int[size];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }

    private long[] growExact(long[] arr, int size) {
        assert (size > arr.length);
        long[] newArr = new long[size];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }

    @Override
    public void append(byte[] packedValue, long ord, int docID) {
        assert (!this.closed);
        assert (packedValue.length == this.packedBytesLength);
        if (this.ords.length == this.nextWrite) {
            int nextSize = Math.min(this.maxSize, ArrayUtil.oversize(this.nextWrite + 1, 4));
            assert (nextSize > this.nextWrite) : "nextSize=" + nextSize + " vs nextWrite=" + this.nextWrite;
            this.ords = this.growExact(this.ords, nextSize);
            this.docIDs = this.growExact(this.docIDs, nextSize);
        }
        this.writePackedValue(this.nextWrite, packedValue);
        this.ords[this.nextWrite] = ord;
        this.docIDs[this.nextWrite] = docID;
        ++this.nextWrite;
    }

    @Override
    public PointReader getReader(long start, long length) {
        assert (start + length <= (long)this.docIDs.length) : "start=" + start + " length=" + length + " docIDs.length=" + this.docIDs.length;
        return new HeapPointReader(this.blocks, this.valuesPerBlock, this.packedBytesLength, this.ords, this.docIDs, (int)start, this.nextWrite);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "HeapPointWriter(count=" + this.nextWrite + " alloc=" + this.docIDs.length + ")";
    }
}

