/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.video;

import io.humble.video.Decoder;
import io.humble.video.Demuxer;
import io.humble.video.DemuxerStream;
import io.humble.video.Global;
import io.humble.video.KeyValueBag;
import io.humble.video.MediaDescriptor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.util.IoUtil;
import org.modeshape.sequencer.video.StreamMetadata;

public class VideoMetadata {
    static final String[] MIME_TYPE_STRINGS = new String[]{"video/x-matroska", "video/quicktime", "video/x-msvideo", "video/x-ms-wmv", "video/x-flv", "video/3gpp", "video/webm", "video/mp4", "video/ogg"};
    private Double duration;
    private Integer bitrate;
    private String title;
    private String comment;
    private String encoder;
    private List<StreamMetadata> streams = new ArrayList<StreamMetadata>();
    private InputStream in;

    public VideoMetadata(InputStream inputStream) {
        this.in = inputStream;
    }

    public boolean check() throws Exception {
        File fileCopy = File.createTempFile("modeshape-sequencer-video", ".tmp");
        IoUtil.write((InputStream)this.in, (OutputStream)new BufferedOutputStream(new FileOutputStream(fileCopy)));
        Demuxer container = Demuxer.make();
        container.open(fileCopy.getAbsolutePath(), null, false, true, null, null);
        boolean deleted = false;
        try {
            deleted = fileCopy.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!deleted) {
            fileCopy.deleteOnExit();
        }
        KeyValueBag metadata = container.getMetaData();
        for (String key : metadata.getKeys()) {
            if (key.toLowerCase().equals("title")) {
                this.title = metadata.getValue(key);
            }
            if (key.toLowerCase().equals("comment")) {
                this.comment = metadata.getValue(key);
            }
            if (!key.toLowerCase().equals("encoder")) continue;
            this.encoder = metadata.getValue(key);
        }
        if (container.getDuration() != Global.NO_PTS) {
            this.duration = (double)container.getDuration() / 1000.0 / 1000.0;
        }
        if (container.getBitRate() > 0) {
            this.bitrate = container.getBitRate();
        }
        for (int i = 0; i < container.getNumStreams(); ++i) {
            StreamMetadata streamMetadata = new StreamMetadata();
            DemuxerStream stream = container.getStream(i);
            Decoder coder = stream.getDecoder();
            if (coder.getCodecType() == MediaDescriptor.Type.MEDIA_AUDIO) {
                streamMetadata.setStreamType("audio");
            } else if (coder.getCodecType() == MediaDescriptor.Type.MEDIA_VIDEO) {
                streamMetadata.setStreamType("video");
            } else {
                streamMetadata.setStreamType("unknown");
            }
            if (coder.getCodec() != null) {
                streamMetadata.setCodec(coder.getCodec().getName());
            }
            streamMetadata.setSamplerate(this.nullValueIfInvalid(coder.getSampleRate()));
            streamMetadata.setChannels(this.nullValueIfInvalid(coder.getChannels()));
            streamMetadata.setWidth(this.nullValueIfInvalid(coder.getWidth()));
            streamMetadata.setHeight(this.nullValueIfInvalid(coder.getHeight()));
            if (coder.getTimeBase() != null) {
                streamMetadata.setFramerate(this.nullValueIfInvalid(1.0 / coder.getTimeBase().getDouble()));
            }
            this.streams.add(streamMetadata);
        }
        container.close();
        return true;
    }

    private Integer nullValueIfInvalid(int value) {
        if (value > 0) {
            return value;
        }
        return null;
    }

    private Double nullValueIfInvalid(double value) {
        if (value > 0.0) {
            return value;
        }
        return null;
    }

    public Double getDuration() {
        return this.duration;
    }

    public Integer getBitrate() {
        return this.bitrate;
    }

    public String getTitle() {
        return this.title;
    }

    public String getComment() {
        return this.comment;
    }

    public String getEncoder() {
        return this.encoder;
    }

    public List<StreamMetadata> getStreams() {
        return this.streams;
    }
}

