/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.ConfigurationException;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.document.Changes;
import org.modeshape.schematic.document.EditableDocument;
import org.modeshape.schematic.document.Editor;

public class SequencerService
implements Service<JcrRepository> {
    private final InjectedValue<ModeShapeEngine> engineInjector = new InjectedValue();
    private final InjectedValue<JcrRepository> jcrRepositoryInjector = new InjectedValue();
    private final Properties sequencerProperties;
    private final String repositoryName;

    public SequencerService(String repositoryName, Properties sequencerProperties) {
        this.repositoryName = repositoryName;
        this.sequencerProperties = sequencerProperties;
    }

    public JcrRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return (JcrRepository)this.jcrRepositoryInjector.getValue();
    }

    private ModeShapeEngine getModeShapeEngine() {
        return (ModeShapeEngine)this.engineInjector.getValue();
    }

    public void start(StartContext arg0) throws StartException {
        ModeShapeEngine engine = this.getModeShapeEngine();
        JcrRepository repository = null;
        try {
            repository = engine.getRepository(this.repositoryName);
        }
        catch (NoSuchRepositoryException e) {
            throw new StartException((Throwable)e);
        }
        RepositoryConfiguration repositoryConfig = repository.getConfiguration();
        Editor editor = repositoryConfig.edit();
        EditableDocument sequencing = editor.getOrCreateDocument("sequencing");
        EditableDocument sequencers = sequencing.getOrCreateDocument("sequencers");
        EditableDocument seq = Schematic.newDocument();
        String sequencerName = this.sequencerProperties.getProperty("name");
        for (Object key : this.sequencerProperties.keySet()) {
            String keyStr = (String)key;
            if ("name".equals(keyStr)) continue;
            Object value = this.sequencerProperties.get(keyStr);
            if (value instanceof List) {
                for (Object val : (List)value) {
                    seq.getOrCreateArray(keyStr).addValue(val);
                }
                continue;
            }
            seq.set(keyStr, value);
        }
        sequencers.set(sequencerName, (Object)seq);
        Changes changes = editor.getChanges();
        Problems validationResults = repositoryConfig.validate(changes);
        if (validationResults.hasErrors()) {
            String msg = JcrI18n.errorsInRepositoryConfiguration.text(new Object[]{this.repositoryName, validationResults.errorCount(), validationResults.toString()});
            throw new StartException(msg);
        }
        try {
            engine.update(this.repositoryName, changes);
        }
        catch (RepositoryException | ConfigurationException e) {
            throw new StartException(e);
        }
    }

    public void stop(StopContext arg0) {
    }

    public InjectedValue<ModeShapeEngine> getModeShapeEngineInjector() {
        return this.engineInjector;
    }

    public InjectedValue<JcrRepository> getJcrRepositoryInjector() {
        return this.jcrRepositoryInjector;
    }
}

