/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.modeshape.jboss.subsystem.AbstractAddBinaryStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.schematic.document.EditableDocument;

public class AddCustomBinaryStorage
extends AbstractAddBinaryStorage {
    public static final AddCustomBinaryStorage INSTANCE = new AddCustomBinaryStorage();
    private static final List<String> COMMON_BINARY_ATTRIBUTES = Arrays.asList("mime-type-detection", "minimum-binary-size", "minimum-string-size", "store-name");

    private AddCustomBinaryStorage() {
    }

    @Override
    protected void writeBinaryStorageConfiguration(String repositoryName, OperationContext context, ModelNode model, EditableDocument binaries) {
        binaries.set("type", (Object)"custom");
        model.asPropertyList().forEach(property -> this.writeCustomProperty(binaries, (Property)property));
    }

    private void writeCustomProperty(EditableDocument binaries, Property property) {
        ModelNode value = property.getValue();
        if (!value.isDefined()) {
            return;
        }
        String name = property.getName();
        if (COMMON_BINARY_ATTRIBUTES.contains(name)) {
            return;
        }
        if (name.equals("classname")) {
            name = "classname";
        } else if (name.equals("module")) {
            name = "classloader";
        }
        binaries.set(name, (Object)value.asString());
        this.logger.debugv("added custom binary property [{0} = {1}]", (Object)name, (Object)value.asString());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddCustomBinaryStorage.populate(operation, model, ModelAttributes.CUSTOM_BINARY_STORAGE_ATTRIBUTES);
    }
}

