/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.services.path.RelativePathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.service.BinaryStorageService;
import org.modeshape.jboss.subsystem.AbstractAddBinaryStorage;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.schematic.document.EditableDocument;

public class AddFileBinaryStorage
extends AbstractAddBinaryStorage {
    public static final AddFileBinaryStorage INSTANCE = new AddFileBinaryStorage();
    private String binaryStoragePathInDataDirectory;

    private AddFileBinaryStorage() {
    }

    @Override
    protected void writeBinaryStorageConfiguration(String repositoryName, OperationContext context, ModelNode model, EditableDocument binaries) throws OperationFailedException {
        binaries.set("type", (Object)"file");
        ModelNode pathNode = ModelAttributes.PATH.resolveModelAttribute(context, model);
        String path = pathNode.isDefined() ? pathNode.asString() : "modeshape/" + repositoryName + "/binaries";
        ModelNode trashNode = ModelAttributes.TRASH.resolveModelAttribute(context, model);
        String trash = trashNode.isDefined() ? trashNode.asString() : null;
        String relativeTo = ModelAttributes.RELATIVE_TO.resolveModelAttribute(context, model).asString();
        if (relativeTo.equalsIgnoreCase("jboss.server.data.dir")) {
            this.binaryStoragePathInDataDirectory = ".";
            binaries.set("directory", (Object)path);
            if (trash != null) {
                binaries.set("trash", (Object)trash);
            }
        } else {
            if (!relativeTo.endsWith("/")) {
                relativeTo = relativeTo + "/";
            }
            binaries.set("directory", (Object)(relativeTo + path));
            if (trash != null) {
                binaries.set("trash", (Object)(relativeTo + trash));
            }
        }
    }

    @Override
    protected void addControllersAndDependencies(String repositoryName, BinaryStorageService service, ServiceBuilder<BinaryStorage> builder, ServiceTarget target, String binariesStoreName) {
        if (this.binaryStoragePathInDataDirectory != null) {
            ServiceName storageDirectoryServiceName = binariesStoreName != null ? ModeShapeServiceNames.binaryStorageDirectoryServiceName(repositoryName, binariesStoreName) : ModeShapeServiceNames.binaryStorageDirectoryServiceName(repositoryName);
            RelativePathService.addService((ServiceName)storageDirectoryServiceName, (String)this.binaryStoragePathInDataDirectory, (String)"jboss.server.data.dir", (ServiceTarget)target);
            builder.addDependency(storageDirectoryServiceName, String.class, service.getBinaryStorageBasePathInjector());
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddFileBinaryStorage.populate(operation, model, ModelAttributes.FILE_BINARY_STORAGE_ATTRIBUTES);
    }
}

