/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AbstractAddBinaryStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.schematic.document.EditableDocument;

public class AddMongoBinaryStorage
extends AbstractAddBinaryStorage {
    public static final AddMongoBinaryStorage INSTANCE = new AddMongoBinaryStorage();

    private AddMongoBinaryStorage() {
    }

    @Override
    protected void writeBinaryStorageConfiguration(String repositoryName, OperationContext context, ModelNode model, EditableDocument binaries) throws OperationFailedException {
        ModelNode hostAddressesModel;
        ModelNode passwordModel;
        ModelNode userModel;
        binaries.set("type", (Object)"mongo");
        String host = ModelAttributes.MONGO_HOST.resolveModelAttribute(context, model).asString();
        binaries.setString("host", host);
        int port = ModelAttributes.MONGO_PORT.resolveModelAttribute(context, model).asInt();
        binaries.setNumber("port", port);
        ModelNode databaseModel = ModelAttributes.MONGO_DATABASE.resolveModelAttribute(context, model);
        if (databaseModel.isDefined()) {
            binaries.setString("database", databaseModel.asString());
        }
        if ((userModel = ModelAttributes.MONGO_USERNAME.resolveModelAttribute(context, model)).isDefined()) {
            binaries.setString("username", userModel.asString());
        }
        if ((passwordModel = ModelAttributes.MONGO_PASSWORD.resolveModelAttribute(context, model)).isDefined()) {
            binaries.setString("password", passwordModel.asString());
        }
        if ((hostAddressesModel = ModelAttributes.MONGO_HOST_ADDRESSES.resolveModelAttribute(context, model)).isDefined()) {
            binaries.setArray("hostAddresses", (Object[])hostAddressesModel.asString().split(","));
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddMongoBinaryStorage.populate(operation, model, ModelAttributes.MONGO_BINARY_STORAGE_ATTRIBUTES);
    }
}

