/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.modeshape.jboss.subsystem.Attribute;
import org.modeshape.jboss.subsystem.Element;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeSubsystemXMLWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            if (model.hasDefined("repository")) {
                for (Property entry : model.get("repository").asPropertyList()) {
                    String repositoryName = entry.getName();
                    ModelNode repository = entry.getValue();
                    this.writeRepositoryConfiguration(writer, repository, repositoryName);
                }
            }
            if (model.hasDefined("webapp")) {
                for (Property entry : model.get("webapp").asPropertyList()) {
                    String webappName = entry.getName();
                    ModelNode webapp = entry.getValue();
                    this.writeWebAppConfiguration(writer, webapp, webappName);
                }
            }
        }
        writer.writeEndElement();
    }

    private void writeWebAppConfiguration(XMLExtendedStreamWriter writer, ModelNode webapp, String repositoryName) throws XMLStreamException {
        writer.writeStartElement(Element.WEBAPP.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), repositoryName);
        ModelAttributes.EXPLODED.marshallAsAttribute(webapp, false, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeRepositoryConfiguration(XMLExtendedStreamWriter writer, ModelNode repository, String repositoryName) throws XMLStreamException {
        writer.writeStartElement(Element.REPOSITORY.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), repositoryName);
        ModelAttributes.JNDI_NAME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.ENABLE_MONITORING.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.SECURITY_DOMAIN.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.CLUSTER_NAME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.CLUSTER_STACK.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.CLUSTER_CONFIG.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.CLUSTER_LOCKING.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        this.writeAttributeAsList(writer, repository, ModelAttributes.ANONYMOUS_ROLES);
        ModelAttributes.ANONYMOUS_USERNAME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.USE_ANONYMOUS_IF_AUTH_FAILED.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.GARBAGE_COLLECTION_THREAD_POOL.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.GARBAGE_COLLECTION_INITIAL_TIME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.GARBAGE_COLLECTION_INTERVAL.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.DOCUMENT_OPTIMIZATION_THREAD_POOL.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.DOCUMENT_OPTIMIZATION_INITIAL_TIME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.DOCUMENT_OPTIMIZATION_INTERVAL.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.DOCUMENT_OPTIMIZATION_CHILD_COUNT_TARGET.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.DOCUMENT_OPTIMIZATION_CHILD_COUNT_TOLERANCE.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.EVENT_BUS_SIZE.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.LOCK_TIMEOUT_MILLIS.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.REPOSITORY_MODULE_DEPENDENCIES.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        this.writePersistence(writer, repository);
        this.writeNodeTypes(writer, repository);
        this.writeWorkspaces(writer, repository);
        this.writeJournaling(writer, repository);
        this.writeAuthenticators(writer, repository);
        this.writeIndexProviders(writer, repository);
        this.writeIndexes(writer, repository);
        this.writeReindexing(writer, repository);
        this.writeBinaryStorage(writer, repository);
        this.writeSequencing(writer, repository);
        this.writeExternalSources(writer, repository);
        this.writeTextExtraction(writer, repository);
        writer.writeEndElement();
    }

    private void writePersistence(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        String filePersistence;
        String dbPersistence = Attribute.DB_PERSISTENCE.getLocalName();
        if (this.has(repository, dbPersistence)) {
            this.startIfNeeded(writer, Element.DB_PERSISTENCE, false);
            ModelNode persistence = repository.get(dbPersistence).get(dbPersistence);
            ModelAttributes.TABLE_NAME.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            ModelAttributes.CREATE_ON_START.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            ModelAttributes.DROP_ON_EXIT.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            ModelAttributes.CONNECTION_URL.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            ModelAttributes.DRIVER.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            ModelAttributes.USERNAME.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            ModelAttributes.PASSWORD.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            ModelAttributes.DB_COMPRESS.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            ModelAttributes.FETCH_SIZE.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            ModelAttributes.POOL_SIZE.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            ModelAttributes.PERSISTENCE_DS_JNDI_NAME.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (this.has(repository, filePersistence = Attribute.FS_PERSISTENCE.getLocalName())) {
            this.startIfNeeded(writer, Element.FILE_PERSISTENCE, false);
            ModelNode persistence = repository.get(filePersistence).get(filePersistence);
            ModelAttributes.FS_PATH.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            ModelAttributes.FS_COMPRESS.marshallAsAttribute(persistence, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeNodeTypes(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        boolean started = false;
        if (this.has(repository, "node-types")) {
            started = this.startIfNeeded(writer, Element.NODE_TYPES, started);
            List nodeTypes = repository.get("node-types").asList();
            for (ModelNode nodeType : nodeTypes) {
                writer.writeStartElement(Element.NODE_TYPE.getLocalName());
                writer.writeCharacters(nodeType.asString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeWorkspaces(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        boolean started = false;
        if (ModelAttributes.DEFAULT_WORKSPACE.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelAttributes.DEFAULT_WORKSPACE.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.ALLOW_WORKSPACE_CREATION.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelAttributes.ALLOW_WORKSPACE_CREATION.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.WORKSPACES_CACHE_SIZE.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelAttributes.WORKSPACES_CACHE_SIZE.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (this.has(repository, "predefined-workspace-names")) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelNode names = repository.get("predefined-workspace-names");
            if (names.isDefined()) {
                HashMap<String, String> workspacesInitialContent = new HashMap<String, String>();
                if (this.has(repository, "workspaces-initial-content")) {
                    List initialContentNodes = repository.get("workspaces-initial-content").asList();
                    for (ModelNode modelNode : initialContentNodes) {
                        Property property = modelNode.asProperty();
                        workspacesInitialContent.put(property.getName(), property.getValue().asString());
                    }
                }
                for (ModelNode workspace : repository.get("predefined-workspace-names").asList()) {
                    writer.writeStartElement(Element.WORKSPACE.getLocalName());
                    String name = workspace.asString();
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    if (workspacesInitialContent.containsKey(name)) {
                        writer.writeStartElement(Element.INITIAL_CONTENT.getLocalName());
                        writer.writeCharacters((String)workspacesInitialContent.get(name));
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
        }
        if (this.has(repository, "default-initial-content")) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            writer.writeStartElement(Element.INITIAL_CONTENT.getLocalName());
            writer.writeCharacters(repository.get("default-initial-content").asString());
            writer.writeEndElement();
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private void writeReindexing(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        boolean started = false;
        if (ModelAttributes.REINDEXING_ASYNC.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.REINDEXIG, started);
            ModelAttributes.REINDEXING_ASYNC.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.REINDEXING_MODE.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.REINDEXIG, started);
            ModelAttributes.REINDEXING_MODE.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private void writeJournaling(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        boolean started = false;
        if (ModelAttributes.JOURNAL_ENABLED.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.JOURNAL_ENABLED.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.JOURNAL_PATH.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.JOURNAL_PATH.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.JOURNAL_RELATIVE_TO.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.JOURNAL_RELATIVE_TO.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.MAX_DAYS_TO_KEEP_RECORDS.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.MAX_DAYS_TO_KEEP_RECORDS.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.ASYNC_WRITES.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.ASYNC_WRITES.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.JOURNAL_GC_INITIAL_TIME.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.JOURNAL_GC_INITIAL_TIME.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.JOURNAL_GC_THREAD_POOL.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.JOURNAL_GC_THREAD_POOL.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private boolean startIfNeeded(XMLExtendedStreamWriter writer, Element name, boolean alreadyStarted) throws XMLStreamException {
        if (!alreadyStarted) {
            writer.writeStartElement(name.getLocalName());
        }
        return true;
    }

    private void writeBinaryStorage(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "configuration", "binary-storage")) {
            ModelNode configuration = repository.get("configuration");
            ModelNode binaryStorage = configuration.get("binary-storage");
            ModelNode binaryStorageType = binaryStorage.get("storage-type");
            String storageType = binaryStorageType.isDefined() && binaryStorageType.keys().size() == 1 ? (String)binaryStorageType.keys().toArray()[0] : null;
            ModelNode storage = storageType != null ? binaryStorageType.get((String)binaryStorageType.keys().toArray()[0]) : new ModelNode();
            this.writeBinaryStorageModel(writer, storageType, storage);
        }
    }

    private void writeBinaryStorageModel(XMLExtendedStreamWriter writer, String storageType, ModelNode storage) throws XMLStreamException {
        if ("transient-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.TRANSIENT_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MIME_TYPE_DETECTION.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if ("file-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.FILE_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.PATH.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.TRASH.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.RELATIVE_TO.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.STORE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MIME_TYPE_DETECTION.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if ("db-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.DB_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.DATA_SOURCE_JNDI_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.STORE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MIME_TYPE_DETECTION.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if ("cassandra-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.CASSANDRA_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MIME_TYPE_DETECTION.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.CASSANDRA_HOST.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if ("mongo-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.MONGO_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MIME_TYPE_DETECTION.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MONGO_HOST.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MONGO_PORT.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MONGO_DATABASE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MONGO_USERNAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MONGO_PASSWORD.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MONGO_HOST_ADDRESSES.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if ("s3-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.S3_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MIME_TYPE_DETECTION.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.S3_BUCKET_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.S3_USERNAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.S3_PASSWORD.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if ("composite-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.COMPOSITE_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.STORE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MIME_TYPE_DETECTION.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            this.writeNestedStoresOfType(storage, "nested-storage-type-file", "file-binary-storage", writer);
            this.writeNestedStoresOfType(storage, "nested-storage-type-db", "db-binary-storage", writer);
            this.writeNestedStoresOfType(storage, "nested-storage-type-custom", "custom-binary-storage", writer);
            writer.writeEndElement();
        } else if ("custom-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.CUSTOM_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.STORE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MIME_TYPE_DETECTION.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            List<String> toSkip = Arrays.asList("minimum-binary-size", "minimum-string-size", "store-name", "mime-type-detection");
            storage.keys().stream().filter(key -> !toSkip.contains(key)).forEach(key -> {
                try {
                    switch (key) {
                        case "classname": {
                            ModelAttributes.CLASSNAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                            break;
                        }
                        case "module": {
                            ModelAttributes.MODULE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                            break;
                        }
                        default: {
                            writer.writeAttribute(key, storage.get(key).asString());
                            break;
                        }
                    }
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            });
            writer.writeEndElement();
        }
    }

    private void writeNestedStoresOfType(ModelNode storage, String nestedStorageType, String storeType, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (this.has(storage, nestedStorageType)) {
            List nestedCacheStores = storage.get(nestedStorageType).asList();
            for (ModelNode nestedStore : nestedCacheStores) {
                String storeName = (String)nestedStore.keys().toArray()[0];
                this.writeBinaryStorageModel(writer, storeType, nestedStore.get(storeName));
            }
        }
    }

    private void writeAuthenticators(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "authenticator")) {
            writer.writeStartElement(Element.AUTHENTICATORS.getLocalName());
            for (Property authenticator : repository.get("authenticator").asPropertyList()) {
                writer.writeStartElement(Element.AUTHENTICATOR.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), authenticator.getName());
                ModelNode prop = authenticator.getValue();
                ModelAttributes.AUTHENTICATOR_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeSequencing(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "sequencer")) {
            writer.writeStartElement(Element.SEQUENCERS.getLocalName());
            if (repository.hasDefined("sequencers-thread-pool-name")) {
                writer.writeAttribute(Attribute.THREAD_POOL_NAME.getLocalName(), repository.get("sequencers-thread-pool-name").asString());
            }
            if (repository.hasDefined("sequencers-max-pool-size")) {
                writer.writeAttribute(Attribute.MAX_POOL_SIZE.getLocalName(), repository.get("sequencers-max-pool-size").asString());
            }
            ModelNode sequencerNode = repository.get("sequencer");
            for (Property sequencer : sequencerNode.asPropertyList()) {
                writer.writeStartElement(Element.SEQUENCER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), sequencer.getName());
                ModelNode prop = sequencer.getValue();
                ModelAttributes.SEQUENCER_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                if (this.has(prop, "path-expressions")) {
                    List pathExpressions = prop.get("path-expressions").asList();
                    switch (pathExpressions.size()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            ModelNode pathExpression = (ModelNode)pathExpressions.iterator().next();
                            writer.writeAttribute(Attribute.PATH_EXPRESSION.getLocalName(), pathExpression.asString());
                            break;
                        }
                        default: {
                            for (ModelNode pathExpr : pathExpressions) {
                                writer.writeStartElement(Element.PATH_EXPRESSION.getLocalName());
                                writer.writeCharacters(pathExpr.asString());
                                writer.writeEndElement();
                            }
                        }
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeIndexProviders(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "index-provider")) {
            writer.writeStartElement(Element.INDEX_PROVIDERS.getLocalName());
            ModelNode providerNode = repository.get("index-provider");
            for (Property provider : providerNode.asPropertyList()) {
                writer.writeStartElement(Element.INDEX_PROVIDER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), provider.getName());
                ModelNode prop = provider.getValue();
                ModelAttributes.CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.RELATIVE_TO.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.PATH.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeIndexes(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "index")) {
            writer.writeStartElement(Element.INDEXES.getLocalName());
            ModelNode providerNode = repository.get("index");
            for (Property index : providerNode.asPropertyList()) {
                writer.writeStartElement(Element.INDEX.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), index.getName());
                ModelNode prop = index.getValue();
                ModelAttributes.PROVIDER_NAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.INDEX_KIND.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.SYNCHRONOUS.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.NODE_TYPE_NAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.INDEX_COLUMNS.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.WORKSPACES.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeExternalSources(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "source")) {
            writer.writeStartElement(Element.EXTERNAL_SOURCES.getLocalName());
            ModelNode externalSourceNode = repository.get("source");
            for (Property externalSource : externalSourceNode.asPropertyList()) {
                writer.writeStartElement(Element.SOURCE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), externalSource.getName());
                ModelNode prop = externalSource.getValue();
                ModelAttributes.CONNECTOR_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.CACHEABLE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.QUERYABLE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.READONLY.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.EXPOSE_AS_WORKSPACE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                if (this.has(prop, "projections")) {
                    List projections = prop.get("projections").asList();
                    for (ModelNode projection : projections) {
                        writer.writeStartElement(Element.PROJECTION.getLocalName());
                        writer.writeCharacters(projection.asString());
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeTextExtraction(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "text-extractor")) {
            writer.writeStartElement(Element.TEXT_EXTRACTORS.getLocalName());
            if (repository.hasDefined("text-extractors-thread-pool-name")) {
                writer.writeAttribute(Attribute.THREAD_POOL_NAME.getLocalName(), repository.get("text-extractors-thread-pool-name").asString());
            }
            if (repository.hasDefined("text-extractors-max-pool-size")) {
                writer.writeAttribute(Attribute.MAX_POOL_SIZE.getLocalName(), repository.get("text-extractors-max-pool-size").asString());
            }
            for (Property extractor : repository.get("text-extractor").asPropertyList()) {
                writer.writeStartElement(Element.TEXT_EXTRACTOR.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), extractor.getName());
                ModelNode prop = extractor.getValue();
                ModelAttributes.TEXT_EXTRACTOR_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private boolean has(ModelNode node, String name) {
        return node.isDefined() && node.has(name) && node.get(name).isDefined();
    }

    private boolean has(ModelNode node, String ... names) {
        for (String name : names) {
            if (!node.isDefined() || !node.has(name)) {
                return false;
            }
            node = node.get(name);
        }
        return true;
    }

    private void writeAttributeAsList(XMLExtendedStreamWriter writer, ModelNode node, ListAttributeDefinition modelAttribute) throws XMLStreamException {
        if (modelAttribute.isMarshallable(node, false)) {
            StringBuilder sb = new StringBuilder();
            Iterator iter = node.get(modelAttribute.getName()).asList().iterator();
            if (iter.hasNext()) {
                sb.append(((ModelNode)iter.next()).asString());
                while (iter.hasNext()) {
                    sb.append(" ").append(((ModelNode)iter.next()).asString());
                }
                writer.writeAttribute(modelAttribute.getXmlName(), sb.toString());
            }
        }
    }
}

