/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.io.IOException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.modeshape.common.util.StringUtil;

public final class ModuleNamesProvider {
    private static final Logger LOG = Logger.getLogger((String)ModuleNamesProvider.class.getPackage().getName());
    private static final Properties MODULE_NAME_BY_COMPONENT_FQN;

    private ModuleNamesProvider() {
    }

    protected static String moduleNameFor(String componentFQN) {
        String moduleName = MODULE_NAME_BY_COMPONENT_FQN.getProperty(componentFQN);
        if (StringUtil.isBlank((String)moduleName)) {
            int index = componentFQN.lastIndexOf(".");
            moduleName = index != -1 ? componentFQN.substring(0, index) : componentFQN;
        }
        LOG.debugv("Module name for {0} has been resolved to {1}", (Object)componentFQN, (Object)moduleName);
        return moduleName;
    }

    static {
        try {
            MODULE_NAME_BY_COMPONENT_FQN = new Properties();
            MODULE_NAME_BY_COMPONENT_FQN.load(ModuleNamesProvider.class.getResourceAsStream("modules.properties"));
            if (MODULE_NAME_BY_COMPONENT_FQN.isEmpty()) {
                throw new IllegalArgumentException("Cannot load the module names mapping file");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

