/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LatLonPointDistanceQuery;
import org.apache.lucene.document.LatLonPointInPolygonQuery;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.util.GeoUtils;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class LatLonPoint
extends Field {
    public static final FieldType TYPE = new FieldType();
    private static final int BITS = 32;
    private static final double LONGITUDE_SCALE = 1.1930464711111112E7;
    private static final double LATITUDE_SCALE = 2.3860929422222223E7;

    public void setLocationValue(double latitude, double longitude) {
        byte[] bytes = new byte[8];
        NumericUtils.intToSortableBytes((int)LatLonPoint.encodeLatitude(latitude), (byte[])bytes, (int)0);
        NumericUtils.intToSortableBytes((int)LatLonPoint.encodeLongitude(longitude), (byte[])bytes, (int)4);
        this.fieldsData = new BytesRef(bytes);
    }

    public LatLonPoint(String name, double latitude, double longitude) {
        super(name, TYPE);
        this.setLocationValue(latitude, longitude);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(((Object)((Object)this)).getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        result.append(LatLonPoint.decodeLatitude(BytesRef.deepCopyOf((BytesRef)bytes).bytes, 0));
        result.append(',');
        result.append(LatLonPoint.decodeLongitude(BytesRef.deepCopyOf((BytesRef)bytes).bytes, 4));
        result.append('>');
        return result.toString();
    }

    public static int encodeLatitude(double latitude) {
        GeoUtils.checkLatitude((double)latitude);
        if (latitude == 90.0) {
            latitude = Math.nextDown(latitude);
        }
        return Math.toIntExact((long)(latitude * 2.3860929422222223E7));
    }

    public static int encodeLongitude(double longitude) {
        GeoUtils.checkLongitude((double)longitude);
        if (longitude == 180.0) {
            longitude = Math.nextDown(longitude);
        }
        return Math.toIntExact((long)(longitude * 1.1930464711111112E7));
    }

    public static double decodeLatitude(int encoded) {
        double result = (double)encoded / 2.3860929422222223E7;
        assert (result >= -90.0 && result <= 90.0);
        return result;
    }

    public static double decodeLatitude(byte[] src, int offset) {
        return LatLonPoint.decodeLatitude(NumericUtils.sortableBytesToInt((byte[])src, (int)offset));
    }

    public static double decodeLongitude(int encoded) {
        double result = (double)encoded / 1.1930464711111112E7;
        assert (result >= -180.0 && result <= 180.0);
        return result;
    }

    public static double decodeLongitude(byte[] src, int offset) {
        return LatLonPoint.decodeLongitude(NumericUtils.sortableBytesToInt((byte[])src, (int)offset));
    }

    private static byte[] encode(double latitude, double longitude) {
        byte[] bytes = new byte[8];
        NumericUtils.intToSortableBytes((int)LatLonPoint.encodeLatitude(latitude), (byte[])bytes, (int)0);
        NumericUtils.intToSortableBytes((int)LatLonPoint.encodeLongitude(longitude), (byte[])bytes, (int)4);
        return bytes;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getPointDimensionCount() != TYPE.pointDimensionCount()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with numDims=" + fieldInfo.getPointDimensionCount() + " but this point type has numDims=" + TYPE.pointDimensionCount() + ", is the field really a LatLonPoint?");
        }
        if (fieldInfo.getPointNumBytes() != TYPE.pointNumBytes()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with bytesPerDim=" + fieldInfo.getPointNumBytes() + " but this point type has bytesPerDim=" + TYPE.pointNumBytes() + ", is the field really a LatLonPoint?");
        }
    }

    public static Query newBoxQuery(String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        byte[] lower = LatLonPoint.encode(minLatitude, minLongitude);
        byte[] upper = LatLonPoint.encode(maxLatitude, maxLongitude);
        if (maxLongitude < minLongitude) {
            BooleanQuery.Builder q = new BooleanQuery.Builder();
            q.setDisableCoord(true);
            byte[] leftOpen = (byte[])lower.clone();
            NumericUtils.intToSortableBytes((int)Integer.MIN_VALUE, (byte[])leftOpen, (int)4);
            Query left = LatLonPoint.newBoxInternal(field, leftOpen, upper);
            q.add(new BooleanClause(left, BooleanClause.Occur.SHOULD));
            byte[] rightOpen = (byte[])upper.clone();
            NumericUtils.intToSortableBytes((int)Integer.MAX_VALUE, (byte[])rightOpen, (int)4);
            Query right = LatLonPoint.newBoxInternal(field, lower, rightOpen);
            q.add(new BooleanClause(right, BooleanClause.Occur.SHOULD));
            return new ConstantScoreQuery((Query)q.build());
        }
        return LatLonPoint.newBoxInternal(field, lower, upper);
    }

    private static Query newBoxInternal(String field, byte[] min, byte[] max) {
        return new PointRangeQuery(field, min, max, 2){

            protected String toString(int dimension, byte[] value) {
                if (dimension == 0) {
                    return Double.toString(LatLonPoint.decodeLatitude(value, 0));
                }
                if (dimension == 1) {
                    return Double.toString(LatLonPoint.decodeLongitude(value, 0));
                }
                throw new AssertionError();
            }
        };
    }

    public static Query newDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        return new LatLonPointDistanceQuery(field, latitude, longitude, radiusMeters);
    }

    public static Query newPolygonQuery(String field, double[] polyLats, double[] polyLons) {
        return new LatLonPointInPolygonQuery(field, polyLats, polyLons);
    }

    static {
        TYPE.setDimensions(2, 4);
        TYPE.freeze();
    }
}

