/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic;

import java.util.Collection;
import java.util.List;
import org.modeshape.schematic.Lifecycle;
import org.modeshape.schematic.Lockable;
import org.modeshape.schematic.SchematicEntry;
import org.modeshape.schematic.TransactionListener;
import org.modeshape.schematic.annotation.RequiresTransaction;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableDocument;

public interface SchematicDb
extends TransactionListener,
Lifecycle,
Lockable {
    public String id();

    public List<String> keys();

    public Document get(String var1);

    public List<SchematicEntry> load(Collection<String> var1);

    @RequiresTransaction
    public void put(String var1, SchematicEntry var2);

    @RequiresTransaction
    public EditableDocument editContent(String var1, boolean var2);

    @RequiresTransaction
    public SchematicEntry putIfAbsent(String var1, Document var2);

    @RequiresTransaction
    public boolean remove(String var1);

    @RequiresTransaction
    public void removeAll();

    @RequiresTransaction
    default public void put(String key, Document content) {
        this.put(key, SchematicEntry.create(key, content));
    }

    @Override
    @RequiresTransaction
    default public boolean lockForWriting(List<String> locks) {
        throw new UnsupportedOperationException(this.getClass() + " does not support exclusive locking");
    }

    default public SchematicEntry getEntry(String key) {
        Document doc = this.get(key);
        return doc != null ? () -> doc : null;
    }

    default public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    @RequiresTransaction
    default public void putEntry(Document entryDocument) {
        SchematicEntry entry = SchematicEntry.fromDocument(entryDocument);
        this.put(entry.id(), entry);
    }
}

